"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericLogDriver = void 0;
const index_1 = require("../index");
const utils_1 = require("./utils");
/**
 * A log driver that sends logs to the specified driver.
 */
class GenericLogDriver extends index_1.LogDriver {
    /**
     * Constructs a new instance of the GenericLogDriver class.
     *
     * @param props the generic log driver configuration options.
     */
    constructor(props) {
        super();
        this.logDriver = props.logDriver;
        this.options = props.options || {};
    }
    /**
     * Called when the log driver is configured on a container.
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: this.logDriver,
            options: utils_1.removeEmpty(this.options),
        };
    }
}
exports.GenericLogDriver = GenericLogDriver;
//# sourceMappingURL=data:application/json;base64,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