"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLogDriver = exports.AwsLogDriverMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const logs = require("../../../aws-logs"); // Automatically re-written from '@aws-cdk/aws-logs'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * (experimental) awslogs provides two modes for delivering messages from the container to the log driver.
 *
 * @experimental
 */
var AwsLogDriverMode;
(function (AwsLogDriverMode) {
    AwsLogDriverMode["BLOCKING"] = "blocking";
    AwsLogDriverMode["NON_BLOCKING"] = "non-blocking";
})(AwsLogDriverMode = exports.AwsLogDriverMode || (exports.AwsLogDriverMode = {}));
/**
 * (experimental) A log driver that sends log information to CloudWatch Logs.
 *
 * @experimental
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * (experimental) Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(scope, containerDefinition) {
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': core_1.Stack.of(containerDefinition).region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
                'mode': this.props.mode,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
_a = JSII_RTTI_SYMBOL_1;
AwsLogDriver[_a] = { fqn: "monocdk.aws_ecs.AwsLogDriver", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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