import * as logs from "../../../aws-logs";
import { ContainerDefinition } from '../container-definition';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) awslogs provides two modes for delivering messages from the container to the log driver.
 *
 * @experimental
 */
export declare enum AwsLogDriverMode {
    /**
     * (experimental) (default) direct, blocking delivery from container to driver.
     *
     * @experimental
     */
    BLOCKING = "blocking",
    /**
     * (experimental) The non-blocking message delivery mode prevents applications from blocking due to logging back pressure.
     *
     * Applications are likely to fail in unexpected ways when STDERR or STDOUT streams block.
     *
     * @experimental
     */
    NON_BLOCKING = "non-blocking"
}
/**
 * (experimental) Specifies the awslogs log driver configuration options.
 *
 * @experimental
 */
export interface AwsLogDriverProps {
    /**
     * (experimental) Prefix for the log streams.
     *
     * The awslogs-stream-prefix option allows you to associate a log stream
     * with the specified prefix, the container name, and the ID of the Amazon
     * ECS task to which the container belongs. If you specify a prefix with
     * this option, then the log stream takes the following format:
     *
     *      prefix-name/container-name/ecs-task-id
     *
     * @experimental
     */
    readonly streamPrefix: string;
    /**
     * (experimental) The log group to log to.
     *
     * @default - A log group is automatically created.
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * (experimental) The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
     *
     * @default - Logs never expire.
     * @experimental
     */
    readonly logRetention?: logs.RetentionDays;
    /**
     * (experimental) This option defines a multiline start pattern in Python strftime format.
     *
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     *
     * @default - No multiline matching.
     * @experimental
     */
    readonly datetimeFormat?: string;
    /**
     * (experimental) This option defines a multiline start pattern using a regular expression.
     *
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     *
     * This option is ignored if datetimeFormat is also configured.
     *
     * @default - No multiline matching.
     * @experimental
     */
    readonly multilinePattern?: string;
    /**
     * (experimental) The delivery mode of log messages from the container to awslogs.
     *
     * @default - AwsLogDriverMode.BLOCKING
     * @experimental
     */
    readonly mode?: AwsLogDriverMode;
}
/**
 * (experimental) A log driver that sends log information to CloudWatch Logs.
 *
 * @experimental
 */
export declare class AwsLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) The log group to send log streams to.
     *
     * Only available after the LogDriver has been bound to a ContainerDefinition.
     *
     * @experimental
     */
    logGroup?: logs.ILogGroup;
    /**
     * (experimental) Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     * @experimental
     */
    constructor(props: AwsLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): LogDriverConfig;
}
