"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmpfsMountOption = exports.DevicePermission = exports.Capability = exports.LinuxParameters = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Linux-specific options that are applied to the container.
 *
 * @experimental
 */
class LinuxParameters extends core_1.Construct {
    /**
     * (experimental) Constructs a new instance of the LinuxParameters class.
     *
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * Capabilities to be added
         */
        this.capAdd = new Array();
        /**
         * Capabilities to be dropped
         */
        this.capDrop = new Array();
        /**
         * Device mounts
         */
        this.devices = new Array();
        /**
         * TmpFs mounts
         */
        this.tmpfs = new Array();
        this.sharedMemorySize = props.sharedMemorySize;
        this.initProcessEnabled = props.initProcessEnabled;
    }
    /**
     * (experimental) Adds one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addCapabilities(...cap) {
        this.capAdd.push(...cap);
    }
    /**
     * (experimental) Removes one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    dropCapabilities(...cap) {
        this.capDrop.push(...cap);
    }
    /**
     * (experimental) Adds one or more host devices to a container.
     *
     * @experimental
     */
    addDevices(...device) {
        this.devices.push(...device);
    }
    /**
     * (experimental) Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addTmpfs(...tmpfs) {
        this.tmpfs.push(...tmpfs);
    }
    /**
     * (experimental) Renders the Linux parameters to a CloudFormation object.
     *
     * @experimental
     */
    renderLinuxParameters() {
        return {
            initProcessEnabled: this.initProcessEnabled,
            sharedMemorySize: this.sharedMemorySize,
            capabilities: {
                add: cdk.Lazy.list({ produce: () => this.capAdd }, { omitEmpty: true }),
                drop: cdk.Lazy.list({ produce: () => this.capDrop }, { omitEmpty: true }),
            },
            devices: cdk.Lazy.any({ produce: () => this.devices.map(renderDevice) }, { omitEmptyArray: true }),
            tmpfs: cdk.Lazy.any({ produce: () => this.tmpfs.map(renderTmpfs) }, { omitEmptyArray: true }),
        };
    }
}
exports.LinuxParameters = LinuxParameters;
_a = JSII_RTTI_SYMBOL_1;
LinuxParameters[_a] = { fqn: "monocdk.aws_ecs.LinuxParameters", version: "1.106.1" };
function renderDevice(device) {
    return {
        containerPath: device.containerPath,
        hostPath: device.hostPath,
        permissions: device.permissions,
    };
}
function renderTmpfs(tmpfs) {
    return {
        containerPath: tmpfs.containerPath,
        size: tmpfs.size,
        mountOptions: tmpfs.mountOptions,
    };
}
/**
 * (experimental) A Linux capability.
 *
 * @experimental
 */
var Capability;
(function (Capability) {
    Capability["ALL"] = "ALL";
    Capability["AUDIT_CONTROL"] = "AUDIT_CONTROL";
    Capability["AUDIT_WRITE"] = "AUDIT_WRITE";
    Capability["BLOCK_SUSPEND"] = "BLOCK_SUSPEND";
    Capability["CHOWN"] = "CHOWN";
    Capability["DAC_OVERRIDE"] = "DAC_OVERRIDE";
    Capability["DAC_READ_SEARCH"] = "DAC_READ_SEARCH";
    Capability["FOWNER"] = "FOWNER";
    Capability["FSETID"] = "FSETID";
    Capability["IPC_LOCK"] = "IPC_LOCK";
    Capability["IPC_OWNER"] = "IPC_OWNER";
    Capability["KILL"] = "KILL";
    Capability["LEASE"] = "LEASE";
    Capability["LINUX_IMMUTABLE"] = "LINUX_IMMUTABLE";
    Capability["MAC_ADMIN"] = "MAC_ADMIN";
    Capability["MAC_OVERRIDE"] = "MAC_OVERRIDE";
    Capability["MKNOD"] = "MKNOD";
    Capability["NET_ADMIN"] = "NET_ADMIN";
    Capability["NET_BIND_SERVICE"] = "NET_BIND_SERVICE";
    Capability["NET_BROADCAST"] = "NET_BROADCAST";
    Capability["NET_RAW"] = "NET_RAW";
    Capability["SETFCAP"] = "SETFCAP";
    Capability["SETGID"] = "SETGID";
    Capability["SETPCAP"] = "SETPCAP";
    Capability["SETUID"] = "SETUID";
    Capability["SYS_ADMIN"] = "SYS_ADMIN";
    Capability["SYS_BOOT"] = "SYS_BOOT";
    Capability["SYS_CHROOT"] = "SYS_CHROOT";
    Capability["SYS_MODULE"] = "SYS_MODULE";
    Capability["SYS_NICE"] = "SYS_NICE";
    Capability["SYS_PACCT"] = "SYS_PACCT";
    Capability["SYS_PTRACE"] = "SYS_PTRACE";
    Capability["SYS_RAWIO"] = "SYS_RAWIO";
    Capability["SYS_RESOURCE"] = "SYS_RESOURCE";
    Capability["SYS_TIME"] = "SYS_TIME";
    Capability["SYS_TTY_CONFIG"] = "SYS_TTY_CONFIG";
    Capability["SYSLOG"] = "SYSLOG";
    Capability["WAKE_ALARM"] = "WAKE_ALARM";
})(Capability = exports.Capability || (exports.Capability = {}));
/**
 * (experimental) Permissions for device access.
 *
 * @experimental
 */
var DevicePermission;
(function (DevicePermission) {
    DevicePermission["READ"] = "read";
    DevicePermission["WRITE"] = "write";
    DevicePermission["MKNOD"] = "mknod";
})(DevicePermission = exports.DevicePermission || (exports.DevicePermission = {}));
/**
 * (experimental) The supported options for a tmpfs mount for a container.
 *
 * @experimental
 */
var TmpfsMountOption;
(function (TmpfsMountOption) {
    TmpfsMountOption["DEFAULTS"] = "defaults";
    TmpfsMountOption["RO"] = "ro";
    TmpfsMountOption["RW"] = "rw";
    TmpfsMountOption["SUID"] = "suid";
    TmpfsMountOption["NOSUID"] = "nosuid";
    TmpfsMountOption["DEV"] = "dev";
    TmpfsMountOption["NODEV"] = "nodev";
    TmpfsMountOption["EXEC"] = "exec";
    TmpfsMountOption["NOEXEC"] = "noexec";
    TmpfsMountOption["SYNC"] = "sync";
    TmpfsMountOption["ASYNC"] = "async";
    TmpfsMountOption["DIRSYNC"] = "dirsync";
    TmpfsMountOption["REMOUNT"] = "remount";
    TmpfsMountOption["MAND"] = "mand";
    TmpfsMountOption["NOMAND"] = "nomand";
    TmpfsMountOption["ATIME"] = "atime";
    TmpfsMountOption["NOATIME"] = "noatime";
    TmpfsMountOption["DIRATIME"] = "diratime";
    TmpfsMountOption["NODIRATIME"] = "nodiratime";
    TmpfsMountOption["BIND"] = "bind";
    TmpfsMountOption["RBIND"] = "rbind";
    TmpfsMountOption["UNBINDABLE"] = "unbindable";
    TmpfsMountOption["RUNBINDABLE"] = "runbindable";
    TmpfsMountOption["PRIVATE"] = "private";
    TmpfsMountOption["RPRIVATE"] = "rprivate";
    TmpfsMountOption["SHARED"] = "shared";
    TmpfsMountOption["RSHARED"] = "rshared";
    TmpfsMountOption["SLAVE"] = "slave";
    TmpfsMountOption["RSLAVE"] = "rslave";
    TmpfsMountOption["RELATIME"] = "relatime";
    TmpfsMountOption["NORELATIME"] = "norelatime";
    TmpfsMountOption["STRICTATIME"] = "strictatime";
    TmpfsMountOption["NOSTRICTATIME"] = "nostrictatime";
    TmpfsMountOption["MODE"] = "mode";
    TmpfsMountOption["UID"] = "uid";
    TmpfsMountOption["GID"] = "gid";
    TmpfsMountOption["NR_INODES"] = "nr_inodes";
    TmpfsMountOption["NR_BLOCKS"] = "nr_blocks";
    TmpfsMountOption["MPOL"] = "mpol";
})(TmpfsMountOption = exports.TmpfsMountOption || (exports.TmpfsMountOption = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGludXgtcGFyYW1ldGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxpbnV4LXBhcmFtZXRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxrQ0FBa0MsQ0FBQyxnREFBZ0Q7QUFHbkYsaUdBQWlHO0FBQ2pHLDhEQUE4RDtBQUM5RCxxQ0FBd0QsQ0FBQyxnREFBZ0Q7Ozs7OztBQXFCekcsTUFBYSxlQUFnQixTQUFRLGdCQUFhOzs7Ozs7SUE0QjlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBOEIsRUFBRTtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBcEJyQjs7V0FFRztRQUNjLFdBQU0sR0FBRyxJQUFJLEtBQUssRUFBYyxDQUFDO1FBQ2xEOztXQUVHO1FBQ2MsWUFBTyxHQUFHLElBQUksS0FBSyxFQUFjLENBQUM7UUFDbkQ7O1dBRUc7UUFDYyxZQUFPLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUMvQzs7V0FFRztRQUNjLFVBQUssR0FBRyxJQUFJLEtBQUssRUFBUyxDQUFDO1FBTXhDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztJQUN2RCxDQUFDOzs7Ozs7OztJQU1NLGVBQWUsQ0FBQyxHQUFHLEdBQWlCO1FBQ3ZDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUM7SUFDN0IsQ0FBQzs7Ozs7Ozs7SUFNTSxnQkFBZ0IsQ0FBQyxHQUFHLEdBQWlCO1FBQ3hDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUM7SUFDOUIsQ0FBQzs7Ozs7O0lBSU0sVUFBVSxDQUFDLEdBQUcsTUFBZ0I7UUFDakMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQztJQUNqQyxDQUFDOzs7Ozs7OztJQU1NLFFBQVEsQ0FBQyxHQUFHLEtBQWM7UUFDN0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7SUFJTSxxQkFBcUI7UUFDeEIsT0FBTztZQUNILGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxZQUFZLEVBQUU7Z0JBQ1YsR0FBRyxFQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQztnQkFDdkUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQzthQUM1RTtZQUNELE9BQU8sRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsRUFBRSxFQUFFLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxDQUFDO1lBQ2xHLEtBQUssRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsRUFBRSxFQUFFLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxDQUFDO1NBQ2hHLENBQUM7SUFDTixDQUFDOztBQTdFTCwwQ0E4RUM7OztBQXVCRCxTQUFTLFlBQVksQ0FBQyxNQUFjO0lBQ2hDLE9BQU87UUFDSCxhQUFhLEVBQUUsTUFBTSxDQUFDLGFBQWE7UUFDbkMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1FBQ3pCLFdBQVcsRUFBRSxNQUFNLENBQUMsV0FBVztLQUNsQyxDQUFDO0FBQ04sQ0FBQztBQW1CRCxTQUFTLFdBQVcsQ0FBQyxLQUFZO0lBQzdCLE9BQU87UUFDSCxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7UUFDbEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1FBQ2hCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtLQUNuQyxDQUFDO0FBQ04sQ0FBQzs7Ozs7O0FBSUQsSUFBWSxVQXVDWDtBQXZDRCxXQUFZLFVBQVU7SUFDbEIseUJBQVcsQ0FBQTtJQUNYLDZDQUErQixDQUFBO0lBQy9CLHlDQUEyQixDQUFBO0lBQzNCLDZDQUErQixDQUFBO0lBQy9CLDZCQUFlLENBQUE7SUFDZiwyQ0FBNkIsQ0FBQTtJQUM3QixpREFBbUMsQ0FBQTtJQUNuQywrQkFBaUIsQ0FBQTtJQUNqQiwrQkFBaUIsQ0FBQTtJQUNqQixtQ0FBcUIsQ0FBQTtJQUNyQixxQ0FBdUIsQ0FBQTtJQUN2QiwyQkFBYSxDQUFBO0lBQ2IsNkJBQWUsQ0FBQTtJQUNmLGlEQUFtQyxDQUFBO0lBQ25DLHFDQUF1QixDQUFBO0lBQ3ZCLDJDQUE2QixDQUFBO0lBQzdCLDZCQUFlLENBQUE7SUFDZixxQ0FBdUIsQ0FBQTtJQUN2QixtREFBcUMsQ0FBQTtJQUNyQyw2Q0FBK0IsQ0FBQTtJQUMvQixpQ0FBbUIsQ0FBQTtJQUNuQixpQ0FBbUIsQ0FBQTtJQUNuQiwrQkFBaUIsQ0FBQTtJQUNqQixpQ0FBbUIsQ0FBQTtJQUNuQiwrQkFBaUIsQ0FBQTtJQUNqQixxQ0FBdUIsQ0FBQTtJQUN2QixtQ0FBcUIsQ0FBQTtJQUNyQix1Q0FBeUIsQ0FBQTtJQUN6Qix1Q0FBeUIsQ0FBQTtJQUN6QixtQ0FBcUIsQ0FBQTtJQUNyQixxQ0FBdUIsQ0FBQTtJQUN2Qix1Q0FBeUIsQ0FBQTtJQUN6QixxQ0FBdUIsQ0FBQTtJQUN2QiwyQ0FBNkIsQ0FBQTtJQUM3QixtQ0FBcUIsQ0FBQTtJQUNyQiwrQ0FBaUMsQ0FBQTtJQUNqQywrQkFBaUIsQ0FBQTtJQUNqQix1Q0FBeUIsQ0FBQTtBQUM3QixDQUFDLEVBdkNXLFVBQVUsR0FBVixrQkFBVSxLQUFWLGtCQUFVLFFBdUNyQjs7Ozs7O0FBSUQsSUFBWSxnQkFhWDtBQWJELFdBQVksZ0JBQWdCO0lBSXhCLGlDQUFhLENBQUE7SUFJYixtQ0FBZSxDQUFBO0lBSWYsbUNBQWUsQ0FBQTtBQUNuQixDQUFDLEVBYlcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUFhM0I7Ozs7OztBQUlELElBQVksZ0JBd0NYO0FBeENELFdBQVksZ0JBQWdCO0lBQ3hCLHlDQUFxQixDQUFBO0lBQ3JCLDZCQUFTLENBQUE7SUFDVCw2QkFBUyxDQUFBO0lBQ1QsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLCtCQUFXLENBQUE7SUFDWCxtQ0FBZSxDQUFBO0lBQ2YsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLGlDQUFhLENBQUE7SUFDYixtQ0FBZSxDQUFBO0lBQ2YsdUNBQW1CLENBQUE7SUFDbkIsdUNBQW1CLENBQUE7SUFDbkIsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLG1DQUFlLENBQUE7SUFDZix1Q0FBbUIsQ0FBQTtJQUNuQix5Q0FBcUIsQ0FBQTtJQUNyQiw2Q0FBeUIsQ0FBQTtJQUN6QixpQ0FBYSxDQUFBO0lBQ2IsbUNBQWUsQ0FBQTtJQUNmLDZDQUF5QixDQUFBO0lBQ3pCLCtDQUEyQixDQUFBO0lBQzNCLHVDQUFtQixDQUFBO0lBQ25CLHlDQUFxQixDQUFBO0lBQ3JCLHFDQUFpQixDQUFBO0lBQ2pCLHVDQUFtQixDQUFBO0lBQ25CLG1DQUFlLENBQUE7SUFDZixxQ0FBaUIsQ0FBQTtJQUNqQix5Q0FBcUIsQ0FBQTtJQUNyQiw2Q0FBeUIsQ0FBQTtJQUN6QiwrQ0FBMkIsQ0FBQTtJQUMzQixtREFBK0IsQ0FBQTtJQUMvQixpQ0FBYSxDQUFBO0lBQ2IsK0JBQVcsQ0FBQTtJQUNYLCtCQUFXLENBQUE7SUFDWCwyQ0FBdUIsQ0FBQTtJQUN2QiwyQ0FBdUIsQ0FBQTtJQUN2QixpQ0FBYSxDQUFBO0FBQ2pCLENBQUMsRUF4Q1csZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUF3QzNCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5UYXNrRGVmaW5pdGlvbiB9IGZyb20gJy4vZWNzLmdlbmVyYXRlZCc7XG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMaW51eFBhcmFtZXRlcnNQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBpbml0UHJvY2Vzc0VuYWJsZWQ/OiBib29sZWFuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBzaGFyZWRNZW1vcnlTaXplPzogbnVtYmVyO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBMaW51eFBhcmFtZXRlcnMgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IHtcbiAgICAvKipcbiAgICAgKiBXaGV0aGVyIHRoZSBpbml0IHByb2Nlc3MgaXMgZW5hYmxlZFxuICAgICAqL1xuICAgIHByaXZhdGUgcmVhZG9ubHkgaW5pdFByb2Nlc3NFbmFibGVkPzogYm9vbGVhbjtcbiAgICAvKipcbiAgICAgKiBUaGUgc2hhcmVkIG1lbW9yeSBzaXplLiBOb3QgdmFsaWQgZm9yIEZhcmdhdGUgbGF1bmNoIHR5cGVcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IHNoYXJlZE1lbW9yeVNpemU/OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogQ2FwYWJpbGl0aWVzIHRvIGJlIGFkZGVkXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBjYXBBZGQgPSBuZXcgQXJyYXk8Q2FwYWJpbGl0eT4oKTtcbiAgICAvKipcbiAgICAgKiBDYXBhYmlsaXRpZXMgdG8gYmUgZHJvcHBlZFxuICAgICAqL1xuICAgIHByaXZhdGUgcmVhZG9ubHkgY2FwRHJvcCA9IG5ldyBBcnJheTxDYXBhYmlsaXR5PigpO1xuICAgIC8qKlxuICAgICAqIERldmljZSBtb3VudHNcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IGRldmljZXMgPSBuZXcgQXJyYXk8RGV2aWNlPigpO1xuICAgIC8qKlxuICAgICAqIFRtcEZzIG1vdW50c1xuICAgICAqL1xuICAgIHByaXZhdGUgcmVhZG9ubHkgdG1wZnMgPSBuZXcgQXJyYXk8VG1wZnM+KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTGludXhQYXJhbWV0ZXJzUHJvcHMgPSB7fSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICB0aGlzLnNoYXJlZE1lbW9yeVNpemUgPSBwcm9wcy5zaGFyZWRNZW1vcnlTaXplO1xuICAgICAgICB0aGlzLmluaXRQcm9jZXNzRW5hYmxlZCA9IHByb3BzLmluaXRQcm9jZXNzRW5hYmxlZDtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBhZGRDYXBhYmlsaXRpZXMoLi4uY2FwOiBDYXBhYmlsaXR5W10pIHtcbiAgICAgICAgdGhpcy5jYXBBZGQucHVzaCguLi5jYXApO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIGRyb3BDYXBhYmlsaXRpZXMoLi4uY2FwOiBDYXBhYmlsaXR5W10pIHtcbiAgICAgICAgdGhpcy5jYXBEcm9wLnB1c2goLi4uY2FwKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBhZGREZXZpY2VzKC4uLmRldmljZTogRGV2aWNlW10pIHtcbiAgICAgICAgdGhpcy5kZXZpY2VzLnB1c2goLi4uZGV2aWNlKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgYWRkVG1wZnMoLi4udG1wZnM6IFRtcGZzW10pIHtcbiAgICAgICAgdGhpcy50bXBmcy5wdXNoKC4uLnRtcGZzKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlbmRlckxpbnV4UGFyYW1ldGVycygpOiBDZm5UYXNrRGVmaW5pdGlvbi5MaW51eFBhcmFtZXRlcnNQcm9wZXJ0eSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBpbml0UHJvY2Vzc0VuYWJsZWQ6IHRoaXMuaW5pdFByb2Nlc3NFbmFibGVkLFxuICAgICAgICAgICAgc2hhcmVkTWVtb3J5U2l6ZTogdGhpcy5zaGFyZWRNZW1vcnlTaXplLFxuICAgICAgICAgICAgY2FwYWJpbGl0aWVzOiB7XG4gICAgICAgICAgICAgICAgYWRkOiBjZGsuTGF6eS5saXN0KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5jYXBBZGQgfSwgeyBvbWl0RW1wdHk6IHRydWUgfSksXG4gICAgICAgICAgICAgICAgZHJvcDogY2RrLkxhenkubGlzdCh7IHByb2R1Y2U6ICgpID0+IHRoaXMuY2FwRHJvcCB9LCB7IG9taXRFbXB0eTogdHJ1ZSB9KSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBkZXZpY2VzOiBjZGsuTGF6eS5hbnkoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLmRldmljZXMubWFwKHJlbmRlckRldmljZSkgfSwgeyBvbWl0RW1wdHlBcnJheTogdHJ1ZSB9KSxcbiAgICAgICAgICAgIHRtcGZzOiBjZGsuTGF6eS5hbnkoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLnRtcGZzLm1hcChyZW5kZXJUbXBmcykgfSwgeyBvbWl0RW1wdHlBcnJheTogdHJ1ZSB9KSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBEZXZpY2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGNvbnRhaW5lclBhdGg/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBob3N0UGF0aDogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBwZXJtaXNzaW9ucz86IERldmljZVBlcm1pc3Npb25bXTtcbn1cbmZ1bmN0aW9uIHJlbmRlckRldmljZShkZXZpY2U6IERldmljZSk6IENmblRhc2tEZWZpbml0aW9uLkRldmljZVByb3BlcnR5IHtcbiAgICByZXR1cm4ge1xuICAgICAgICBjb250YWluZXJQYXRoOiBkZXZpY2UuY29udGFpbmVyUGF0aCxcbiAgICAgICAgaG9zdFBhdGg6IGRldmljZS5ob3N0UGF0aCxcbiAgICAgICAgcGVybWlzc2lvbnM6IGRldmljZS5wZXJtaXNzaW9ucyxcbiAgICB9O1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVG1wZnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBjb250YWluZXJQYXRoOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgc2l6ZTogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG1vdW50T3B0aW9ucz86IFRtcGZzTW91bnRPcHRpb25bXTtcbn1cbmZ1bmN0aW9uIHJlbmRlclRtcGZzKHRtcGZzOiBUbXBmcyk6IENmblRhc2tEZWZpbml0aW9uLlRtcGZzUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICAgIGNvbnRhaW5lclBhdGg6IHRtcGZzLmNvbnRhaW5lclBhdGgsXG4gICAgICAgIHNpemU6IHRtcGZzLnNpemUsXG4gICAgICAgIG1vdW50T3B0aW9uczogdG1wZnMubW91bnRPcHRpb25zLFxuICAgIH07XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gQ2FwYWJpbGl0eSB7XG4gICAgQUxMID0gJ0FMTCcsXG4gICAgQVVESVRfQ09OVFJPTCA9ICdBVURJVF9DT05UUk9MJyxcbiAgICBBVURJVF9XUklURSA9ICdBVURJVF9XUklURScsXG4gICAgQkxPQ0tfU1VTUEVORCA9ICdCTE9DS19TVVNQRU5EJyxcbiAgICBDSE9XTiA9ICdDSE9XTicsXG4gICAgREFDX09WRVJSSURFID0gJ0RBQ19PVkVSUklERScsXG4gICAgREFDX1JFQURfU0VBUkNIID0gJ0RBQ19SRUFEX1NFQVJDSCcsXG4gICAgRk9XTkVSID0gJ0ZPV05FUicsXG4gICAgRlNFVElEID0gJ0ZTRVRJRCcsXG4gICAgSVBDX0xPQ0sgPSAnSVBDX0xPQ0snLFxuICAgIElQQ19PV05FUiA9ICdJUENfT1dORVInLFxuICAgIEtJTEwgPSAnS0lMTCcsXG4gICAgTEVBU0UgPSAnTEVBU0UnLFxuICAgIExJTlVYX0lNTVVUQUJMRSA9ICdMSU5VWF9JTU1VVEFCTEUnLFxuICAgIE1BQ19BRE1JTiA9ICdNQUNfQURNSU4nLFxuICAgIE1BQ19PVkVSUklERSA9ICdNQUNfT1ZFUlJJREUnLFxuICAgIE1LTk9EID0gJ01LTk9EJyxcbiAgICBORVRfQURNSU4gPSAnTkVUX0FETUlOJyxcbiAgICBORVRfQklORF9TRVJWSUNFID0gJ05FVF9CSU5EX1NFUlZJQ0UnLFxuICAgIE5FVF9CUk9BRENBU1QgPSAnTkVUX0JST0FEQ0FTVCcsXG4gICAgTkVUX1JBVyA9ICdORVRfUkFXJyxcbiAgICBTRVRGQ0FQID0gJ1NFVEZDQVAnLFxuICAgIFNFVEdJRCA9ICdTRVRHSUQnLFxuICAgIFNFVFBDQVAgPSAnU0VUUENBUCcsXG4gICAgU0VUVUlEID0gJ1NFVFVJRCcsXG4gICAgU1lTX0FETUlOID0gJ1NZU19BRE1JTicsXG4gICAgU1lTX0JPT1QgPSAnU1lTX0JPT1QnLFxuICAgIFNZU19DSFJPT1QgPSAnU1lTX0NIUk9PVCcsXG4gICAgU1lTX01PRFVMRSA9ICdTWVNfTU9EVUxFJyxcbiAgICBTWVNfTklDRSA9ICdTWVNfTklDRScsXG4gICAgU1lTX1BBQ0NUID0gJ1NZU19QQUNDVCcsXG4gICAgU1lTX1BUUkFDRSA9ICdTWVNfUFRSQUNFJyxcbiAgICBTWVNfUkFXSU8gPSAnU1lTX1JBV0lPJyxcbiAgICBTWVNfUkVTT1VSQ0UgPSAnU1lTX1JFU09VUkNFJyxcbiAgICBTWVNfVElNRSA9ICdTWVNfVElNRScsXG4gICAgU1lTX1RUWV9DT05GSUcgPSAnU1lTX1RUWV9DT05GSUcnLFxuICAgIFNZU0xPRyA9ICdTWVNMT0cnLFxuICAgIFdBS0VfQUxBUk0gPSAnV0FLRV9BTEFSTSdcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIERldmljZVBlcm1pc3Npb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUkVBRCA9ICdyZWFkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBXUklURSA9ICd3cml0ZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUtOT0QgPSAnbWtub2QnXG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBUbXBmc01vdW50T3B0aW9uIHtcbiAgICBERUZBVUxUUyA9ICdkZWZhdWx0cycsXG4gICAgUk8gPSAncm8nLFxuICAgIFJXID0gJ3J3JyxcbiAgICBTVUlEID0gJ3N1aWQnLFxuICAgIE5PU1VJRCA9ICdub3N1aWQnLFxuICAgIERFViA9ICdkZXYnLFxuICAgIE5PREVWID0gJ25vZGV2JyxcbiAgICBFWEVDID0gJ2V4ZWMnLFxuICAgIE5PRVhFQyA9ICdub2V4ZWMnLFxuICAgIFNZTkMgPSAnc3luYycsXG4gICAgQVNZTkMgPSAnYXN5bmMnLFxuICAgIERJUlNZTkMgPSAnZGlyc3luYycsXG4gICAgUkVNT1VOVCA9ICdyZW1vdW50JyxcbiAgICBNQU5EID0gJ21hbmQnLFxuICAgIE5PTUFORCA9ICdub21hbmQnLFxuICAgIEFUSU1FID0gJ2F0aW1lJyxcbiAgICBOT0FUSU1FID0gJ25vYXRpbWUnLFxuICAgIERJUkFUSU1FID0gJ2RpcmF0aW1lJyxcbiAgICBOT0RJUkFUSU1FID0gJ25vZGlyYXRpbWUnLFxuICAgIEJJTkQgPSAnYmluZCcsXG4gICAgUkJJTkQgPSAncmJpbmQnLFxuICAgIFVOQklOREFCTEUgPSAndW5iaW5kYWJsZScsXG4gICAgUlVOQklOREFCTEUgPSAncnVuYmluZGFibGUnLFxuICAgIFBSSVZBVEUgPSAncHJpdmF0ZScsXG4gICAgUlBSSVZBVEUgPSAncnByaXZhdGUnLFxuICAgIFNIQVJFRCA9ICdzaGFyZWQnLFxuICAgIFJTSEFSRUQgPSAncnNoYXJlZCcsXG4gICAgU0xBVkUgPSAnc2xhdmUnLFxuICAgIFJTTEFWRSA9ICdyc2xhdmUnLFxuICAgIFJFTEFUSU1FID0gJ3JlbGF0aW1lJyxcbiAgICBOT1JFTEFUSU1FID0gJ25vcmVsYXRpbWUnLFxuICAgIFNUUklDVEFUSU1FID0gJ3N0cmljdGF0aW1lJyxcbiAgICBOT1NUUklDVEFUSU1FID0gJ25vc3RyaWN0YXRpbWUnLFxuICAgIE1PREUgPSAnbW9kZScsXG4gICAgVUlEID0gJ3VpZCcsXG4gICAgR0lEID0gJ2dpZCcsXG4gICAgTlJfSU5PREVTID0gJ25yX2lub2RlcycsXG4gICAgTlJfQkxPQ0tTID0gJ25yX2Jsb2NrcycsXG4gICAgTVBPTCA9ICdtcG9sJ1xufVxuIl19