import { Construct } from 'constructs';
import { CfnTaskDefinition } from './ecs.generated';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The properties for defining Linux-specific options that are applied to the container.
 *
 * @experimental
 */
export interface LinuxParametersProps {
    /**
     * (experimental) Specifies whether to run an init process inside the container that forwards signals and reaps processes.
     *
     * @default false
     * @experimental
     */
    readonly initProcessEnabled?: boolean;
    /**
     * (experimental) The value for the size (in MiB) of the /dev/shm volume.
     *
     * @default No shared memory.
     * @experimental
     */
    readonly sharedMemorySize?: number;
}
/**
 * (experimental) Linux-specific options that are applied to the container.
 *
 * @experimental
 */
export declare class LinuxParameters extends CoreConstruct {
    /**
     * Whether the init process is enabled
     */
    private readonly initProcessEnabled?;
    /**
     * The shared memory size. Not valid for Fargate launch type
     */
    private readonly sharedMemorySize?;
    /**
     * Capabilities to be added
     */
    private readonly capAdd;
    /**
     * Capabilities to be dropped
     */
    private readonly capDrop;
    /**
     * Device mounts
     */
    private readonly devices;
    /**
     * TmpFs mounts
     */
    private readonly tmpfs;
    /**
     * (experimental) Constructs a new instance of the LinuxParameters class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: LinuxParametersProps);
    /**
     * (experimental) Adds one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addCapabilities(...cap: Capability[]): void;
    /**
     * (experimental) Removes one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    dropCapabilities(...cap: Capability[]): void;
    /**
     * (experimental) Adds one or more host devices to a container.
     *
     * @experimental
     */
    addDevices(...device: Device[]): void;
    /**
     * (experimental) Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addTmpfs(...tmpfs: Tmpfs[]): void;
    /**
     * (experimental) Renders the Linux parameters to a CloudFormation object.
     *
     * @experimental
     */
    renderLinuxParameters(): CfnTaskDefinition.LinuxParametersProperty;
}
/**
 * (experimental) A container instance host device.
 *
 * @experimental
 */
export interface Device {
    /**
     * (experimental) The path inside the container at which to expose the host device.
     *
     * @default Same path as the host
     * @experimental
     */
    readonly containerPath?: string;
    /**
     * (experimental) The path for the device on the host container instance.
     *
     * @experimental
     */
    readonly hostPath: string;
    /**
     * (experimental) The explicit permissions to provide to the container for the device.
     *
     * By default, the container has permissions for read, write, and mknod for the device.
     *
     * @default Readonly
     * @experimental
     */
    readonly permissions?: DevicePermission[];
}
/**
 * (experimental) The details of a tmpfs mount for a container.
 *
 * @experimental
 */
export interface Tmpfs {
    /**
     * (experimental) The absolute file path where the tmpfs volume is to be mounted.
     *
     * @experimental
     */
    readonly containerPath: string;
    /**
     * (experimental) The size (in MiB) of the tmpfs volume.
     *
     * @experimental
     */
    readonly size: number;
    /**
     * (experimental) The list of tmpfs volume mount options.
     *
     * For more information, see
     * [TmpfsMountOptions](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Tmpfs.html).
     *
     * @experimental
     */
    readonly mountOptions?: TmpfsMountOption[];
}
/**
 * (experimental) A Linux capability.
 *
 * @experimental
 */
export declare enum Capability {
    /**
     * @experimental
     */
    ALL = "ALL",
    /**
     * @experimental
     */
    AUDIT_CONTROL = "AUDIT_CONTROL",
    /**
     * @experimental
     */
    AUDIT_WRITE = "AUDIT_WRITE",
    /**
     * @experimental
     */
    BLOCK_SUSPEND = "BLOCK_SUSPEND",
    /**
     * @experimental
     */
    CHOWN = "CHOWN",
    /**
     * @experimental
     */
    DAC_OVERRIDE = "DAC_OVERRIDE",
    /**
     * @experimental
     */
    DAC_READ_SEARCH = "DAC_READ_SEARCH",
    /**
     * @experimental
     */
    FOWNER = "FOWNER",
    /**
     * @experimental
     */
    FSETID = "FSETID",
    /**
     * @experimental
     */
    IPC_LOCK = "IPC_LOCK",
    /**
     * @experimental
     */
    IPC_OWNER = "IPC_OWNER",
    /**
     * @experimental
     */
    KILL = "KILL",
    /**
     * @experimental
     */
    LEASE = "LEASE",
    /**
     * @experimental
     */
    LINUX_IMMUTABLE = "LINUX_IMMUTABLE",
    /**
     * @experimental
     */
    MAC_ADMIN = "MAC_ADMIN",
    /**
     * @experimental
     */
    MAC_OVERRIDE = "MAC_OVERRIDE",
    /**
     * @experimental
     */
    MKNOD = "MKNOD",
    /**
     * @experimental
     */
    NET_ADMIN = "NET_ADMIN",
    /**
     * @experimental
     */
    NET_BIND_SERVICE = "NET_BIND_SERVICE",
    /**
     * @experimental
     */
    NET_BROADCAST = "NET_BROADCAST",
    /**
     * @experimental
     */
    NET_RAW = "NET_RAW",
    /**
     * @experimental
     */
    SETFCAP = "SETFCAP",
    /**
     * @experimental
     */
    SETGID = "SETGID",
    /**
     * @experimental
     */
    SETPCAP = "SETPCAP",
    /**
     * @experimental
     */
    SETUID = "SETUID",
    /**
     * @experimental
     */
    SYS_ADMIN = "SYS_ADMIN",
    /**
     * @experimental
     */
    SYS_BOOT = "SYS_BOOT",
    /**
     * @experimental
     */
    SYS_CHROOT = "SYS_CHROOT",
    /**
     * @experimental
     */
    SYS_MODULE = "SYS_MODULE",
    /**
     * @experimental
     */
    SYS_NICE = "SYS_NICE",
    /**
     * @experimental
     */
    SYS_PACCT = "SYS_PACCT",
    /**
     * @experimental
     */
    SYS_PTRACE = "SYS_PTRACE",
    /**
     * @experimental
     */
    SYS_RAWIO = "SYS_RAWIO",
    /**
     * @experimental
     */
    SYS_RESOURCE = "SYS_RESOURCE",
    /**
     * @experimental
     */
    SYS_TIME = "SYS_TIME",
    /**
     * @experimental
     */
    SYS_TTY_CONFIG = "SYS_TTY_CONFIG",
    /**
     * @experimental
     */
    SYSLOG = "SYSLOG",
    /**
     * @experimental
     */
    WAKE_ALARM = "WAKE_ALARM"
}
/**
 * (experimental) Permissions for device access.
 *
 * @experimental
 */
export declare enum DevicePermission {
    /**
     * (experimental) Read.
     *
     * @experimental
     */
    READ = "read",
    /**
     * (experimental) Write.
     *
     * @experimental
     */
    WRITE = "write",
    /**
     * (experimental) Make a node.
     *
     * @experimental
     */
    MKNOD = "mknod"
}
/**
 * (experimental) The supported options for a tmpfs mount for a container.
 *
 * @experimental
 */
export declare enum TmpfsMountOption {
    /**
     * @experimental
     */
    DEFAULTS = "defaults",
    /**
     * @experimental
     */
    RO = "ro",
    /**
     * @experimental
     */
    RW = "rw",
    /**
     * @experimental
     */
    SUID = "suid",
    /**
     * @experimental
     */
    NOSUID = "nosuid",
    /**
     * @experimental
     */
    DEV = "dev",
    /**
     * @experimental
     */
    NODEV = "nodev",
    /**
     * @experimental
     */
    EXEC = "exec",
    /**
     * @experimental
     */
    NOEXEC = "noexec",
    /**
     * @experimental
     */
    SYNC = "sync",
    /**
     * @experimental
     */
    ASYNC = "async",
    /**
     * @experimental
     */
    DIRSYNC = "dirsync",
    /**
     * @experimental
     */
    REMOUNT = "remount",
    /**
     * @experimental
     */
    MAND = "mand",
    /**
     * @experimental
     */
    NOMAND = "nomand",
    /**
     * @experimental
     */
    ATIME = "atime",
    /**
     * @experimental
     */
    NOATIME = "noatime",
    /**
     * @experimental
     */
    DIRATIME = "diratime",
    /**
     * @experimental
     */
    NODIRATIME = "nodiratime",
    /**
     * @experimental
     */
    BIND = "bind",
    /**
     * @experimental
     */
    RBIND = "rbind",
    /**
     * @experimental
     */
    UNBINDABLE = "unbindable",
    /**
     * @experimental
     */
    RUNBINDABLE = "runbindable",
    /**
     * @experimental
     */
    PRIVATE = "private",
    /**
     * @experimental
     */
    RPRIVATE = "rprivate",
    /**
     * @experimental
     */
    SHARED = "shared",
    /**
     * @experimental
     */
    RSHARED = "rshared",
    /**
     * @experimental
     */
    SLAVE = "slave",
    /**
     * @experimental
     */
    RSLAVE = "rslave",
    /**
     * @experimental
     */
    RELATIME = "relatime",
    /**
     * @experimental
     */
    NORELATIME = "norelatime",
    /**
     * @experimental
     */
    STRICTATIME = "strictatime",
    /**
     * @experimental
     */
    NOSTRICTATIME = "nostrictatime",
    /**
     * @experimental
     */
    MODE = "mode",
    /**
     * @experimental
     */
    UID = "uid",
    /**
     * @experimental
     */
    GID = "gid",
    /**
     * @experimental
     */
    NR_INODES = "nr_inodes",
    /**
     * @experimental
     */
    NR_BLOCKS = "nr_blocks",
    /**
     * @experimental
     */
    MPOL = "mpol"
}
