"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagParameterContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const container_image_1 = require("../container-image");
/**
 * (experimental) A special type of {@link ContainerImage} that uses an ECR repository for the image, but a CloudFormation Parameter for the tag of the image in that repository.
 *
 * This allows providing this tag through the Parameter at deploy time,
 * for example in a CodePipeline that pushes a new tag of the image to the repository during a build step,
 * and then provides that new tag through the CloudFormation Parameter in the deploy step.
 *
 * @see #tagParameterName
 * @experimental
 */
class TagParameterContainerImage extends container_image_1.ContainerImage {
    /**
     * @experimental
     */
    constructor(repository) {
        super();
        this.repository = repository;
    }
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(scope, containerDefinition) {
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        const imageTagParameter = new cdk.CfnParameter(scope, 'ImageTagParam');
        this.imageTagParameter = imageTagParameter;
        return {
            imageName: this.repository.repositoryUriForTag(imageTagParameter.valueAsString),
        };
    }
    /**
     * (experimental) Returns the name of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @experimental
     */
    get tagParameterName() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.logicalId;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterName');
                }
            },
        });
    }
    /**
     * (experimental) Returns the value of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @experimental
     */
    get tagParameterValue() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.valueAsString;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterValue');
                }
            },
        });
    }
}
exports.TagParameterContainerImage = TagParameterContainerImage;
_a = JSII_RTTI_SYMBOL_1;
TagParameterContainerImage[_a] = { fqn: "monocdk.aws_ecs.TagParameterContainerImage", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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