import * as ecr from "../../../aws-ecr";
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct } from "../../../core";
/**
 * (experimental) A special type of {@link ContainerImage} that uses an ECR repository for the image, but a CloudFormation Parameter for the tag of the image in that repository.
 *
 * This allows providing this tag through the Parameter at deploy time,
 * for example in a CodePipeline that pushes a new tag of the image to the repository during a build step,
 * and then provides that new tag through the CloudFormation Parameter in the deploy step.
 *
 * @see #tagParameterName
 * @experimental
 */
export declare class TagParameterContainerImage extends ContainerImage {
    private readonly repository;
    private imageTagParameter?;
    /**
     * @experimental
     */
    constructor(repository: ecr.IRepository);
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(scope: Construct, containerDefinition: ContainerDefinition): ContainerImageConfig;
    /**
     * (experimental) Returns the name of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @experimental
     */
    get tagParameterName(): string;
    /**
     * (experimental) Returns the value of the CloudFormation Parameter that represents the tag of the image in the ECR repository.
     *
     * @experimental
     */
    get tagParameterValue(): string;
}
