"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const container_image_1 = require("../container-image");
/**
 * (experimental) An image from an Amazon ECR repository.
 *
 * @experimental
 */
class EcrImage extends container_image_1.ContainerImage {
    /**
     * (experimental) Constructs a new instance of the EcrImage class.
     *
     * @experimental
     */
    constructor(repository, tagOrDigest) {
        super();
        this.repository = repository;
        this.tagOrDigest = tagOrDigest;
        if (tagOrDigest === null || tagOrDigest === void 0 ? void 0 : tagOrDigest.startsWith('sha256:')) {
            this.imageName = this.repository.repositoryUriForDigest(this.tagOrDigest);
        }
        else {
            this.imageName = this.repository.repositoryUriForTag(this.tagOrDigest);
        }
    }
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(_scope, containerDefinition) {
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: this.imageName,
        };
    }
}
exports.EcrImage = EcrImage;
_a = JSII_RTTI_SYMBOL_1;
EcrImage[_a] = { fqn: "monocdk.aws_ecs.EcrImage", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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