"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateTaskDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * (experimental) The details of a task definition run on a Fargate cluster.
 *
 * @experimental
 * @resource AWS::ECS::TaskDefinition
 */
class FargateTaskDefinition extends task_definition_1.TaskDefinition {
    // NOTE: Until the fix to https://github.com/Microsoft/TypeScript/issues/26969 gets released,
    // we need to explicitly write the type here, as type deduction for enums won't lead to
    // the import being generated in the .d.ts file.
    /**
     * (experimental) Constructs a new instance of the FargateTaskDefinition class.
     *
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            cpu: props.cpu !== undefined ? core_1.Tokenization.stringifyNumber(props.cpu) : '256',
            memoryMiB: props.memoryLimitMiB !== undefined ? core_1.Tokenization.stringifyNumber(props.memoryLimitMiB) : '512',
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: task_definition_1.NetworkMode.AWS_VPC,
        });
        /**
         * (experimental) The Docker networking mode to use for the containers in the task.
         *
         * Fargate tasks require the awsvpc network mode.
         *
         * @experimental
         */
        this.networkMode = task_definition_1.NetworkMode.AWS_VPC;
    }
    /**
     * (experimental) Imports a task definition from the specified task definition ARN.
     *
     * @experimental
     */
    static fromFargateTaskDefinitionArn(scope, id, fargateTaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, { taskDefinitionArn: fargateTaskDefinitionArn });
    }
    /**
     * (experimental) Import an existing Fargate task definition from its attributes.
     *
     * @experimental
     */
    static fromFargateTaskDefinitionAttributes(scope, id, attrs) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
}
exports.FargateTaskDefinition = FargateTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
FargateTaskDefinition[_a] = { fqn: "monocdk.aws_ecs.FargateTaskDefinition", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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