import * as ec2 from "../../../aws-ec2";
import { Construct } from 'constructs';
import { BaseService, BaseServiceOptions, IBaseService, IService, PropagatedTagSource } from '../base/base-service';
import { TaskDefinition } from '../base/task-definition';
import { ICluster } from '../cluster';
/**
 * (experimental) The properties for defining a service using the Fargate launch type.
 *
 * @experimental
 */
export interface FargateServiceProps extends BaseServiceOptions {
    /**
     * (experimental) The task definition to use for tasks in the service.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly taskDefinition: TaskDefinition;
    /**
     * (experimental) Specifies whether the task's elastic network interface receives a public IP address.
     *
     * If true, each task will receive a public IP address.
     *
     * @default false
     * @experimental
     */
    readonly assignPublicIp?: boolean;
    /**
     * (experimental) The subnets to associate with the service.
     *
     * @default - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (deprecated) The security groups to associate with the service.
     *
     * If you do not specify a security group, the default security group for the VPC is used.
     *
     * @default - A new security group is created.
     * @deprecated use securityGroups instead.
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The security groups to associate with the service.
     *
     * If you do not specify a security group, the default security group for the VPC is used.
     *
     * @default - A new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The platform version on which to run your service.
     *
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * @default Latest
     * @experimental
     */
    readonly platformVersion?: FargatePlatformVersion;
    /**
     * (deprecated) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     *
     * Tags can only be propagated to the tasks within the service during service creation.
     *
     * @default PropagatedTagSource.NONE
     * @deprecated Use `propagateTags` instead.
     */
    readonly propagateTaskTagsFrom?: PropagatedTagSource;
}
/**
 * (experimental) The interface for a service using the Fargate launch type on an ECS cluster.
 *
 * @experimental
 */
export interface IFargateService extends IService {
}
/**
 * (experimental) The properties to import from the service using the Fargate launch type.
 *
 * @experimental
 */
export interface FargateServiceAttributes {
    /**
     * (experimental) The cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The service ARN.
     *
     * @default - either this, or {@link serviceName}, is required
     * @experimental
     */
    readonly serviceArn?: string;
    /**
     * (experimental) The name of the service.
     *
     * @default - either this, or {@link serviceArn}, is required
     * @experimental
     */
    readonly serviceName?: string;
}
/**
 * (experimental) This creates a service using the Fargate launch type on an ECS cluster.
 *
 * @experimental
 * @resource AWS::ECS::Service
 */
export declare class FargateService extends BaseService implements IFargateService {
    /**
     * (experimental) Imports from the specified service ARN.
     *
     * @experimental
     */
    static fromFargateServiceArn(scope: Construct, id: string, fargateServiceArn: string): IFargateService;
    /**
     * (experimental) Imports from the specified service attrributes.
     *
     * @experimental
     */
    static fromFargateServiceAttributes(scope: Construct, id: string, attrs: FargateServiceAttributes): IBaseService;
    /**
     * (experimental) Constructs a new instance of the FargateService class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FargateServiceProps);
}
/**
 * (experimental) The platform version on which to run your service.
 *
 * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
 * @experimental
 */
export declare enum FargatePlatformVersion {
    /**
     * (experimental) The latest, recommended platform version.
     *
     * @experimental
     */
    LATEST = "LATEST",
    /**
     * (experimental) Version 1.4.0.
     *
     * Supports EFS endpoints, CAP_SYS_PTRACE Linux capability,
     * network performance metrics in CloudWatch Container Insights,
     * consolidated 20 GB ephemeral volume.
     *
     * @experimental
     */
    VERSION1_4 = "1.4.0",
    /**
     * (experimental) Version 1.3.0.
     *
     * Supports secrets, task recycling.
     *
     * @experimental
     */
    VERSION1_3 = "1.3.0",
    /**
     * (experimental) Version 1.2.0.
     *
     * Supports private registries.
     *
     * @experimental
     */
    VERSION1_2 = "1.2.0",
    /**
     * (experimental) Version 1.1.0.
     *
     * Supports task metadata, health checks, service discovery.
     *
     * @experimental
     */
    VERSION1_1 = "1.1.0",
    /**
     * (experimental) Initial release.
     *
     * Based on Amazon Linux 2017.09.
     *
     * @experimental
     */
    VERSION1_0 = "1.0.0"
}
