"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentFileType = exports.S3EnvironmentFile = exports.AssetEnvironmentFile = exports.EnvironmentFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_assets_1 = require("../../aws-s3-assets"); // Automatically re-written from '@aws-cdk/aws-s3-assets'
/**
 * (experimental) Constructs for types of environment files.
 *
 * @experimental
 */
class EnvironmentFile {
    /**
     * (experimental) Loads the environment file from a local disk path.
     *
     * @param path Local disk path.
     * @experimental
     */
    static fromAsset(path, options) {
        return new AssetEnvironmentFile(path, options);
    }
    /**
     * (experimental) Loads the environment file from an S3 bucket.
     *
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @param objectVersion Optional S3 object version.
     * @returns `S3EnvironmentFile` associated with the specified S3 object.
     * @experimental
     */
    static fromBucket(bucket, key, objectVersion) {
        return new S3EnvironmentFile(bucket, key, objectVersion);
    }
}
exports.EnvironmentFile = EnvironmentFile;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentFile[_a] = { fqn: "monocdk.aws_ecs.EnvironmentFile", version: "1.106.1" };
/**
 * (experimental) Environment file from a local directory.
 *
 * @experimental
 */
class AssetEnvironmentFile extends EnvironmentFile {
    /**
     * @param path The path to the asset file or directory.
     * @experimental
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     *
     * @experimental
     */
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new aws_s3_assets_1.Asset(scope, 'EnvironmentFile', {
                path: this.path,
                ...this.options,
            });
        }
        if (!this.asset.isFile) {
            throw new Error(`Asset must be a single file (${this.path})`);
        }
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
}
exports.AssetEnvironmentFile = AssetEnvironmentFile;
_b = JSII_RTTI_SYMBOL_1;
AssetEnvironmentFile[_b] = { fqn: "monocdk.aws_ecs.AssetEnvironmentFile", version: "1.106.1" };
/**
 * (experimental) Environment file from S3.
 *
 * @experimental
 */
class S3EnvironmentFile extends EnvironmentFile {
    /**
     * @experimental
     */
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        if (!bucket.bucketName) {
            throw new Error('bucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     *
     * @experimental
     */
    bind(_scope) {
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
exports.S3EnvironmentFile = S3EnvironmentFile;
_c = JSII_RTTI_SYMBOL_1;
S3EnvironmentFile[_c] = { fqn: "monocdk.aws_ecs.S3EnvironmentFile", version: "1.106.1" };
/**
 * Type of environment file to be included in the container definition
 */
var EnvironmentFileType;
(function (EnvironmentFileType) {
    EnvironmentFileType["S3"] = "s3";
})(EnvironmentFileType = exports.EnvironmentFileType || (exports.EnvironmentFileType = {}));
//# sourceMappingURL=data:application/json;base64,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