import { IBucket, Location } from "../../aws-s3";
import { AssetOptions } from "../../aws-s3-assets";
import { Construct } from "../../core";
/**
 * (experimental) Constructs for types of environment files.
 *
 * @experimental
 */
export declare abstract class EnvironmentFile {
    /**
     * (experimental) Loads the environment file from a local disk path.
     *
     * @param path Local disk path.
     * @experimental
     */
    static fromAsset(path: string, options?: AssetOptions): AssetEnvironmentFile;
    /**
     * (experimental) Loads the environment file from an S3 bucket.
     *
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @param objectVersion Optional S3 object version.
     * @returns `S3EnvironmentFile` associated with the specified S3 object.
     * @experimental
     */
    static fromBucket(bucket: IBucket, key: string, objectVersion?: string): S3EnvironmentFile;
    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     *
     * @param scope The binding scope.
     * @experimental
     */
    abstract bind(scope: Construct): EnvironmentFileConfig;
}
/**
 * (experimental) Environment file from a local directory.
 *
 * @experimental
 */
export declare class AssetEnvironmentFile extends EnvironmentFile {
    readonly path: string;
    private readonly options;
    private asset?;
    /**
     * @param path The path to the asset file or directory.
     * @experimental
     */
    constructor(path: string, options?: AssetOptions);
    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     *
     * @experimental
     */
    bind(scope: Construct): EnvironmentFileConfig;
}
/**
 * (experimental) Environment file from S3.
 *
 * @experimental
 */
export declare class S3EnvironmentFile extends EnvironmentFile {
    private key;
    private objectVersion?;
    private readonly bucketName;
    /**
     * @experimental
     */
    constructor(bucket: IBucket, key: string, objectVersion?: string | undefined);
    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     *
     * @experimental
     */
    bind(_scope: Construct): EnvironmentFileConfig;
}
/**
 * (experimental) Configuration for the environment file.
 *
 * @experimental
 */
export interface EnvironmentFileConfig {
    /**
     * (experimental) The type of environment file.
     *
     * @experimental
     */
    readonly fileType: EnvironmentFileType;
    /**
     * (experimental) The location of the environment file in S3.
     *
     * @experimental
     */
    readonly s3Location: Location;
}
/**
 * Type of environment file to be included in the container definition
 */
export declare enum EnvironmentFileType {
    /**
     * (experimental) Type of environment file to be included in the container definition.
     *
     * @experimental
     */
    S3 = "s3"
}
