"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TaskDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * (experimental) The details of a task definition run on an EC2 cluster.
 *
 * @experimental
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * (experimental) Constructs a new instance of the Ec2TaskDefinition class.
     *
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
            inferenceAccelerators: props.inferenceAccelerators,
        });
    }
    /**
     * (experimental) Imports a task definition from the specified task definition ARN.
     *
     * @experimental
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: ec2TaskDefinitionArn,
        });
    }
    /**
     * (experimental) Imports an existing Ec2 task definition from its attributes.
     *
     * @experimental
     */
    static fromEc2TaskDefinitionAttributes(scope, id, attrs) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.EC2,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
Ec2TaskDefinition[_a] = { fqn: "monocdk.aws_ecs.Ec2TaskDefinition", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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