import * as ec2 from "../../../aws-ec2";
import { Construct } from 'constructs';
import { BaseService, BaseServiceOptions, IBaseService, IService, PropagatedTagSource } from '../base/base-service';
import { TaskDefinition } from '../base/task-definition';
import { ICluster } from '../cluster';
import { PlacementConstraint, PlacementStrategy } from '../placement';
/**
 * (experimental) The properties for defining a service using the EC2 launch type.
 *
 * @experimental
 */
export interface Ec2ServiceProps extends BaseServiceOptions {
    /**
     * (experimental) The task definition to use for tasks in the service.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly taskDefinition: TaskDefinition;
    /**
     * (experimental) Specifies whether the task's elastic network interface receives a public IP address.
     *
     * If true, each task will receive a public IP address.
     *
     * This property is only used for tasks that use the awsvpc network mode.
     *
     * @default false
     * @experimental
     */
    readonly assignPublicIp?: boolean;
    /**
     * (experimental) The subnets to associate with the service.
     *
     * This property is only used for tasks that use the awsvpc network mode.
     *
     * @default - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (deprecated) The security groups to associate with the service.
     *
     * If you do not specify a security group, the default security group for the VPC is used.
     *
     * This property is only used for tasks that use the awsvpc network mode.
     *
     * @default - A new security group is created.
     * @deprecated use securityGroups instead.
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The security groups to associate with the service.
     *
     * If you do not specify a security group, the default security group for the VPC is used.
     *
     * This property is only used for tasks that use the awsvpc network mode.
     *
     * @default - A new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The placement constraints to use for tasks in the service.
     *
     * For more information, see
     * [Amazon ECS Task Placement Constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html).
     *
     * @default - No constraints.
     * @experimental
     */
    readonly placementConstraints?: PlacementConstraint[];
    /**
     * (experimental) The placement strategies to use for tasks in the service.
     *
     * For more information, see
     * [Amazon ECS Task Placement Strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
     *
     * @default - No strategies.
     * @experimental
     */
    readonly placementStrategies?: PlacementStrategy[];
    /**
     * (experimental) Specifies whether the service will use the daemon scheduling strategy.
     *
     * If true, the service scheduler deploys exactly one task on each container instance in your cluster.
     *
     * When you are using this strategy, do not specify a desired number of tasks orany task placement strategies.
     *
     * @default false
     * @experimental
     */
    readonly daemon?: boolean;
    /**
     * (deprecated) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     *
     * Tags can only be propagated to the tasks within the service during service creation.
     *
     * @default PropagatedTagSource.NONE
     * @deprecated Use `propagateTags` instead.
     */
    readonly propagateTaskTagsFrom?: PropagatedTagSource;
}
/**
 * (experimental) The interface for a service using the EC2 launch type on an ECS cluster.
 *
 * @experimental
 */
export interface IEc2Service extends IService {
}
/**
 * (experimental) The properties to import from the service using the EC2 launch type.
 *
 * @experimental
 */
export interface Ec2ServiceAttributes {
    /**
     * (experimental) The cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The service ARN.
     *
     * @default - either this, or {@link serviceName}, is required
     * @experimental
     */
    readonly serviceArn?: string;
    /**
     * (experimental) The name of the service.
     *
     * @default - either this, or {@link serviceArn}, is required
     * @experimental
     */
    readonly serviceName?: string;
}
/**
 * (experimental) This creates a service using the EC2 launch type on an ECS cluster.
 *
 * @experimental
 * @resource AWS::ECS::Service
 */
export declare class Ec2Service extends BaseService implements IEc2Service {
    /**
     * (experimental) Imports from the specified service ARN.
     *
     * @experimental
     */
    static fromEc2ServiceArn(scope: Construct, id: string, ec2ServiceArn: string): IEc2Service;
    /**
     * (experimental) Imports from the specified service attrributes.
     *
     * @experimental
     */
    static fromEc2ServiceAttributes(scope: Construct, id: string, attrs: Ec2ServiceAttributes): IBaseService;
    private readonly constraints;
    private readonly strategies;
    private readonly daemon;
    /**
     * (experimental) Constructs a new instance of the Ec2Service class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: Ec2ServiceProps);
    /**
     * (experimental) Adds one or more placement strategies to use for tasks in the service.
     *
     * For more information, see
     * [Amazon ECS Task Placement Strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
     *
     * @experimental
     */
    addPlacementStrategies(...strategies: PlacementStrategy[]): void;
    /**
     * (experimental) Adds one or more placement constraints to use for tasks in the service.
     *
     * For more information, see
     * [Amazon ECS Task Placement Constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html).
     *
     * @experimental
     */
    addPlacementConstraints(...constraints: PlacementConstraint[]): void;
    /**
     * (experimental) Validates this Ec2Service.
     *
     * @experimental
     */
    protected validate(): string[];
}
/**
 * (experimental) The built-in container instance attributes.
 *
 * @experimental
 */
export declare class BuiltInAttributes {
    /**
     * (experimental) The id of the instance.
     *
     * @experimental
     */
    static readonly INSTANCE_ID = "instanceId";
    /**
     * (experimental) The AvailabilityZone where the instance is running in.
     *
     * @experimental
     */
    static readonly AVAILABILITY_ZONE = "attribute:ecs.availability-zone";
    /**
     * (experimental) The AMI id the instance is using.
     *
     * @experimental
     */
    static readonly AMI_ID = "attribute:ecs.ami-id";
    /**
     * (experimental) The EC2 instance type.
     *
     * @experimental
     */
    static readonly INSTANCE_TYPE = "attribute:ecs.instance-type";
    /**
     * (experimental) The operating system of the instance.
     *
     * Either 'linux' or 'windows'.
     *
     * @experimental
     */
    static readonly OS_TYPE = "attribute:ecs.os-type";
}
