import * as ecr from "../../aws-ecr";
import { ContainerDefinition } from './container-definition';
import { CfnTaskDefinition } from './ecs.generated';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Constructs for types of container images.
 *
 * @experimental
 */
export declare abstract class ContainerImage {
    /**
     * (experimental) Reference an image on DockerHub or another online registry.
     *
     * @experimental
     */
    static fromRegistry(name: string, props?: RepositoryImageProps): RepositoryImage;
    /**
     * (experimental) Reference an image in an ECR repository.
     *
     * @experimental
     */
    static fromEcrRepository(repository: ecr.IRepository, tag?: string): EcrImage;
    /**
     * (experimental) Reference an image that's constructed directly from sources on disk.
     *
     * If you already have a `DockerImageAsset` instance, you can use the
     * `ContainerImage.fromDockerImageAsset` method instead.
     *
     * @param directory The directory containing the Dockerfile.
     * @experimental
     */
    static fromAsset(directory: string, props?: AssetImageProps): AssetImage;
    /**
     * (experimental) Use an existing `DockerImageAsset` for this container image.
     *
     * @param asset The `DockerImageAsset` to use for this container definition.
     * @experimental
     */
    static fromDockerImageAsset(asset: DockerImageAsset): ContainerImage;
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    abstract bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
/**
 * (experimental) The configuration for creating a container image.
 *
 * @experimental
 */
export interface ContainerImageConfig {
    /**
     * (experimental) Specifies the name of the container image.
     *
     * @experimental
     */
    readonly imageName: string;
    /**
     * (experimental) Specifies the credentials used to access the image repository.
     *
     * @experimental
     */
    readonly repositoryCredentials?: CfnTaskDefinition.RepositoryCredentialsProperty;
}
import { DockerImageAsset } from "../../aws-ecr-assets";
import { AssetImage, AssetImageProps } from './images/asset-image';
import { EcrImage } from './images/ecr';
import { RepositoryImage, RepositoryImageProps } from './images/repository';
