"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromServiceAtrributes = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
function fromServiceAtrributes(scope, id, attrs) {
    if ((attrs.serviceArn && attrs.serviceName) || (!attrs.serviceArn && !attrs.serviceName)) {
        throw new Error('You can only specify either serviceArn or serviceName.');
    }
    const stack = core_1.Stack.of(scope);
    let name;
    let arn;
    if (attrs.serviceName) {
        name = attrs.serviceName;
        arn = stack.formatArn({
            partition: stack.partition,
            service: 'ecs',
            region: stack.region,
            account: stack.account,
            resource: 'service',
            resourceName: name,
        });
    }
    else {
        arn = attrs.serviceArn;
        name = stack.parseArn(arn).resourceName;
    }
    class Import extends core_1.Resource {
        constructor() {
            super(...arguments);
            this.serviceArn = arn;
            this.serviceName = name;
            this.cluster = attrs.cluster;
        }
    }
    return new Import(scope, id);
}
exports.fromServiceAtrributes = fromServiceAtrributes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnJvbS1zZXJ2aWNlLWF0dHJpYnV0ZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcm9tLXNlcnZpY2UtYXR0cmlidXRlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBZ0QsQ0FBQyxnREFBZ0Q7QUF5QmpHLFNBQWdCLHFCQUFxQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO0lBQ3hGLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLFVBQVUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsRUFBRTtRQUN0RixNQUFNLElBQUksS0FBSyxDQUFDLHdEQUF3RCxDQUFDLENBQUM7S0FDN0U7SUFDRCxNQUFNLEtBQUssR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzlCLElBQUksSUFBWSxDQUFDO0lBQ2pCLElBQUksR0FBVyxDQUFDO0lBQ2hCLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTtRQUNuQixJQUFJLEdBQUcsS0FBSyxDQUFDLFdBQXFCLENBQUM7UUFDbkMsR0FBRyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDbEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLE9BQU8sRUFBRSxLQUFLO1lBQ2QsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixRQUFRLEVBQUUsU0FBUztZQUNuQixZQUFZLEVBQUUsSUFBSTtTQUNyQixDQUFDLENBQUM7S0FDTjtTQUNJO1FBQ0QsR0FBRyxHQUFHLEtBQUssQ0FBQyxVQUFvQixDQUFDO1FBQ2pDLElBQUksR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFlBQXNCLENBQUM7S0FDckQ7SUFDRCxNQUFNLE1BQU8sU0FBUSxlQUFRO1FBQTdCOztZQUNvQixlQUFVLEdBQUcsR0FBRyxDQUFDO1lBQ2pCLGdCQUFXLEdBQUcsSUFBSSxDQUFDO1lBQ25CLFlBQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzVDLENBQUM7S0FBQTtJQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ2pDLENBQUM7QUE1QkQsc0RBNEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElCYXNlU2VydmljZSB9IGZyb20gJy4uL2Jhc2UvYmFzZS1zZXJ2aWNlJztcbmltcG9ydCB7IElDbHVzdGVyIH0gZnJvbSAnLi4vY2x1c3Rlcic7XG4vKipcbiAqIFRoZSBwcm9wZXJ0aWVzIHRvIGltcG9ydCBmcm9tIHRoZSBzZXJ2aWNlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlcnZpY2VBdHRyaWJ1dGVzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgY2x1c3RlciB0aGF0IGhvc3RzIHRoZSBzZXJ2aWNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNsdXN0ZXI6IElDbHVzdGVyO1xuICAgIC8qKlxuICAgICAqIFRoZSBzZXJ2aWNlIEFSTi5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gZWl0aGVyIHRoaXMsIG9yIHtAbGluayBzZXJ2aWNlTmFtZX0sIGlzIHJlcXVpcmVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZUFybj86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgc2VydmljZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gZWl0aGVyIHRoaXMsIG9yIHtAbGluayBzZXJ2aWNlQXJufSwgaXMgcmVxdWlyZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2aWNlTmFtZT86IHN0cmluZztcbn1cbmV4cG9ydCBmdW5jdGlvbiBmcm9tU2VydmljZUF0cnJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IFNlcnZpY2VBdHRyaWJ1dGVzKTogSUJhc2VTZXJ2aWNlIHtcbiAgICBpZiAoKGF0dHJzLnNlcnZpY2VBcm4gJiYgYXR0cnMuc2VydmljZU5hbWUpIHx8ICghYXR0cnMuc2VydmljZUFybiAmJiAhYXR0cnMuc2VydmljZU5hbWUpKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignWW91IGNhbiBvbmx5IHNwZWNpZnkgZWl0aGVyIHNlcnZpY2VBcm4gb3Igc2VydmljZU5hbWUuJyk7XG4gICAgfVxuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2Yoc2NvcGUpO1xuICAgIGxldCBuYW1lOiBzdHJpbmc7XG4gICAgbGV0IGFybjogc3RyaW5nO1xuICAgIGlmIChhdHRycy5zZXJ2aWNlTmFtZSkge1xuICAgICAgICBuYW1lID0gYXR0cnMuc2VydmljZU5hbWUgYXMgc3RyaW5nO1xuICAgICAgICBhcm4gPSBzdGFjay5mb3JtYXRBcm4oe1xuICAgICAgICAgICAgcGFydGl0aW9uOiBzdGFjay5wYXJ0aXRpb24sXG4gICAgICAgICAgICBzZXJ2aWNlOiAnZWNzJyxcbiAgICAgICAgICAgIHJlZ2lvbjogc3RhY2sucmVnaW9uLFxuICAgICAgICAgICAgYWNjb3VudDogc3RhY2suYWNjb3VudCxcbiAgICAgICAgICAgIHJlc291cmNlOiAnc2VydmljZScsXG4gICAgICAgICAgICByZXNvdXJjZU5hbWU6IG5hbWUsXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgICAgYXJuID0gYXR0cnMuc2VydmljZUFybiBhcyBzdHJpbmc7XG4gICAgICAgIG5hbWUgPSBzdGFjay5wYXJzZUFybihhcm4pLnJlc291cmNlTmFtZSBhcyBzdHJpbmc7XG4gICAgfVxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUJhc2VTZXJ2aWNlIHtcbiAgICAgICAgcHVibGljIHJlYWRvbmx5IHNlcnZpY2VBcm4gPSBhcm47XG4gICAgICAgIHB1YmxpYyByZWFkb25seSBzZXJ2aWNlTmFtZSA9IG5hbWU7XG4gICAgICAgIHB1YmxpYyByZWFkb25seSBjbHVzdGVyID0gYXR0cnMuY2x1c3RlcjtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbn1cbiJdfQ==