"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTaskDefinition = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_definition_1 = require("./task-definition");
/**
 * Task definition reference of an imported task
 */
class ImportedTaskDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        /**
         * Execution role for this task definition
         */
        this.executionRole = undefined;
        this.compatibility = (_a = props.compatibility) !== null && _a !== void 0 ? _a : task_definition_1.Compatibility.EC2_AND_FARGATE;
        this.taskDefinitionArn = props.taskDefinitionArn;
        this._taskRole = props.taskRole;
        this._networkMode = props.networkMode;
    }
    get networkMode() {
        if (this._networkMode == undefined) {
            throw new Error('This operation requires the networkMode in ImportedTaskDefinition to be defined. ' +
                'Add the \'networkMode\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._networkMode;
        }
    }
    get taskRole() {
        if (this._taskRole == undefined) {
            throw new Error('This operation requires the taskRole in ImportedTaskDefinition to be defined. ' +
                'Add the \'taskRole\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._taskRole;
        }
    }
    /**
     * Return true if the task definition can be run on an EC2 cluster
     */
    get isEc2Compatible() {
        return task_definition_1.isEc2Compatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a Fargate cluster
     */
    get isFargateCompatible() {
        return task_definition_1.isFargateCompatible(this.compatibility);
    }
}
exports.ImportedTaskDefinition = ImportedTaskDefinition;
//# sourceMappingURL=data:application/json;base64,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