import { FargateTaskDefinition, FargatePlatformVersion } from "../../../aws-ecs";
import { Construct } from 'constructs';
import { ScheduledTaskBase, ScheduledTaskBaseProps, ScheduledTaskImageProps } from '../base/scheduled-task-base';
/**
 * (experimental) The properties for the ScheduledFargateTask task.
 *
 * @experimental
 */
export interface ScheduledFargateTaskProps extends ScheduledTaskBaseProps {
    /**
     * (experimental) The properties to define if using an existing TaskDefinition in this construct.
     *
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     *
     * @default none
     * @experimental
     */
    readonly scheduledFargateTaskDefinitionOptions?: ScheduledFargateTaskDefinitionOptions;
    /**
     * (experimental) The properties to define if the construct is to create a TaskDefinition.
     *
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     *
     * @default none
     * @experimental
     */
    readonly scheduledFargateTaskImageOptions?: ScheduledFargateTaskImageOptions;
    /**
     * (experimental) The platform version on which to run your service.
     *
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * @default Latest
     * @experimental
     */
    readonly platformVersion?: FargatePlatformVersion;
}
/**
 * (experimental) The properties for the ScheduledFargateTask using an image.
 *
 * @experimental
 */
export interface ScheduledFargateTaskImageOptions extends ScheduledTaskImageProps {
    /**
     * (experimental) The number of cpu units used by the task.
     *
     * Valid values, which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     *
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     *
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     *
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     *
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 256
     * @experimental
     */
    readonly cpu?: number;
    /**
     * (experimental) The hard limit (in MiB) of memory to present to the container.
     *
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     *
     * @default 512
     * @experimental
     */
    readonly memoryLimitMiB?: number;
}
/**
 * (experimental) The properties for the ScheduledFargateTask using a task definition.
 *
 * @experimental
 */
export interface ScheduledFargateTaskDefinitionOptions {
    /**
     * (experimental) The task definition to use for tasks in the service. Image or taskDefinition must be specified, but not both.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - none
     * @experimental
     */
    readonly taskDefinition: FargateTaskDefinition;
}
/**
 * (experimental) A scheduled Fargate task that will be initiated off of CloudWatch Events.
 *
 * @experimental
 */
export declare class ScheduledFargateTask extends ScheduledTaskBase {
    /**
     * (experimental) The Fargate task definition in this construct.
     *
     * @experimental
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * (experimental) Constructs a new instance of the ScheduledFargateTask class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ScheduledFargateTaskProps);
}
