import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { IResource, RemovalPolicy, Resource } from "../../core";
import { IConstruct, Construct } from 'constructs';
import { LifecycleRule } from './lifecycle';
/**
 * (experimental) Represents an ECR repository.
 *
 * @experimental
 */
export interface IRepository extends IResource {
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryName: string;
    /**
     * (experimental) The ARN of the repository.
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryArn: string;
    /**
     * (experimental) The URI of this repository (represents the latest image):.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
     *
     * @experimental
     * @attribute true
     */
    readonly repositoryUri: string;
    /**
     * (experimental) Returns the URI of the repository for a certain tag. Can be used in `docker push/pull`.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     *
     * @param tag Image tag to use (tools usually default to "latest" if omitted).
     * @experimental
     */
    repositoryUriForTag(tag?: string): string;
    /**
     * (experimental) Returns the URI of the repository for a certain tag. Can be used in `docker push/pull`.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[@DIGEST]
     *
     * @param digest Image digest to use (tools usually default to the image with the "latest" tag if omitted).
     * @experimental
     */
    repositoryUriForDigest(digest?: string): string;
    /**
     * (experimental) Add a policy statement to the repository's resource policy.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant the given principal identity permissions to perform the actions on this repository.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull images in this repository.
     *
     * @experimental
     */
    grantPull(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull and push images to this repository.
     *
     * @experimental
     */
    grantPullPush(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Define a CloudWatch event that triggers when something happens to this repository.
     *
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onCloudTrailEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     *
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onCloudTrailImagePushed(id: string, options?: OnCloudTrailImagePushedOptions): events.Rule;
    /**
     * (experimental) Defines an AWS CloudWatch event rule that can trigger a target when the image scan is completed.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onImageScanCompleted(id: string, options?: OnImageScanCompletedOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * (experimental) Base class for ECR repository.
 *
 * Reused between imported repositories and owned repositories.
 *
 * @experimental
 */
export declare abstract class RepositoryBase extends Resource implements IRepository {
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     */
    abstract readonly repositoryName: string;
    /**
     * (experimental) The ARN of the repository.
     *
     * @experimental
     */
    abstract readonly repositoryArn: string;
    /**
     * (experimental) Add a policy statement to the repository's resource policy.
     *
     * @experimental
     */
    abstract addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) The URI of this repository (represents the latest image):.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY
     *
     * @experimental
     */
    get repositoryUri(): string;
    /**
     * (experimental) Returns the URL of the repository. Can be used in `docker push/pull`.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[:TAG]
     *
     * @param tag Optional image tag.
     * @experimental
     */
    repositoryUriForTag(tag?: string): string;
    /**
     * (experimental) Returns the URL of the repository. Can be used in `docker push/pull`.
     *
     * ACCOUNT.dkr.ecr.REGION.amazonaws.com/REPOSITORY[@DIGEST]
     *
     * @param digest Optional image digest.
     * @experimental
     */
    repositoryUriForDigest(digest?: string): string;
    /**
     * Returns the repository URI, with an appended suffix, if provided.
     * @param suffix An image tag or an image digest.
     * @private
     */
    private repositoryUriWithSuffix;
    /**
     * (experimental) Define a CloudWatch event that triggers when something happens to this repository.
     *
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onCloudTrailEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Defines an AWS CloudWatch event rule that can trigger a target when an image is pushed to this repository.
     *
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onCloudTrailImagePushed(id: string, options?: OnCloudTrailImagePushedOptions): events.Rule;
    /**
     * (experimental) Defines an AWS CloudWatch event rule that can trigger a target when an image scan is completed.
     *
     * @param id The id of the rule.
     * @param options Options for adding the rule.
     * @experimental
     */
    onImageScanCompleted(id: string, options?: OnImageScanCompletedOptions): events.Rule;
    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Grant the given principal identity permissions to perform the actions on this repository.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to use the images in this repository.
     *
     * @experimental
     */
    grantPull(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the given identity permissions to pull and push images to this repository.
     *
     * @experimental
     */
    grantPullPush(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Options for the onCloudTrailImagePushed method.
 *
 * @experimental
 */
export interface OnCloudTrailImagePushedOptions extends events.OnEventOptions {
    /**
     * (experimental) Only watch changes to this image tag.
     *
     * @default - Watch changes to all tags
     * @experimental
     */
    readonly imageTag?: string;
}
/**
 * (experimental) Options for the OnImageScanCompleted method.
 *
 * @experimental
 */
export interface OnImageScanCompletedOptions extends events.OnEventOptions {
    /**
     * (experimental) Only watch changes to the image tags spedified.
     *
     * Leave it undefined to watch the full repository.
     *
     * @default - Watch the changes to the repository with all image tags
     * @experimental
     */
    readonly imageTags?: string[];
}
/**
 * @experimental
 */
export interface RepositoryProps {
    /**
     * (experimental) Name for this repository.
     *
     * @default Automatically generated name.
     * @experimental
     */
    readonly repositoryName?: string;
    /**
     * (experimental) Life cycle rules to apply to this registry.
     *
     * @default No life cycle rules
     * @experimental
     */
    readonly lifecycleRules?: LifecycleRule[];
    /**
     * (experimental) The AWS account ID associated with the registry that contains the repository.
     *
     * @default The default registry is assumed.
     * @see https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_PutLifecyclePolicy.html
     * @experimental
     */
    readonly lifecycleRegistryId?: string;
    /**
     * (experimental) Determine what happens to the repository when the resource/stack is deleted.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Enable the scan on push when creating the repository.
     *
     * @default false
     * @experimental
     */
    readonly imageScanOnPush?: boolean;
    /**
     * (experimental) The tag mutability setting for the repository.
     *
     * If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten.
     *
     * @default TagMutability.MUTABLE
     * @experimental
     */
    readonly imageTagMutability?: TagMutability;
}
/**
 * @experimental
 */
export interface RepositoryAttributes {
    /**
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * @experimental
     */
    readonly repositoryArn: string;
}
/**
 * (experimental) Define an ECR repository.
 *
 * @experimental
 */
export declare class Repository extends RepositoryBase {
    /**
     * (experimental) Import a repository.
     *
     * @experimental
     */
    static fromRepositoryAttributes(scope: Construct, id: string, attrs: RepositoryAttributes): IRepository;
    /**
     * @experimental
     */
    static fromRepositoryArn(scope: Construct, id: string, repositoryArn: string): IRepository;
    /**
     * @experimental
     */
    static fromRepositoryName(scope: Construct, id: string, repositoryName: string): IRepository;
    /**
     * (experimental) Returns an ECR ARN for a repository that resides in the same account/region as the current stack.
     *
     * @experimental
     */
    static arnForLocalRepository(repositoryName: string, scope: IConstruct, account?: string): string;
    private static validateRepositoryName;
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The ARN of the repository.
     *
     * @experimental
     */
    readonly repositoryArn: string;
    private readonly lifecycleRules;
    private readonly registryId?;
    private policyDocument?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: RepositoryProps);
    /**
     * (experimental) Add a policy statement to the repository's resource policy.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Add a life cycle rule to the repository.
     *
     * Life cycle rules automatically expire images from the repository that match
     * certain conditions.
     *
     * @experimental
     */
    addLifecycleRule(rule: LifecycleRule): void;
    /**
     * Render the life cycle policy object
     */
    private renderLifecyclePolicy;
    /**
     * Return life cycle rules with automatic ordering applied.
     *
     * Also applies validation of the 'any' rule.
     */
    private orderedLifecycleRules;
}
/**
 * (experimental) The tag mutability setting for your repository.
 *
 * @experimental
 */
export declare enum TagMutability {
    /**
     * (experimental) allow image tags to be overwritten.
     *
     * @experimental
     */
    MUTABLE = "MUTABLE",
    /**
     * (experimental) all image tags within the repository will be immutable which will prevent them from being overwritten.
     *
     * @experimental
     */
    IMMUTABLE = "IMMUTABLE"
}
