import { Duration } from "../../core";
/**
 * (experimental) An ECR life cycle rule.
 *
 * @experimental
 */
export interface LifecycleRule {
    /**
     * (experimental) Controls the order in which rules are evaluated (low to high).
     *
     * All rules must have a unique priority, where lower numbers have
     * higher precedence. The first rule that matches is applied to an image.
     *
     * There can only be one rule with a tagStatus of Any, and it must have
     * the highest rulePriority.
     *
     * All rules without a specified priority will have incrementing priorities
     * automatically assigned to them, higher than any rules that DO have priorities.
     *
     * @default Automatically assigned
     * @experimental
     */
    readonly rulePriority?: number;
    /**
     * (experimental) Describes the purpose of the rule.
     *
     * @default No description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Select images based on tags.
     *
     * Only one rule is allowed to select untagged images, and it must
     * have the highest rulePriority.
     *
     * @default TagStatus.Tagged if tagPrefixList is given, TagStatus.Any otherwise
     * @experimental
     */
    readonly tagStatus?: TagStatus;
    /**
     * (experimental) Select images that have ALL the given prefixes in their tag.
     *
     * Only if tagStatus == TagStatus.Tagged
     *
     * @experimental
     */
    readonly tagPrefixList?: string[];
    /**
     * (experimental) The maximum number of images to retain.
     *
     * Specify exactly one of maxImageCount and maxImageAge.
     *
     * @experimental
     */
    readonly maxImageCount?: number;
    /**
     * (experimental) The maximum age of images to retain. The value must represent a number of days.
     *
     * Specify exactly one of maxImageCount and maxImageAge.
     *
     * @experimental
     */
    readonly maxImageAge?: Duration;
}
/**
 * (experimental) Select images based on tags.
 *
 * @experimental
 */
export declare enum TagStatus {
    /**
     * (experimental) Rule applies to all images.
     *
     * @experimental
     */
    ANY = "any",
    /**
     * (experimental) Rule applies to tagged images.
     *
     * @experimental
     */
    TAGGED = "tagged",
    /**
     * (experimental) Rule applies to untagged images.
     *
     * @experimental
     */
    UNTAGGED = "untagged"
}
