import * as iam from "../../aws-iam";
/**
 * (experimental) Authorization token to access private ECR repositories in the current environment via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry_auth.html
 * @experimental
 */
export declare class AuthorizationToken {
    /**
     * (experimental) Grant access to retrieve an authorization token.
     *
     * @experimental
     */
    static grantRead(grantee: iam.IGrantable): void;
    private constructor();
}
/**
 * (experimental) Authorization token to access the global public ECR Gallery via Docker CLI.
 *
 * @see https://docs.aws.amazon.com/AmazonECR/latest/public/public-registries.html#public-registry-auth
 * @experimental
 */
export declare class PublicGalleryAuthorizationToken {
    /**
     * (experimental) Grant access to retrieve an authorization token.
     *
     * @experimental
     */
    static grantRead(grantee: iam.IGrantable): void;
    private constructor();
}
