import { ArnPrincipal } from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A load balancer that can host a VPC Endpoint Service.
 *
 * @experimental
 */
export interface IVpcEndpointServiceLoadBalancer {
    /**
     * (experimental) The ARN of the load balancer that hosts the VPC Endpoint Service.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
}
/**
 * (experimental) A VPC endpoint service.
 *
 * @experimental
 */
export interface IVpcEndpointService extends IResource {
    /**
     * (experimental) The service name of the VPC Endpoint Service that clients use to connect to, like com.amazonaws.vpce.<region>.vpce-svc-xxxxxxxxxxxxxxxx.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointServiceName: string;
    /**
     * (experimental) The id of the VPC Endpoint Service that clients use to connect to, like vpce-svc-xxxxxxxxxxxxxxxx.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointServiceId: string;
}
/**
 * (experimental) A VPC endpoint service.
 *
 * @experimental
 * @resource AWS::EC2::VPCEndpointService
 */
export declare class VpcEndpointService extends Resource implements IVpcEndpointService {
    /**
     * (experimental) One or more network load balancers to host the service.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointServiceLoadBalancers: IVpcEndpointServiceLoadBalancer[];
    /**
     * (experimental) Whether to require manual acceptance of new connections to the service.
     *
     * @experimental
     */
    readonly acceptanceRequired: boolean;
    /**
     * (deprecated) One or more Principal ARNs to allow inbound connections to.
     *
     * @deprecated use `allowedPrincipals`
     */
    readonly whitelistedPrincipals: ArnPrincipal[];
    /**
     * (experimental) One or more Principal ARNs to allow inbound connections to.
     *
     * @experimental
     */
    readonly allowedPrincipals: ArnPrincipal[];
    /**
     * (experimental) The id of the VPC Endpoint Service, like vpce-svc-xxxxxxxxxxxxxxxx.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointServiceId: string;
    /**
     * (experimental) The service name of the VPC Endpoint Service that clients use to connect to, like com.amazonaws.vpce.<region>.vpce-svc-xxxxxxxxxxxxxxxx.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcEndpointServiceName: string;
    private readonly endpointService;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VpcEndpointServiceProps);
}
/**
 * (experimental) Construction properties for a VpcEndpointService.
 *
 * @experimental
 */
export interface VpcEndpointServiceProps {
    /**
     * (deprecated) Name of the Vpc Endpoint Service.
     *
     * @default - CDK generated name
     * @deprecated This property is not used
     */
    readonly vpcEndpointServiceName?: string;
    /**
     * (experimental) One or more load balancers to host the VPC Endpoint Service.
     *
     * @experimental
     */
    readonly vpcEndpointServiceLoadBalancers: IVpcEndpointServiceLoadBalancer[];
    /**
     * (experimental) Whether requests from service consumers to connect to the service through an endpoint must be accepted.
     *
     * @default true
     * @experimental
     */
    readonly acceptanceRequired?: boolean;
    /**
     * (deprecated) IAM users, IAM roles, or AWS accounts to allow inbound connections from.
     *
     * These principals can connect to your service using VPC endpoints. Takes a
     * list of one or more ArnPrincipal.
     *
     * @default - no principals
     * @deprecated use `allowedPrincipals`
     */
    readonly whitelistedPrincipals?: ArnPrincipal[];
    /**
     * (experimental) IAM users, IAM roles, or AWS accounts to allow inbound connections from.
     *
     * These principals can connect to your service using VPC endpoints. Takes a
     * list of one or more ArnPrincipal.
     *
     * @default - no principals
     * @experimental
     */
    readonly allowedPrincipals?: ArnPrincipal[];
}
