import { IBucket } from "../../aws-s3";
import { Resource } from "../../core";
import { OperatingSystemType } from './machine-image';
/**
 * (experimental) Options when constructing UserData for Linux.
 *
 * @experimental
 */
export interface LinuxUserDataOptions {
    /**
     * (experimental) Shebang for the UserData script.
     *
     * @default "#!/bin/bash"
     * @experimental
     */
    readonly shebang?: string;
}
/**
 * (experimental) Options when downloading files from S3.
 *
 * @experimental
 */
export interface S3DownloadOptions {
    /**
     * (experimental) Name of the S3 bucket to download from.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) The key of the file to download.
     *
     * @experimental
     */
    readonly bucketKey: string;
    /**
     * (experimental) The name of the local file.
     *
     * @default Linux   - /tmp/bucketKey
     * Windows - %TEMP%/bucketKey
     * @experimental
     */
    readonly localFile?: string;
}
/**
 * (experimental) Options when executing a file.
 *
 * @experimental
 */
export interface ExecuteFileOptions {
    /**
     * (experimental) The path to the file.
     *
     * @experimental
     */
    readonly filePath: string;
    /**
     * (experimental) The arguments to be passed to the file.
     *
     * @default No arguments are passed to the file.
     * @experimental
     */
    readonly arguments?: string;
}
/**
 * (experimental) Instance User Data.
 *
 * @experimental
 */
export declare abstract class UserData {
    /**
     * (experimental) Create a userdata object for Linux hosts.
     *
     * @experimental
     */
    static forLinux(options?: LinuxUserDataOptions): UserData;
    /**
     * (experimental) Create a userdata object for Windows hosts.
     *
     * @experimental
     */
    static forWindows(): UserData;
    /**
     * (experimental) Create a userdata object with custom content.
     *
     * @experimental
     */
    static custom(content: string): UserData;
    /**
     * @experimental
     */
    static forOperatingSystem(os: OperatingSystemType): UserData;
    /**
     * (experimental) Add one or more commands to the user data.
     *
     * @experimental
     */
    abstract addCommands(...commands: string[]): void;
    /**
     * (experimental) Add one or more commands to the user data that will run when the script exits.
     *
     * @experimental
     */
    abstract addOnExitCommands(...commands: string[]): void;
    /**
     * (experimental) Render the UserData for use in a construct.
     *
     * @experimental
     */
    abstract render(): string;
    /**
     * (experimental) Adds commands to download a file from S3.
     *
     * @returns : The local path that the file will be downloaded to
     * @experimental
     */
    abstract addS3DownloadCommand(params: S3DownloadOptions): string;
    /**
     * (experimental) Adds commands to execute a file.
     *
     * @experimental
     */
    abstract addExecuteFileCommand(params: ExecuteFileOptions): void;
    /**
     * (experimental) Adds a command which will send a cfn-signal when the user data script ends.
     *
     * @experimental
     */
    abstract addSignalOnExitCommand(resource: Resource): void;
}
/**
 * (experimental) Options when creating `MultipartBody`.
 *
 * @experimental
 */
export interface MultipartBodyOptions {
    /**
     * (experimental) `Content-Type` header of this part.
     *
     * Some examples of content types:
     * * `text/x-shellscript; charset="utf-8"` (shell script)
     * * `text/cloud-boothook; charset="utf-8"` (shell script executed during boot phase)
     *
     * For Linux shell scripts use `text/x-shellscript`.
     *
     * @experimental
     */
    readonly contentType: string;
    /**
     * (experimental) `Content-Transfer-Encoding` header specifying part encoding.
     *
     * @default undefined - body is not encoded
     * @experimental
     */
    readonly transferEncoding?: string;
    /**
     * (experimental) The body of message.
     *
     * @default undefined - body will not be added to part
     * @experimental
     */
    readonly body?: string;
}
/**
 * (experimental) The base class for all classes which can be used as {@link MultipartUserData}.
 *
 * @experimental
 */
export declare abstract class MultipartBody {
    /**
     * (experimental) Content type for shell scripts.
     *
     * @experimental
     */
    static readonly SHELL_SCRIPT = "text/x-shellscript; charset=\"utf-8\"";
    /**
     * (experimental) Content type for boot hooks.
     *
     * @experimental
     */
    static readonly CLOUD_BOOTHOOK = "text/cloud-boothook; charset=\"utf-8\"";
    /**
     * (experimental) Constructs the new `MultipartBody` wrapping existing `UserData`. Modification to `UserData` are reflected in subsequent renders of the part.
     *
     * For more information about content types see {@link MultipartBodyOptions.contentType}.
     *
     * @param userData user data to wrap into body part.
     * @param contentType optional content type, if default one should not be used.
     * @experimental
     */
    static fromUserData(userData: UserData, contentType?: string): MultipartBody;
    /**
     * (experimental) Constructs the raw `MultipartBody` using specified body, content type and transfer encoding.
     *
     * When transfer encoding is specified (typically as Base64), it's caller responsibility to convert body to
     * Base64 either by wrapping with `Fn.base64` or by converting it by other converters.
     *
     * @experimental
     */
    static fromRawBody(opts: MultipartBodyOptions): MultipartBody;
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Render body part as the string.
     *
     * Subclasses should not add leading nor trailing new line characters (\r \n)
     *
     * @experimental
     */
    abstract renderBodyPart(): string[];
}
/**
 * (experimental) Options for creating {@link MultipartUserData}.
 *
 * @experimental
 */
export interface MultipartUserDataOptions {
    /**
     * (experimental) The string used to separate parts in multipart user data archive (it's like MIME boundary).
     *
     * This string should contain [a-zA-Z0-9()+,-./:=?] characters only, and should not be present in any part, or in text content of archive.
     *
     * @default `+AWS+CDK+User+Data+Separator==`
     * @experimental
     */
    readonly partsSeparator?: string;
}
/**
 * (experimental) Mime multipart user data.
 *
 * This class represents MIME multipart user data, as described in.
 * [Specifying Multiple User Data Blocks Using a MIME Multi Part Archive](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#multi-part_user_data)
 *
 * @experimental
 */
export declare class MultipartUserData extends UserData {
    private static readonly USE_PART_ERROR;
    private static readonly BOUNDRY_PATTERN;
    private parts;
    private opts;
    /**
     * @experimental
     */
    constructor(opts?: MultipartUserDataOptions);
    /**
     * (experimental) Adds a part to the list of parts.
     *
     * @experimental
     */
    addPart(part: MultipartBody): void;
    /**
     * (experimental) Adds a multipart part based on a UserData object.
     *
     * This is the same as calling:
     *
     * ```ts
     * multiPart.addPart(MultipartBody.fromUserData(userData, contentType));
     * ```
     *
     * @experimental
     */
    addUserDataPart(userData: UserData, contentType?: string): void;
    /**
     * (experimental) Render the UserData for use in a construct.
     *
     * @experimental
     */
    render(): string;
    /**
     * (experimental) Adds commands to download a file from S3.
     *
     * @experimental
     */
    addS3DownloadCommand(_params: S3DownloadOptions): string;
    /**
     * (experimental) Adds commands to execute a file.
     *
     * @experimental
     */
    addExecuteFileCommand(_params: ExecuteFileOptions): void;
    /**
     * (experimental) Adds a command which will send a cfn-signal when the user data script ends.
     *
     * @experimental
     */
    addSignalOnExitCommand(_resource: Resource): void;
    /**
     * (experimental) Add one or more commands to the user data.
     *
     * @experimental
     */
    addCommands(..._commands: string[]): void;
    /**
     * (experimental) Add one or more commands to the user data that will run when the script exits.
     *
     * @experimental
     */
    addOnExitCommands(..._commands: string[]): void;
}
