"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.launchTemplateBlockDeviceMappings = exports.instanceBlockDeviceMappings = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const volume_1 = require("../volume");
function instanceBlockDeviceMappings(construct, blockDevices) {
    return synthesizeBlockDeviceMappings(construct, blockDevices, {});
}
exports.instanceBlockDeviceMappings = instanceBlockDeviceMappings;
function launchTemplateBlockDeviceMappings(construct, blockDevices) {
    return synthesizeBlockDeviceMappings(construct, blockDevices, '');
}
exports.launchTemplateBlockDeviceMappings = launchTemplateBlockDeviceMappings;
/**
 * Synthesize an array of block device mappings from a list of block device
 *
 * @param construct the instance/asg construct, used to host any warning
 * @param blockDevices list of block devices
 */
function synthesizeBlockDeviceMappings(construct, blockDevices, noDeviceValue) {
    return blockDevices.map(({ deviceName, volume, mappingEnabled }) => {
        const { virtualName, ebsDevice: ebs } = volume;
        if (ebs) {
            const { iops, volumeType } = ebs;
            if (!iops) {
                if (volumeType === volume_1.EbsDeviceVolumeType.IO1) {
                    throw new Error('iops property is required with volumeType: EbsDeviceVolumeType.IO1');
                }
            }
            else if (volumeType !== volume_1.EbsDeviceVolumeType.IO1) {
                core_1.Annotations.of(construct).addWarning('iops will be ignored without volumeType: EbsDeviceVolumeType.IO1');
            }
        }
        const noDevice = mappingEnabled === false ? noDeviceValue : undefined;
        return { deviceName, ebs, virtualName, noDevice };
    });
}
//# sourceMappingURL=data:application/json;base64,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