"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Port = exports.Protocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Protocol for use in Connection Rules.
 *
 * https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
 *
 * @experimental
 */
var Protocol;
(function (Protocol) {
    Protocol["ALL"] = "-1";
    Protocol["HOPOPT"] = "0";
    Protocol["ICMP"] = "icmp";
    Protocol["IGMP"] = "2";
    Protocol["GGP"] = "3";
    Protocol["IPV4"] = "4";
    Protocol["ST"] = "5";
    Protocol["TCP"] = "tcp";
    Protocol["CBT"] = "7";
    Protocol["EGP"] = "8";
    Protocol["IGP"] = "9";
    Protocol["BBN_RCC_MON"] = "10";
    Protocol["NVP_II"] = "11";
    Protocol["PUP"] = "12";
    Protocol["EMCON"] = "14";
    Protocol["XNET"] = "15";
    Protocol["CHAOS"] = "16";
    Protocol["UDP"] = "udp";
    Protocol["MUX"] = "18";
    Protocol["DCN_MEAS"] = "19";
    Protocol["HMP"] = "20";
    Protocol["PRM"] = "21";
    Protocol["XNS_IDP"] = "22";
    Protocol["TRUNK_1"] = "23";
    Protocol["TRUNK_2"] = "24";
    Protocol["LEAF_1"] = "25";
    Protocol["LEAF_2"] = "26";
    Protocol["RDP"] = "27";
    Protocol["IRTP"] = "28";
    Protocol["ISO_TP4"] = "29";
    Protocol["NETBLT"] = "30";
    Protocol["MFE_NSP"] = "31";
    Protocol["MERIT_INP"] = "32";
    Protocol["DCCP"] = "33";
    Protocol["THREEPC"] = "34";
    Protocol["IDPR"] = "35";
    Protocol["XTP"] = "36";
    Protocol["DDP"] = "37";
    Protocol["IDPR_CMTP"] = "38";
    Protocol["TPPLUSPLUS"] = "39";
    Protocol["IL"] = "40";
    Protocol["IPV6"] = "41";
    Protocol["SDRP"] = "42";
    Protocol["IPV6_ROUTE"] = "43";
    Protocol["IPV6_FRAG"] = "44";
    Protocol["IDRP"] = "45";
    Protocol["RSVP"] = "46";
    Protocol["GRE"] = "47";
    Protocol["DSR"] = "48";
    Protocol["BNA"] = "49";
    Protocol["ESP"] = "50";
    Protocol["AH"] = "51";
    Protocol["I_NLSP"] = "52";
    Protocol["SWIPE"] = "53";
    Protocol["NARP"] = "54";
    Protocol["MOBILE"] = "55";
    Protocol["TLSP"] = "56";
    Protocol["SKIP"] = "57";
    Protocol["ICMPV6"] = "icmpv6";
    Protocol["IPV6_NONXT"] = "59";
    Protocol["IPV6_OPTS"] = "60";
    Protocol["CFTP"] = "62";
    Protocol["ANY_LOCAL"] = "63";
    Protocol["SAT_EXPAK"] = "64";
    Protocol["KRYPTOLAN"] = "65";
    Protocol["RVD"] = "66";
    Protocol["IPPC"] = "67";
    Protocol["ANY_DFS"] = "68";
    Protocol["SAT_MON"] = "69";
    Protocol["VISA"] = "70";
    Protocol["IPCV"] = "71";
    Protocol["CPNX"] = "72";
    Protocol["CPHB"] = "73";
    Protocol["WSN"] = "74";
    Protocol["PVP"] = "75";
    Protocol["BR_SAT_MON"] = "76";
    Protocol["SUN_ND"] = "77";
    Protocol["WB_MON"] = "78";
    Protocol["WB_EXPAK"] = "79";
    Protocol["ISO_IP"] = "80";
    Protocol["VMTP"] = "81";
    Protocol["SECURE_VMTP"] = "82";
    Protocol["VINES"] = "83";
    Protocol["TTP"] = "84";
    Protocol["IPTM"] = "84";
    Protocol["NSFNET_IGP"] = "85";
    Protocol["DGP"] = "86";
    Protocol["TCF"] = "87";
    Protocol["EIGRP"] = "88";
    Protocol["OSPFIGP"] = "89";
    Protocol["SPRITE_RPC"] = "90";
    Protocol["LARP"] = "91";
    Protocol["MTP"] = "92";
    Protocol["AX_25"] = "93";
    Protocol["IPIP"] = "94";
    Protocol["MICP"] = "95";
    Protocol["SCC_SP"] = "96";
    Protocol["ETHERIP"] = "97";
    Protocol["ENCAP"] = "98";
    Protocol["ANY_ENC"] = "99";
    Protocol["GMTP"] = "100";
    Protocol["IFMP"] = "101";
    Protocol["PNNI"] = "102";
    Protocol["PIM"] = "103";
    Protocol["ARIS"] = "104";
    Protocol["SCPS"] = "105";
    Protocol["QNX"] = "106";
    Protocol["A_N"] = "107";
    Protocol["IPCOMP"] = "108";
    Protocol["SNP"] = "109";
    Protocol["COMPAQ_PEER"] = "110";
    Protocol["IPX_IN_IP"] = "111";
    Protocol["VRRP"] = "112";
    Protocol["PGM"] = "113";
    Protocol["ANY_0_HOP"] = "114";
    Protocol["L2_T_P"] = "115";
    Protocol["DDX"] = "116";
    Protocol["IATP"] = "117";
    Protocol["STP"] = "118";
    Protocol["SRP"] = "119";
    Protocol["UTI"] = "120";
    Protocol["SMP"] = "121";
    Protocol["SM"] = "122";
    Protocol["PTP"] = "123";
    Protocol["ISIS_IPV4"] = "124";
    Protocol["FIRE"] = "125";
    Protocol["CRTP"] = "126";
    Protocol["CRUDP"] = "127";
    Protocol["SSCOPMCE"] = "128";
    Protocol["IPLT"] = "129";
    Protocol["SPS"] = "130";
    Protocol["PIPE"] = "131";
    Protocol["SCTP"] = "132";
    Protocol["FC"] = "133";
    Protocol["RSVP_E2E_IGNORE"] = "134";
    Protocol["MOBILITY_HEADER"] = "135";
    Protocol["UDPLITE"] = "136";
    Protocol["MPLS_IN_IP"] = "137";
    Protocol["MANET"] = "138";
    Protocol["HIP"] = "139";
    Protocol["SHIM6"] = "140";
    Protocol["WESP"] = "141";
    Protocol["ROHC"] = "142";
    Protocol["ETHERNET"] = "143";
    Protocol["EXPERIMENT_1"] = "253";
    Protocol["EXPERIMENT_2"] = "254";
    Protocol["RESERVED"] = "255";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * (experimental) Interface for classes that provide the connection-specification parts of a security group rule.
 *
 * @experimental
 */
class Port {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        this.canInlineRule = !core_1.Token.isUnresolved(props.fromPort) && !core_1.Token.isUnresolved(props.toPort);
    }
    /**
     * (experimental) A single TCP port.
     *
     * @experimental
     */
    static tcp(port) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: port,
            toPort: port,
            stringRepresentation: renderPort(port),
        });
    }
    /**
     * (experimental) A TCP port range.
     *
     * @experimental
     */
    static tcpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: startPort,
            toPort: endPort,
            stringRepresentation: `${renderPort(startPort)}-${renderPort(endPort)}`,
        });
    }
    /**
     * (experimental) Any TCP traffic.
     *
     * @experimental
     */
    static allTcp() {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: 0,
            toPort: 65535,
            stringRepresentation: 'ALL PORTS',
        });
    }
    /**
     * (experimental) A single UDP port.
     *
     * @experimental
     */
    static udp(port) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: port,
            toPort: port,
            stringRepresentation: `UDP ${renderPort(port)}`,
        });
    }
    /**
     * (experimental) A UDP port range.
     *
     * @experimental
     */
    static udpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: startPort,
            toPort: endPort,
            stringRepresentation: `UDP ${renderPort(startPort)}-${renderPort(endPort)}`,
        });
    }
    /**
     * (experimental) Any UDP traffic.
     *
     * @experimental
     */
    static allUdp() {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: 0,
            toPort: 65535,
            stringRepresentation: 'UDP ALL PORTS',
        });
    }
    /**
     * (experimental) A specific combination of ICMP type and code.
     *
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     * @experimental
     */
    static icmpTypeAndCode(type, code) {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: type,
            toPort: code,
            stringRepresentation: `ICMP Type ${type} Code ${code}`,
        });
    }
    /**
     * (experimental) All codes for a single ICMP type.
     *
     * @experimental
     */
    static icmpType(type) {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: type,
            toPort: -1,
            stringRepresentation: `ICMP Type ${type}`,
        });
    }
    /**
     * (experimental) ICMP ping (echo) traffic.
     *
     * @experimental
     */
    static icmpPing() {
        return Port.icmpType(8);
    }
    /**
     * (experimental) All ICMP traffic.
     *
     * @experimental
     */
    static allIcmp() {
        return new Port({
            protocol: Protocol.ICMP,
            fromPort: -1,
            toPort: -1,
            stringRepresentation: 'ALL ICMP',
        });
    }
    /**
     * (experimental) All traffic.
     *
     * @experimental
     */
    static allTraffic() {
        return new Port({
            protocol: Protocol.ALL,
            stringRepresentation: 'ALL TRAFFIC',
        });
    }
    /**
     * (experimental) A single ESP port.
     *
     * @experimental
     */
    static esp() {
        return new Port({
            protocol: Protocol.ESP,
            fromPort: 50,
            toPort: 50,
            stringRepresentation: 'ESP 50',
        });
    }
    /**
     * (experimental) A single AH port.
     *
     * @experimental
     */
    static ah() {
        return new Port({
            protocol: Protocol.AH,
            fromPort: 51,
            toPort: 51,
            stringRepresentation: 'AH 51',
        });
    }
    /**
     * (experimental) Produce the ingress/egress rule JSON for the given connection.
     *
     * @experimental
     */
    toRuleJson() {
        return {
            ipProtocol: this.props.protocol,
            fromPort: this.props.fromPort,
            toPort: this.props.toPort,
        };
    }
    /**
     * @experimental
     */
    toString() {
        return this.props.stringRepresentation;
    }
}
exports.Port = Port;
_a = JSII_RTTI_SYMBOL_1;
Port[_a] = { fqn: "monocdk.aws_ec2.Port", version: "1.106.1" };
function renderPort(port) {
    return core_1.Token.isUnresolved(port) ? '{IndirectPort}' : port.toString();
}
//# sourceMappingURL=data:application/json;base64,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