/**
 * (experimental) Protocol for use in Connection Rules.
 *
 * https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
 *
 * @experimental
 */
export declare enum Protocol {
    /**
     * @experimental
     */
    ALL = "-1",
    /**
     * @experimental
     */
    HOPOPT = "0",
    /**
     * @experimental
     */
    ICMP = "icmp",
    /**
     * @experimental
     */
    IGMP = "2",
    /**
     * @experimental
     */
    GGP = "3",
    /**
     * @experimental
     */
    IPV4 = "4",
    /**
     * @experimental
     */
    ST = "5",
    /**
     * @experimental
     */
    TCP = "tcp",
    /**
     * @experimental
     */
    CBT = "7",
    /**
     * @experimental
     */
    EGP = "8",
    /**
     * @experimental
     */
    IGP = "9",
    /**
     * @experimental
     */
    BBN_RCC_MON = "10",
    /**
     * @experimental
     */
    NVP_II = "11",
    /**
     * @experimental
     */
    PUP = "12",
    /**
     * @experimental
     */
    EMCON = "14",
    /**
     * @experimental
     */
    XNET = "15",
    /**
     * @experimental
     */
    CHAOS = "16",
    /**
     * @experimental
     */
    UDP = "udp",
    /**
     * @experimental
     */
    MUX = "18",
    /**
     * @experimental
     */
    DCN_MEAS = "19",
    /**
     * @experimental
     */
    HMP = "20",
    /**
     * @experimental
     */
    PRM = "21",
    /**
     * @experimental
     */
    XNS_IDP = "22",
    /**
     * @experimental
     */
    TRUNK_1 = "23",
    /**
     * @experimental
     */
    TRUNK_2 = "24",
    /**
     * @experimental
     */
    LEAF_1 = "25",
    /**
     * @experimental
     */
    LEAF_2 = "26",
    /**
     * @experimental
     */
    RDP = "27",
    /**
     * @experimental
     */
    IRTP = "28",
    /**
     * @experimental
     */
    ISO_TP4 = "29",
    /**
     * @experimental
     */
    NETBLT = "30",
    /**
     * @experimental
     */
    MFE_NSP = "31",
    /**
     * @experimental
     */
    MERIT_INP = "32",
    /**
     * @experimental
     */
    DCCP = "33",
    /**
     * @experimental
     */
    THREEPC = "34",
    /**
     * @experimental
     */
    IDPR = "35",
    /**
     * @experimental
     */
    XTP = "36",
    /**
     * @experimental
     */
    DDP = "37",
    /**
     * @experimental
     */
    IDPR_CMTP = "38",
    /**
     * @experimental
     */
    TPPLUSPLUS = "39",
    /**
     * @experimental
     */
    IL = "40",
    /**
     * @experimental
     */
    IPV6 = "41",
    /**
     * @experimental
     */
    SDRP = "42",
    /**
     * @experimental
     */
    IPV6_ROUTE = "43",
    /**
     * @experimental
     */
    IPV6_FRAG = "44",
    /**
     * @experimental
     */
    IDRP = "45",
    /**
     * @experimental
     */
    RSVP = "46",
    /**
     * @experimental
     */
    GRE = "47",
    /**
     * @experimental
     */
    DSR = "48",
    /**
     * @experimental
     */
    BNA = "49",
    /**
     * @experimental
     */
    ESP = "50",
    /**
     * @experimental
     */
    AH = "51",
    /**
     * @experimental
     */
    I_NLSP = "52",
    /**
     * @experimental
     */
    SWIPE = "53",
    /**
     * @experimental
     */
    NARP = "54",
    /**
     * @experimental
     */
    MOBILE = "55",
    /**
     * @experimental
     */
    TLSP = "56",
    /**
     * @experimental
     */
    SKIP = "57",
    /**
     * @experimental
     */
    ICMPV6 = "icmpv6",
    /**
     * @experimental
     */
    IPV6_NONXT = "59",
    /**
     * @experimental
     */
    IPV6_OPTS = "60",
    /**
     * @experimental
     */
    CFTP = "62",
    /**
     * @experimental
     */
    ANY_LOCAL = "63",
    /**
     * @experimental
     */
    SAT_EXPAK = "64",
    /**
     * @experimental
     */
    KRYPTOLAN = "65",
    /**
     * @experimental
     */
    RVD = "66",
    /**
     * @experimental
     */
    IPPC = "67",
    /**
     * @experimental
     */
    ANY_DFS = "68",
    /**
     * @experimental
     */
    SAT_MON = "69",
    /**
     * @experimental
     */
    VISA = "70",
    /**
     * @experimental
     */
    IPCV = "71",
    /**
     * @experimental
     */
    CPNX = "72",
    /**
     * @experimental
     */
    CPHB = "73",
    /**
     * @experimental
     */
    WSN = "74",
    /**
     * @experimental
     */
    PVP = "75",
    /**
     * @experimental
     */
    BR_SAT_MON = "76",
    /**
     * @experimental
     */
    SUN_ND = "77",
    /**
     * @experimental
     */
    WB_MON = "78",
    /**
     * @experimental
     */
    WB_EXPAK = "79",
    /**
     * @experimental
     */
    ISO_IP = "80",
    /**
     * @experimental
     */
    VMTP = "81",
    /**
     * @experimental
     */
    SECURE_VMTP = "82",
    /**
     * @experimental
     */
    VINES = "83",
    /**
     * @experimental
     */
    TTP = "84",
    IPTM = "84",
    /**
     * @experimental
     */
    NSFNET_IGP = "85",
    /**
     * @experimental
     */
    DGP = "86",
    /**
     * @experimental
     */
    TCF = "87",
    /**
     * @experimental
     */
    EIGRP = "88",
    /**
     * @experimental
     */
    OSPFIGP = "89",
    /**
     * @experimental
     */
    SPRITE_RPC = "90",
    /**
     * @experimental
     */
    LARP = "91",
    /**
     * @experimental
     */
    MTP = "92",
    /**
     * @experimental
     */
    AX_25 = "93",
    /**
     * @experimental
     */
    IPIP = "94",
    /**
     * @experimental
     */
    MICP = "95",
    /**
     * @experimental
     */
    SCC_SP = "96",
    /**
     * @experimental
     */
    ETHERIP = "97",
    /**
     * @experimental
     */
    ENCAP = "98",
    /**
     * @experimental
     */
    ANY_ENC = "99",
    /**
     * @experimental
     */
    GMTP = "100",
    /**
     * @experimental
     */
    IFMP = "101",
    /**
     * @experimental
     */
    PNNI = "102",
    /**
     * @experimental
     */
    PIM = "103",
    /**
     * @experimental
     */
    ARIS = "104",
    /**
     * @experimental
     */
    SCPS = "105",
    /**
     * @experimental
     */
    QNX = "106",
    /**
     * @experimental
     */
    A_N = "107",
    /**
     * @experimental
     */
    IPCOMP = "108",
    /**
     * @experimental
     */
    SNP = "109",
    /**
     * @experimental
     */
    COMPAQ_PEER = "110",
    /**
     * @experimental
     */
    IPX_IN_IP = "111",
    /**
     * @experimental
     */
    VRRP = "112",
    /**
     * @experimental
     */
    PGM = "113",
    /**
     * @experimental
     */
    ANY_0_HOP = "114",
    /**
     * @experimental
     */
    L2_T_P = "115",
    /**
     * @experimental
     */
    DDX = "116",
    /**
     * @experimental
     */
    IATP = "117",
    /**
     * @experimental
     */
    STP = "118",
    /**
     * @experimental
     */
    SRP = "119",
    /**
     * @experimental
     */
    UTI = "120",
    /**
     * @experimental
     */
    SMP = "121",
    /**
     * @experimental
     */
    SM = "122",
    /**
     * @experimental
     */
    PTP = "123",
    /**
     * @experimental
     */
    ISIS_IPV4 = "124",
    /**
     * @experimental
     */
    FIRE = "125",
    /**
     * @experimental
     */
    CRTP = "126",
    /**
     * @experimental
     */
    CRUDP = "127",
    /**
     * @experimental
     */
    SSCOPMCE = "128",
    /**
     * @experimental
     */
    IPLT = "129",
    /**
     * @experimental
     */
    SPS = "130",
    /**
     * @experimental
     */
    PIPE = "131",
    /**
     * @experimental
     */
    SCTP = "132",
    /**
     * @experimental
     */
    FC = "133",
    /**
     * @experimental
     */
    RSVP_E2E_IGNORE = "134",
    /**
     * @experimental
     */
    MOBILITY_HEADER = "135",
    /**
     * @experimental
     */
    UDPLITE = "136",
    /**
     * @experimental
     */
    MPLS_IN_IP = "137",
    /**
     * @experimental
     */
    MANET = "138",
    /**
     * @experimental
     */
    HIP = "139",
    /**
     * @experimental
     */
    SHIM6 = "140",
    /**
     * @experimental
     */
    WESP = "141",
    /**
     * @experimental
     */
    ROHC = "142",
    /**
     * @experimental
     */
    ETHERNET = "143",
    /**
     * @experimental
     */
    EXPERIMENT_1 = "253",
    /**
     * @experimental
     */
    EXPERIMENT_2 = "254",
    /**
     * @experimental
     */
    RESERVED = "255"
}
/**
 * (experimental) Properties to create a port range.
 *
 * @experimental
 */
export interface PortProps {
    /**
     * (experimental) The protocol for the range.
     *
     * @experimental
     */
    readonly protocol: Protocol;
    /**
     * (experimental) The starting port for the range.
     *
     * @default - Not included in the rule
     * @experimental
     */
    readonly fromPort?: number;
    /**
     * (experimental) The ending port for the range.
     *
     * @default - Not included in the rule
     * @experimental
     */
    readonly toPort?: number;
    /**
     * (experimental) String representation for this object.
     *
     * @experimental
     */
    readonly stringRepresentation: string;
}
/**
 * (experimental) Interface for classes that provide the connection-specification parts of a security group rule.
 *
 * @experimental
 */
export declare class Port {
    private readonly props;
    /**
     * (experimental) A single TCP port.
     *
     * @experimental
     */
    static tcp(port: number): Port;
    /**
     * (experimental) A TCP port range.
     *
     * @experimental
     */
    static tcpRange(startPort: number, endPort: number): Port;
    /**
     * (experimental) Any TCP traffic.
     *
     * @experimental
     */
    static allTcp(): Port;
    /**
     * (experimental) A single UDP port.
     *
     * @experimental
     */
    static udp(port: number): Port;
    /**
     * (experimental) A UDP port range.
     *
     * @experimental
     */
    static udpRange(startPort: number, endPort: number): Port;
    /**
     * (experimental) Any UDP traffic.
     *
     * @experimental
     */
    static allUdp(): Port;
    /**
     * (experimental) A specific combination of ICMP type and code.
     *
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     * @experimental
     */
    static icmpTypeAndCode(type: number, code: number): Port;
    /**
     * (experimental) All codes for a single ICMP type.
     *
     * @experimental
     */
    static icmpType(type: number): Port;
    /**
     * (experimental) ICMP ping (echo) traffic.
     *
     * @experimental
     */
    static icmpPing(): Port;
    /**
     * (experimental) All ICMP traffic.
     *
     * @experimental
     */
    static allIcmp(): Port;
    /**
     * (experimental) All traffic.
     *
     * @experimental
     */
    static allTraffic(): Port;
    /**
     * (experimental) A single ESP port.
     *
     * @experimental
     */
    static esp(): Port;
    /**
     * (experimental) A single AH port.
     *
     * @experimental
     */
    static ah(): Port;
    /**
     * (experimental) Whether the rule containing this port range can be inlined into a securitygroup or not.
     *
     * @experimental
     */
    readonly canInlineRule: boolean;
    /**
     * @experimental
     */
    constructor(props: PortProps);
    /**
     * (experimental) Produce the ingress/egress rule JSON for the given connection.
     *
     * @experimental
     */
    toRuleJson(): any;
    /**
     * @experimental
     */
    toString(): string;
}
