import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { AclCidr, AclTraffic } from './network-acl-types';
import { ISubnet, IVpc, SubnetSelection } from './vpc';
/**
 * (experimental) A NetworkAcl.
 *
 * @experimental
 */
export interface INetworkAcl extends IResource {
    /**
     * (experimental) ID for the current Network ACL.
     *
     * @experimental
     * @attribute true
     */
    readonly networkAclId: string;
    /**
     * (experimental) Add a new entry to the ACL.
     *
     * @experimental
     */
    addEntry(id: string, options: CommonNetworkAclEntryOptions): NetworkAclEntry;
}
/**
 * A NetworkAclBase that is not created in this template
 *
 *
 */
declare abstract class NetworkAclBase extends Resource implements INetworkAcl {
    abstract readonly networkAclId: string;
    /**
     * (experimental) Add a new entry to the ACL.
     *
     * @experimental
     */
    addEntry(id: string, options: CommonNetworkAclEntryOptions): NetworkAclEntry;
}
/**
 * (experimental) Properties to create NetworkAcl.
 *
 * @experimental
 */
export interface NetworkAclProps {
    /**
     * (experimental) The name of the NetworkAcl.
     *
     * It is not recommended to use an explicit name.
     *
     * @default If you don't specify a networkAclName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * @experimental
     */
    readonly networkAclName?: string;
    /**
     * (experimental) The VPC in which to create the NetworkACL.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * (experimental) Subnets in the given VPC to associate the ACL with.
     *
     * More subnets can always be added later by calling
     * `associateWithSubnets()`.
     *
     * @default - No subnets associated
     * @experimental
     */
    readonly subnetSelection?: SubnetSelection;
}
/**
 * (experimental) Define a new custom network ACL.
 *
 * By default, will deny all inbound and outbound traffic unless entries are
 * added explicitly allowing it.
 *
 * @experimental
 */
export declare class NetworkAcl extends NetworkAclBase {
    /**
     * (experimental) Import an existing NetworkAcl into this app.
     *
     * @experimental
     */
    static fromNetworkAclId(scope: Construct, id: string, networkAclId: string): INetworkAcl;
    /**
     * (experimental) The ID of the NetworkACL.
     *
     * @experimental
     * @attribute true
     */
    readonly networkAclId: string;
    /**
     * (experimental) The VPC ID for this NetworkACL.
     *
     * @experimental
     * @attribute true
     */
    readonly networkAclVpcId: string;
    private readonly networkAcl;
    private readonly vpc;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NetworkAclProps);
    /**
     * (experimental) Associate the ACL with a given set of subnets.
     *
     * @experimental
     */
    associateWithSubnet(id: string, selection: SubnetSelection): void;
}
/**
 * (experimental) What action to apply to traffic matching the ACL.
 *
 * @experimental
 */
export declare enum Action {
    /**
     * (experimental) Allow the traffic.
     *
     * @experimental
     */
    ALLOW = "allow",
    /**
     * (experimental) Deny the traffic.
     *
     * @experimental
     */
    DENY = "deny"
}
/**
 * (experimental) A NetworkAclEntry.
 *
 * @experimental
 */
export interface INetworkAclEntry extends IResource {
    /**
     * (experimental) The network ACL.
     *
     * @experimental
     */
    readonly networkAcl: INetworkAcl;
}
/**
 * Base class for NetworkAclEntries
 *
 *
 */
declare abstract class NetworkAclEntryBase extends Resource implements INetworkAclEntry {
    abstract readonly networkAcl: INetworkAcl;
}
/**
 * (experimental) Direction of traffic the AclEntry applies to.
 *
 * @experimental
 */
export declare enum TrafficDirection {
    /**
     * (experimental) Traffic leaving the subnet.
     *
     * @experimental
     */
    EGRESS = 0,
    /**
     * (experimental) Traffic entering the subnet.
     *
     * @experimental
     */
    INGRESS = 1
}
/**
 * (experimental) Basic NetworkACL entry props.
 *
 * @experimental
 */
export interface CommonNetworkAclEntryOptions {
    /**
     * (experimental) The name of the NetworkAclEntry.
     *
     * It is not recommended to use an explicit group name.
     *
     * @default If you don't specify a NetworkAclName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * @experimental
     */
    readonly networkAclEntryName?: string;
    /**
     * (experimental) The CIDR range to allow or deny.
     *
     * @experimental
     */
    readonly cidr: AclCidr;
    /**
     * (experimental) What kind of traffic this ACL rule applies to.
     *
     * @experimental
     */
    readonly traffic: AclTraffic;
    /**
     * (experimental) Traffic direction, with respect to the subnet, this rule applies to.
     *
     * @default TrafficDirection.INGRESS
     * @experimental
     */
    readonly direction?: TrafficDirection;
    /**
     * (experimental) Whether to allow or deny traffic that matches the rule; valid values are "allow" or "deny".
     *
     * Any traffic that is not explicitly allowed is automatically denied in a custom
     * ACL, all traffic is automatically allowed in a default ACL.
     *
     * @default ALLOW
     * @experimental
     */
    readonly ruleAction?: Action;
    /**
     * (experimental) Rule number to assign to the entry, such as 100.
     *
     * ACL entries are processed in ascending order by rule number.
     * Entries can't use the same rule number unless one is an egress rule and the other is an ingress rule.
     *
     * @experimental
     */
    readonly ruleNumber: number;
}
/**
 * (experimental) Properties to create NetworkAclEntry.
 *
 * @experimental
 */
export interface NetworkAclEntryProps extends CommonNetworkAclEntryOptions {
    /**
     * (experimental) The network ACL this entry applies to.
     *
     * @experimental
     */
    readonly networkAcl: INetworkAcl;
}
/**
 * (experimental) Define an entry in a Network ACL table.
 *
 * @experimental
 */
export declare class NetworkAclEntry extends NetworkAclEntryBase {
    /**
     * (experimental) The network ACL.
     *
     * @experimental
     */
    readonly networkAcl: INetworkAcl;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NetworkAclEntryProps);
}
/**
 * (experimental) A SubnetNetworkAclAssociation.
 *
 * @experimental
 */
export interface ISubnetNetworkAclAssociation extends IResource {
    /**
     * (experimental) ID for the current SubnetNetworkAclAssociation.
     *
     * @experimental
     * @attribute true
     */
    readonly subnetNetworkAclAssociationAssociationId: string;
}
/**
 * (experimental) Properties to create a SubnetNetworkAclAssociation.
 *
 * @experimental
 */
export interface SubnetNetworkAclAssociationProps {
    /**
     * (experimental) The name of the SubnetNetworkAclAssociation.
     *
     * It is not recommended to use an explicit name.
     *
     * @default If you don't specify a SubnetNetworkAclAssociationName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * @experimental
     */
    readonly subnetNetworkAclAssociationName?: string;
    /**
     * (experimental) The Network ACL this association is defined for.
     *
     * @experimental
     * @attribute true
     */
    readonly networkAcl: INetworkAcl;
    /**
     * (experimental) ID of the Subnet.
     *
     * @experimental
     * @attribute true
     */
    readonly subnet: ISubnet;
}
/**
 * Associate a network ACL with a subnet
 *
 *
 */
declare abstract class SubnetNetworkAclAssociationBase extends Resource implements ISubnetNetworkAclAssociation {
    abstract readonly subnetNetworkAclAssociationAssociationId: string;
}
/**
 * @experimental
 */
export declare class SubnetNetworkAclAssociation extends SubnetNetworkAclAssociationBase {
    /**
     * @experimental
     */
    static fromSubnetNetworkAclAssociationAssociationId(scope: Construct, id: string, subnetNetworkAclAssociationAssociationId: string): ISubnetNetworkAclAssociation;
    /**
     * (experimental) ID for the current SubnetNetworkAclAssociation.
     *
     * @experimental
     * @attribute true
     */
    readonly subnetNetworkAclAssociationAssociationId: string;
    /**
     * (experimental) ID for the current Network ACL.
     *
     * @experimental
     * @attribute true
     */
    readonly networkAcl: INetworkAcl;
    /**
     * (experimental) ID of the Subnet.
     *
     * @experimental
     * @attribute true
     */
    readonly subnet: ISubnet;
    private association;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SubnetNetworkAclAssociationProps);
}
export {};
