import { Connections, IConnectable } from './connections';
import { InstanceType } from './instance-types';
import { IMachineImage, LookupMachineImage } from './machine-image';
import { ISecurityGroup } from './security-group';
import { PrivateSubnet, PublicSubnet, Vpc } from './vpc';
/**
 * (experimental) Direction of traffic to allow all by default.
 *
 * @experimental
 */
export declare enum NatTrafficDirection {
    /**
     * (experimental) Allow all outbound traffic and disallow all inbound traffic.
     *
     * @experimental
     */
    OUTBOUND_ONLY = "OUTBOUND_ONLY",
    /**
     * (experimental) Allow all outbound and inbound traffic.
     *
     * @experimental
     */
    INBOUND_AND_OUTBOUND = "INBOUND_AND_OUTBOUND",
    /**
     * (experimental) Disallow all outbound and inbound traffic.
     *
     * @experimental
     */
    NONE = "NONE"
}
/**
 * (experimental) Pair represents a gateway created by NAT Provider.
 *
 * @experimental
 */
export interface GatewayConfig {
    /**
     * (experimental) Availability Zone.
     *
     * @experimental
     */
    readonly az: string;
    /**
     * (experimental) Identity of gateway spawned by the provider.
     *
     * @experimental
     */
    readonly gatewayId: string;
}
/**
 * (experimental) NAT providers.
 *
 * Determines what type of NAT provider to create, either NAT gateways or NAT
 * instance.
 *
 * @experimental
 */
export declare abstract class NatProvider {
    /**
     * (experimental) Use NAT Gateways to provide NAT services for your VPC.
     *
     * NAT gateways are managed by AWS.
     *
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
     * @experimental
     */
    static gateway(props?: NatGatewayProps): NatProvider;
    /**
     * (experimental) Use NAT instances to provide NAT services for your VPC.
     *
     * NAT instances are managed by you, but in return allow more configuration.
     *
     * Be aware that instances created using this provider will not be
     * automatically replaced if they are stopped for any reason. You should implement
     * your own NatProvider based on AutoScaling groups if you need that.
     *
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html
     * @experimental
     */
    static instance(props: NatInstanceProps): NatInstanceProvider;
    /**
     * (experimental) Return list of gateways spawned by the provider.
     *
     * @experimental
     */
    abstract readonly configuredGateways: GatewayConfig[];
    /**
     * (experimental) Called by the VPC to configure NAT.
     *
     * Don't call this directly, the VPC will call it automatically.
     *
     * @experimental
     */
    abstract configureNat(options: ConfigureNatOptions): void;
    /**
     * (experimental) Configures subnet with the gateway.
     *
     * Don't call this directly, the VPC will call it automatically.
     *
     * @experimental
     */
    abstract configureSubnet(subnet: PrivateSubnet): void;
}
/**
 * (experimental) Options passed by the VPC when NAT needs to be configured.
 *
 * @experimental
 */
export interface ConfigureNatOptions {
    /**
     * (experimental) The VPC we're configuring NAT for.
     *
     * @experimental
     */
    readonly vpc: Vpc;
    /**
     * (experimental) The public subnets where the NAT providers need to be placed.
     *
     * @experimental
     */
    readonly natSubnets: PublicSubnet[];
    /**
     * (experimental) The private subnets that need to route through the NAT providers.
     *
     * There may be more private subnets than public subnets with NAT providers.
     *
     * @experimental
     */
    readonly privateSubnets: PrivateSubnet[];
}
/**
 * (experimental) Properties for a NAT gateway.
 *
 * @experimental
 */
export interface NatGatewayProps {
    /**
     * (experimental) EIP allocation IDs for the NAT gateways.
     *
     * @default - No fixed EIPs allocated for the NAT gateways
     * @experimental
     */
    readonly eipAllocationIds?: string[];
}
/**
 * (experimental) Properties for a NAT instance.
 *
 * @experimental
 */
export interface NatInstanceProps {
    /**
     * (experimental) The machine image (AMI) to use.
     *
     * By default, will do an AMI lookup for the latest NAT instance image.
     *
     * If you have a specific AMI ID you want to use, pass a `GenericLinuxImage`. For example:
     *
     * ```ts
     * ec2.NatProvider.instance({
     *    instanceType: new ec2.InstanceType('t3.micro'),
     *    machineImage: new ec2.GenericLinuxImage({
     *      'us-east-2': 'ami-0f9c61b5a562a16af'
     *    })
     * })
     * ```
     *
     * @default - Latest NAT instance image
     * @experimental
     */
    readonly machineImage?: IMachineImage;
    /**
     * (experimental) Instance type of the NAT instance.
     *
     * @experimental
     */
    readonly instanceType: InstanceType;
    /**
     * (experimental) Name of SSH keypair to grant access to instance.
     *
     * @default - No SSH access will be possible.
     * @experimental
     */
    readonly keyName?: string;
    /**
     * (experimental) Security Group for NAT instances.
     *
     * @default - A new security group will be created
     * @experimental
     */
    readonly securityGroup?: ISecurityGroup;
    /**
     * (deprecated) Allow all inbound traffic through the NAT instance.
     *
     * If you set this to false, you must configure the NAT instance's security
     * groups in another way, either by passing in a fully configured Security
     * Group using the `securityGroup` property, or by configuring it using the
     * `.securityGroup` or `.connections` members after passing the NAT Instance
     * Provider to a Vpc.
     *
     * @default true
     * @deprecated - Use `defaultAllowedTraffic`.
     */
    readonly allowAllTraffic?: boolean;
    /**
     * (experimental) Direction to allow all traffic through the NAT instance by default.
     *
     * By default, inbound and outbound traffic is allowed.
     *
     * If you set this to another value than INBOUND_AND_OUTBOUND, you must
     * configure the NAT instance's security groups in another way, either by
     * passing in a fully configured Security Group using the `securityGroup`
     * property, or by configuring it using the `.securityGroup` or
     * `.connections` members after passing the NAT Instance Provider to a Vpc.
     *
     * @default NatTrafficDirection.INBOUND_AND_OUTBOUND
     * @experimental
     */
    readonly defaultAllowedTraffic?: NatTrafficDirection;
}
/**
 * (experimental) NAT provider which uses NAT Instances.
 *
 * @experimental
 */
export declare class NatInstanceProvider extends NatProvider implements IConnectable {
    private readonly props;
    private gateways;
    private _securityGroup?;
    private _connections?;
    /**
     * @experimental
     */
    constructor(props: NatInstanceProps);
    /**
     * (experimental) Called by the VPC to configure NAT.
     *
     * Don't call this directly, the VPC will call it automatically.
     *
     * @experimental
     */
    configureNat(options: ConfigureNatOptions): void;
    /**
     * (experimental) The Security Group associated with the NAT instances.
     *
     * @experimental
     */
    get securityGroup(): ISecurityGroup;
    /**
     * (experimental) Manage the Security Groups associated with the NAT instances.
     *
     * @experimental
     */
    get connections(): Connections;
    /**
     * (experimental) Return list of gateways spawned by the provider.
     *
     * @experimental
     */
    get configuredGateways(): GatewayConfig[];
    /**
     * (experimental) Configures subnet with the gateway.
     *
     * Don't call this directly, the VPC will call it automatically.
     *
     * @experimental
     */
    configureSubnet(subnet: PrivateSubnet): void;
}
/**
 * (experimental) Machine image representing the latest NAT instance image.
 *
 * @experimental
 */
export declare class NatInstanceImage extends LookupMachineImage {
    /**
     * @experimental
     */
    constructor();
}
