import * as iam from "../../aws-iam";
import { Duration, Expiration, IResource, Resource, TagManager } from "../../core";
import { Construct } from 'constructs';
import { Connections, IConnectable } from './connections';
import { InstanceType } from './instance-types';
import { IMachineImage, OperatingSystemType } from './machine-image';
import { ISecurityGroup } from './security-group';
import { UserData } from './user-data';
import { BlockDevice } from './volume';
/**
 * (experimental) Provides the options for specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-how-to.html
 * @experimental
 */
export declare enum CpuCredits {
    /**
     * (experimental) Standard bursting mode.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-standard-mode.html
     * @experimental
     */
    STANDARD = "standard",
    /**
     * (experimental) Unlimited bursting mode.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode.html
     * @experimental
     */
    UNLIMITED = "unlimited"
}
/**
 * (experimental) Provides the options for specifying the instance initiated shutdown behavior.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior
 * @experimental
 */
export declare enum InstanceInitiatedShutdownBehavior {
    /**
     * (experimental) The instance will stop when it initiates a shutdown.
     *
     * @experimental
     */
    STOP = "stop",
    /**
     * (experimental) The instance will be terminated when it initiates a shutdown.
     *
     * @experimental
     */
    TERMINATE = "terminate"
}
/**
 * (experimental) Interface for LaunchTemplate-like objects.
 *
 * @experimental
 */
export interface ILaunchTemplate extends IResource {
    /**
     * (experimental) The version number of this launch template to use.
     *
     * @experimental
     * @attribute true
     */
    readonly versionNumber: string;
    /**
     * (experimental) The identifier of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` will be set.
     *
     * @experimental
     * @attribute true
     */
    readonly launchTemplateId?: string;
    /**
     * (experimental) The name of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` will be set.
     *
     * @experimental
     * @attribute true
     */
    readonly launchTemplateName?: string;
}
/**
 * (experimental) Provides the options for the types of interruption for spot instances.
 *
 * @experimental
 */
export declare enum SpotInstanceInterruption {
    /**
     * (experimental) The instance will stop when interrupted.
     *
     * @experimental
     */
    STOP = "stop",
    /**
     * (experimental) The instance will be terminated when interrupted.
     *
     * @experimental
     */
    TERMINATE = "terminate",
    /**
     * (experimental) The instance will hibernate when interrupted.
     *
     * @experimental
     */
    HIBERNATE = "hibernate"
}
/**
 * (experimental) The Spot Instance request type.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html
 * @experimental
 */
export declare enum SpotRequestType {
    /**
     * (experimental) A one-time Spot Instance request remains active until Amazon EC2 launches the Spot Instance, the request expires, or you cancel the request.
     *
     * If the Spot price exceeds your maximum price
     * or capacity is not available, your Spot Instance is terminated and the Spot Instance request
     * is closed.
     *
     * @experimental
     */
    ONE_TIME = "one-time",
    /**
     * (experimental) A persistent Spot Instance request remains active until it expires or you cancel it, even if the request is fulfilled.
     *
     * If the Spot price exceeds your maximum price or capacity is not available,
     * your Spot Instance is interrupted. After your instance is interrupted, when your maximum price exceeds
     * the Spot price or capacity becomes available again, the Spot Instance is started if stopped or resumed
     * if hibernated.
     *
     * @experimental
     */
    PERSISTENT = "persistent"
}
/**
 * (experimental) Interface for the Spot market instance options provided in a LaunchTemplate.
 *
 * @experimental
 */
export interface LaunchTemplateSpotOptions {
    /**
     * (experimental) Spot Instances with a defined duration (also known as Spot blocks) are designed not to be interrupted and will run continuously for the duration you select.
     *
     * You can use a duration of 1, 2, 3, 4, 5, or 6 hours.
     *
     * @default Requested spot instances do not have a pre-defined duration.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#fixed-duration-spot-instances
     * @experimental
     */
    readonly blockDuration?: Duration;
    /**
     * (experimental) The behavior when a Spot Instance is interrupted.
     *
     * @default Spot instances will terminate when interrupted.
     * @experimental
     */
    readonly interruptionBehavior?: SpotInstanceInterruption;
    /**
     * (experimental) Maximum hourly price you're willing to pay for each Spot instance.
     *
     * The value is given
     * in dollars. ex: 0.01 for 1 cent per hour, or 0.001 for one-tenth of a cent per hour.
     *
     * @default Maximum hourly price will default to the on-demand price for the instance type.
     * @experimental
     */
    readonly maxPrice?: number;
    /**
     * (experimental) The Spot Instance request type.
     *
     * If you are using Spot Instances with an Auto Scaling group, use one-time requests, as the
     * Amazon EC2 Auto Scaling service handles requesting new Spot Instances whenever the group is
     * below its desired capacity.
     *
     * @default One-time spot request.
     * @experimental
     */
    readonly requestType?: SpotRequestType;
    /**
     * (experimental) The end date of the request.
     *
     * For a one-time request, the request remains active until all instances
     * launch, the request is canceled, or this date is reached. If the request is persistent, it remains
     * active until it is canceled or this date and time is reached.
     *
     * @default The default end date is 7 days from the current date.
     * @experimental
     */
    readonly validUntil?: Expiration;
}
/**
 * (experimental) Properties of a LaunchTemplate.
 *
 * @experimental
 */
export interface LaunchTemplateProps {
    /**
     * (experimental) Name for this launch template.
     *
     * @default Automatically generated name
     * @experimental
     */
    readonly launchTemplateName?: string;
    /**
     * (experimental) Type of instance to launch.
     *
     * @default - This Launch Template does not specify a default Instance Type.
     * @experimental
     */
    readonly instanceType?: InstanceType;
    /**
     * (experimental) The AMI that will be used by instances.
     *
     * @default - This Launch Template does not specify a default AMI.
     * @experimental
     */
    readonly machineImage?: IMachineImage;
    /**
     * (experimental) The AMI that will be used by instances.
     *
     * @default - This Launch Template creates a UserData based on the type of provided
     * machineImage; no UserData is created if a machineImage is not provided
     * @experimental
     */
    readonly userData?: UserData;
    /**
     * (experimental) An IAM role to associate with the instance profile that is used by instances.
     *
     * The role must be assumable by the service principal `ec2.amazonaws.com`:
     *
     * @default - No new role is created.
     * @experimental
     * @example
     *
     * const role = new iam.Role(this, 'MyRole', {
     *   assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com')
     * });
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     *
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     *
     * @default - Uses the block device mapping of the AMI
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
     * @experimental
     */
    readonly blockDevices?: BlockDevice[];
    /**
     * (experimental) CPU credit type for burstable EC2 instance types.
     *
     * @default - No credit type is specified in the Launch Template.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
     * @experimental
     */
    readonly cpuCredits?: CpuCredits;
    /**
     * (experimental) If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;
     *
     * otherwise, you can.
     *
     * @default - The API termination setting is not specified in the Launch Template.
     * @experimental
     */
    readonly disableApiTermination?: boolean;
    /**
     * (experimental) Indicates whether the instances are optimized for Amazon EBS I/O.
     *
     * This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
     * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     *
     * @default - EBS optimization is not specified in the launch template.
     * @experimental
     */
    readonly ebsOptimized?: boolean;
    /**
     * (experimental) If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;
     *
     * otherwise, it is not enabled for AWS Nitro Enclaves.
     *
     * @default - Enablement of Nitro enclaves is not specified in the launch template; defaulting to false.
     * @experimental
     */
    readonly nitroEnclaveEnabled?: boolean;
    /**
     * (experimental) If you set this parameter to true, the instance is enabled for hibernation.
     *
     * @default - Hibernation configuration is not specified in the launch template; defaulting to false.
     * @experimental
     */
    readonly hibernationConfigured?: boolean;
    /**
     * (experimental) Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     *
     * @default - Shutdown behavior is not specified in the launch template; defaults to STOP.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior
     * @experimental
     */
    readonly instanceInitiatedShutdownBehavior?: InstanceInitiatedShutdownBehavior;
    /**
     * (experimental) If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
     *
     * @default - Instance launched with this template will not be spot instances.
     * @experimental
     */
    readonly spotOptions?: LaunchTemplateSpotOptions;
    /**
     * (experimental) Name of SSH keypair to grant access to instance.
     *
     * @default - No SSH access will be possible.
     * @experimental
     */
    readonly keyName?: string;
    /**
     * (experimental) If set to true, then detailed monitoring will be enabled on instances created with this launch template.
     *
     * @default False - Detailed monitoring is disabled.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html
     * @experimental
     */
    readonly detailedMonitoring?: boolean;
    /**
     * (experimental) Security group to assign to instances created with the launch template.
     *
     * @default No security group is assigned.
     * @experimental
     */
    readonly securityGroup?: ISecurityGroup;
}
/**
 * (experimental) A class that provides convenient access to special version tokens for LaunchTemplate versions.
 *
 * @experimental
 */
export declare class LaunchTemplateSpecialVersions {
    /**
     * (experimental) The special value that denotes that users of a Launch Template should reference the LATEST version of the template.
     *
     * @experimental
     */
    static readonly LATEST_VERSION: string;
    /**
     * (experimental) The special value that denotes that users of a Launch Template should reference the DEFAULT version of the template.
     *
     * @experimental
     */
    static readonly DEFAULT_VERSION: string;
}
/**
 * (experimental) Attributes for an imported LaunchTemplate.
 *
 * @experimental
 */
export interface LaunchTemplateAttributes {
    /**
     * (experimental) The version number of this launch template to use.
     *
     * @default Version: "$Default"
     * @experimental
     */
    readonly versionNumber?: string;
    /**
     * (experimental) The identifier of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` may be set.
     *
     * @default None
     * @experimental
     */
    readonly launchTemplateId?: string;
    /**
     * (experimental) The name of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` may be set.
     *
     * @default None
     * @experimental
     */
    readonly launchTemplateName?: string;
}
/**
 * (experimental) This represents an EC2 LaunchTemplate.
 *
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
 * @experimental
 */
export declare class LaunchTemplate extends Resource implements ILaunchTemplate, iam.IGrantable, IConnectable {
    /**
     * (experimental) Import an existing LaunchTemplate.
     *
     * @experimental
     */
    static fromLaunchTemplateAttributes(scope: Construct, id: string, attrs: LaunchTemplateAttributes): ILaunchTemplate;
    /**
     * (experimental) The version number of this launch template to use.
     *
     * @experimental
     */
    readonly versionNumber: string;
    /**
     * (experimental) The identifier of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` will be set.
     *
     * @experimental
     */
    readonly launchTemplateId?: string;
    /**
     * (experimental) The name of the Launch Template.
     *
     * Exactly one of `launchTemplateId` and `launchTemplateName` will be set.
     *
     * @experimental
     */
    readonly launchTemplateName?: string;
    /**
     * (experimental) The default version for the launch template.
     *
     * @experimental
     * @attribute true
     */
    readonly defaultVersionNumber: string;
    /**
     * (experimental) The latest version of the launch template.
     *
     * @experimental
     * @attribute true
     */
    readonly latestVersionNumber: string;
    /**
     * (experimental) The type of OS the instance is running.
     *
     * @experimental
     * @attribute true
     */
    readonly osType?: OperatingSystemType;
    /**
     * (experimental) IAM Role assumed by instances that are launched from this template.
     *
     * @experimental
     * @attribute true
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) UserData executed by instances that are launched from this template.
     *
     * @experimental
     * @attribute true
     */
    readonly userData?: UserData;
    /**
     * Principal to grant permissions to.
     * @internal
     */
    protected readonly _grantPrincipal?: iam.IPrincipal;
    /**
     * Allows specifying security group connections for the instance.
     * @internal
     */
    protected readonly _connections?: Connections;
    /**
     * (experimental) TagManager for tagging support.
     *
     * @experimental
     */
    protected readonly tags: TagManager;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: LaunchTemplateProps);
    /**
     * (experimental) Allows specifying security group connections for the instance.
     *
     * @experimental
     * @note Only available if you provide a securityGroup when constructing the LaunchTemplate.
     */
    get connections(): Connections;
    /**
     * (experimental) Principal to grant permissions to.
     *
     * @experimental
     * @note Only available if you provide a role when constructing the LaunchTemplate.
     */
    get grantPrincipal(): iam.IPrincipal;
}
