"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VPNMetrics = exports.TransitGatewayMetrics = exports.NATGatewayMetrics = exports.EC2Metrics = exports.EBSMetrics = exports.EC2CapacityReservationsMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class EC2CapacityReservationsMetrics {
    static instanceUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'InstanceUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static usedInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'UsedInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static availableInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'AvailableInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static totalInstanceCountAverage(dimensions) {
        return {
            namespace: 'AWS/EC2CapacityReservations',
            metricName: 'TotalInstanceCount',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EC2CapacityReservationsMetrics = EC2CapacityReservationsMetrics;
class EBSMetrics {
    static volumeReadBytesSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeReadBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeWriteBytesSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeWriteBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeReadOpsSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeReadOps',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeTotalReadTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeTotalReadTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeWriteOpsSum(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeWriteOps',
            dimensions,
            statistic: 'Sum',
        };
    }
    static volumeTotalWriteTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeTotalWriteTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeIdleTimeAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeIdleTime',
            dimensions,
            statistic: 'Average',
        };
    }
    static volumeQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'VolumeQueueLength',
            dimensions,
            statistic: 'Average',
        };
    }
    static burstBalanceAverage(dimensions) {
        return {
            namespace: 'AWS/EBS',
            metricName: 'BurstBalance',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EBSMetrics = EBSMetrics;
class EC2Metrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static statusCheckFailedSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed',
            dimensions,
            statistic: 'Sum',
        };
    }
    static statusCheckFailedInstanceSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed_Instance',
            dimensions,
            statistic: 'Sum',
        };
    }
    static statusCheckFailedSystemSum(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'StatusCheckFailed_System',
            dimensions,
            statistic: 'Sum',
        };
    }
    static diskReadBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskReadBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskReadOpsAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskReadOps',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskWriteBytesAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskWriteBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static diskWriteOpsAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'DiskWriteOps',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkInAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkOutAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkOut',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkPacketsInAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkPacketsIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkPacketsOutAverage(dimensions) {
        return {
            namespace: 'AWS/EC2',
            metricName: 'NetworkPacketsOut',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.EC2Metrics = EC2Metrics;
class NATGatewayMetrics {
    static activeConnectionCountMaximum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ActiveConnectionCount',
            dimensions,
            statistic: 'Maximum',
        };
    }
    static packetsDropCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsDropCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesInFromDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesInFromDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesInFromSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesInFromSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutToDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesOutToDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutToSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'BytesOutToSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionAttemptCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ConnectionAttemptCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static connectionEstablishedCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ConnectionEstablishedCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static errorPortAllocationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'ErrorPortAllocation',
            dimensions,
            statistic: 'Sum',
        };
    }
    static idleTimeoutCountSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'IdleTimeoutCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInFromDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsInFromDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInFromSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsInFromSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutToDestinationSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsOutToDestination',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutToSourceSum(dimensions) {
        return {
            namespace: 'AWS/NATGateway',
            metricName: 'PacketsOutToSource',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NATGatewayMetrics = NATGatewayMetrics;
class TransitGatewayMetrics {
    static bytesInSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'BytesIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesOutSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'BytesOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetDropCountBlackholeSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketDropCountBlackhole',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetDropCountNoRouteSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketDropCountNoRoute',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsInSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketsIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static packetsOutSum(dimensions) {
        return {
            namespace: 'AWS/TransitGateway',
            metricName: 'PacketsOut',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.TransitGatewayMetrics = TransitGatewayMetrics;
class VPNMetrics {
    static tunnelDataInSum(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelDataIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tunnelStateAverage(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelState',
            dimensions,
            statistic: 'Average',
        };
    }
    static tunnelDataOutSum(dimensions) {
        return {
            namespace: 'AWS/VPN',
            metricName: 'TunnelDataOut',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.VPNMetrics = VPNMetrics;
//# sourceMappingURL=data:application/json;base64,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