"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnRoute = exports.ClientVpnRouteTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ec2_generated_1 = require("./ec2.generated");
/**
 * (experimental) Target for a client VPN route.
 *
 * @experimental
 */
class ClientVpnRouteTarget {
    /**
     * (experimental) Subnet.
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     *
     * @experimental
     */
    static subnet(subnet) {
        return { subnetId: subnet.subnetId };
    }
    /**
     * (experimental) Local network.
     *
     * @experimental
     */
    static local() {
        return { subnetId: 'local' };
    }
}
exports.ClientVpnRouteTarget = ClientVpnRouteTarget;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnRouteTarget[_a] = { fqn: "monocdk.aws_ec2.ClientVpnRouteTarget", version: "1.106.1" };
/**
 * (experimental) A client VPN route.
 *
 * @experimental
 */
class ClientVpnRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const route = new ec2_generated_1.CfnClientVpnRoute(this, 'Resource', {
            clientVpnEndpointId: props.clientVpnEndoint.endpointId,
            description: props.description,
            destinationCidrBlock: props.cidr,
            targetVpcSubnetId: props.target.subnetId,
        });
        // See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
        route.node.addDependency(props.clientVpnEndoint.targetNetworksAssociated);
    }
}
exports.ClientVpnRoute = ClientVpnRoute;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnRoute[_b] = { fqn: "monocdk.aws_ec2.ClientVpnRoute", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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