import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IClientVpnEndpoint } from './client-vpn-endpoint-types';
import { ISubnet } from './vpc';
/**
 * (experimental) Options for a ClientVpnRoute.
 *
 * @experimental
 */
export interface ClientVpnRouteOptions {
    /**
     * (experimental) The IPv4 address range, in CIDR notation, of the route destination.
     *
     * For example:
     *    - To add a route for Internet access, enter 0.0.0.0/0
     *    - To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     *    - To add a route for an on-premises network, enter the AWS Site-to-Site VPN
     *      connection's IPv4 CIDR range
     *    - To add a route for the local network, enter the client CIDR range
     *
     * @experimental
     */
    readonly cidr: string;
    /**
     * (experimental) A brief description of the authorization rule.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The target for the route.
     *
     * @experimental
     */
    readonly target: ClientVpnRouteTarget;
}
/**
 * (experimental) Target for a client VPN route.
 *
 * @experimental
 */
export declare abstract class ClientVpnRouteTarget {
    /**
     * (experimental) Subnet.
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     *
     * @experimental
     */
    static subnet(subnet: ISubnet): ClientVpnRouteTarget;
    /**
     * (experimental) Local network.
     *
     * @experimental
     */
    static local(): ClientVpnRouteTarget;
    /**
     * (experimental) The subnet ID.
     *
     * @experimental
     */
    abstract readonly subnetId: string;
}
/**
 * (experimental) Properties for a ClientVpnRoute.
 *
 * @experimental
 */
export interface ClientVpnRouteProps extends ClientVpnRouteOptions {
    /**
     * (experimental) The client VPN endpoint to which to add the route.
     *
     * @experimental
     */
    readonly clientVpnEndoint: IClientVpnEndpoint;
}
/**
 * (experimental) A client VPN route.
 *
 * @experimental
 */
export declare class ClientVpnRoute extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClientVpnRouteProps);
}
