"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnEndpoint = exports.ClientVpnUserBasedAuthentication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const logs = require("../../aws-logs"); // Automatically re-written from '@aws-cdk/aws-logs'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const client_vpn_authorization_rule_1 = require("./client-vpn-authorization-rule");
const client_vpn_route_1 = require("./client-vpn-route");
const connections_1 = require("./connections");
const ec2_generated_1 = require("./ec2.generated");
const network_util_1 = require("./network-util");
const security_group_1 = require("./security-group");
/**
 * (experimental) User-based authentication for a client VPN endpoint.
 *
 * @experimental
 */
class ClientVpnUserBasedAuthentication {
    /**
     * (experimental) Active Directory authentication.
     *
     * @experimental
     */
    static activeDirectory(directoryId) {
        return new ActiveDirectoryAuthentication(directoryId);
    }
    /**
     * (experimental) Federated authentication.
     *
     * @experimental
     */
    static federated(samlProvider, selfServiceSamlProvider) {
        return new FederatedAuthentication(samlProvider, selfServiceSamlProvider);
    }
}
exports.ClientVpnUserBasedAuthentication = ClientVpnUserBasedAuthentication;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnUserBasedAuthentication[_a] = { fqn: "monocdk.aws_ec2.ClientVpnUserBasedAuthentication", version: "1.106.1" };
/**
 * Active Directory authentication
 */
class ActiveDirectoryAuthentication extends ClientVpnUserBasedAuthentication {
    constructor(directoryId) {
        super();
        this.directoryId = directoryId;
    }
    render() {
        return {
            type: 'directory-service-authentication',
            activeDirectory: { directoryId: this.directoryId },
        };
    }
}
/**
 * Federated authentication
 */
class FederatedAuthentication extends ClientVpnUserBasedAuthentication {
    constructor(samlProvider, selfServiceSamlProvider) {
        super();
        this.samlProvider = samlProvider;
        this.selfServiceSamlProvider = selfServiceSamlProvider;
    }
    render() {
        var _c;
        return {
            type: 'federated-authentication',
            federatedAuthentication: {
                samlProviderArn: this.samlProvider.samlProviderArn,
                selfServiceSamlProviderArn: (_c = this.selfServiceSamlProvider) === null || _c === void 0 ? void 0 : _c.samlProviderArn,
            },
        };
    }
}
/**
 * (experimental) A client VPN connnection.
 *
 * @experimental
 */
class ClientVpnEndpoint extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h;
        super(scope, id);
        this._targetNetworksAssociated = new core_1.ConcreteDependable();
        if (!core_1.Token.isUnresolved(props.vpc.vpcCidrBlock)) {
            const clientCidr = new network_util_1.CidrBlock(props.cidr);
            const vpcCidr = new network_util_1.CidrBlock(props.vpc.vpcCidrBlock);
            if (vpcCidr.containsCidr(clientCidr)) {
                throw new Error('The client CIDR cannot overlap with the local CIDR of the VPC');
            }
        }
        if (props.dnsServers && props.dnsServers.length > 2) {
            throw new Error('A client VPN endpoint can have up to two DNS servers');
        }
        if (props.logging == false && (props.logGroup || props.logStream)) {
            throw new Error('Cannot specify `logGroup` or `logStream` when logging is disabled');
        }
        if (props.clientConnectionHandler
            && !core_1.Token.isUnresolved(props.clientConnectionHandler.functionName)
            && !props.clientConnectionHandler.functionName.startsWith('AWSClientVPN-')) {
            throw new Error('The name of the Lambda function must begin with the `AWSClientVPN-` prefix');
        }
        const logging = (_c = props.logging) !== null && _c !== void 0 ? _c : true;
        const logGroup = logging
            ? (_d = props.logGroup) !== null && _d !== void 0 ? _d : new logs.LogGroup(this, 'LogGroup') : undefined;
        const securityGroups = (_e = props.securityGroups) !== null && _e !== void 0 ? _e : [new security_group_1.SecurityGroup(this, 'SecurityGroup', {
                vpc: props.vpc,
            })];
        this.connections = new connections_1.Connections({ securityGroups });
        const endpoint = new ec2_generated_1.CfnClientVpnEndpoint(this, 'Resource', {
            authenticationOptions: renderAuthenticationOptions(props.clientCertificateArn, props.userBasedAuthentication),
            clientCidrBlock: props.cidr,
            clientConnectOptions: props.clientConnectionHandler
                ? {
                    enabled: true,
                    lambdaFunctionArn: props.clientConnectionHandler.functionArn,
                }
                : undefined,
            connectionLogOptions: {
                enabled: logging,
                cloudwatchLogGroup: logGroup === null || logGroup === void 0 ? void 0 : logGroup.logGroupName,
                cloudwatchLogStream: (_f = props.logStream) === null || _f === void 0 ? void 0 : _f.logStreamName,
            },
            description: props.description,
            dnsServers: props.dnsServers,
            securityGroupIds: securityGroups.map(s => s.securityGroupId),
            selfServicePortal: booleanToEnabledDisabled(props.selfServicePortal),
            serverCertificateArn: props.serverCertificateArn,
            splitTunnel: props.splitTunnel,
            transportProtocol: props.transportProtocol,
            vpcId: props.vpc.vpcId,
            vpnPort: props.port,
        });
        this.endpointId = endpoint.ref;
        if (props.userBasedAuthentication && ((_g = props.selfServicePortal) !== null && _g !== void 0 ? _g : true)) {
            // Output self-service portal URL
            new core_1.CfnOutput(this, 'SelfServicePortalUrl', {
                value: `https://self-service.clientvpn.amazonaws.com/endpoints/${this.endpointId}`,
            });
        }
        // Associate subnets
        const subnetIds = props.vpc.selectSubnets(props.vpcSubnets).subnetIds;
        if (core_1.Token.isUnresolved(subnetIds)) {
            throw new Error('Cannot associate subnets when VPC are imported from parameters or exports containing lists of subnet IDs.');
        }
        for (const [idx, subnetId] of Object.entries(subnetIds)) {
            this._targetNetworksAssociated.add(new ec2_generated_1.CfnClientVpnTargetNetworkAssociation(this, `Association${idx}`, {
                clientVpnEndpointId: this.endpointId,
                subnetId,
            }));
        }
        this.targetNetworksAssociated = this._targetNetworksAssociated;
        if ((_h = props.authorizeAllUsersToVpcCidr) !== null && _h !== void 0 ? _h : true) {
            this.addAuthorizationRule('AuthorizeAll', {
                cidr: props.vpc.vpcCidrBlock,
            });
        }
    }
    /**
     * (experimental) Import an existing client VPN endpoint.
     *
     * @experimental
     */
    static fromEndpointAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.endpointId = attrs.endpointId;
                this.connections = new connections_1.Connections({ securityGroups: attrs.securityGroups });
                this.targetNetworksAssociated = new core_1.ConcreteDependable();
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds an authorization rule to this endpoint.
     *
     * @experimental
     */
    addAuthorizationRule(id, props) {
        return new client_vpn_authorization_rule_1.ClientVpnAuthorizationRule(this, id, {
            ...props,
            clientVpnEndoint: this,
        });
    }
    /**
     * (experimental) Adds a route to this endpoint.
     *
     * @experimental
     */
    addRoute(id, props) {
        return new client_vpn_route_1.ClientVpnRoute(this, id, {
            ...props,
            clientVpnEndoint: this,
        });
    }
}
exports.ClientVpnEndpoint = ClientVpnEndpoint;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnEndpoint[_b] = { fqn: "monocdk.aws_ec2.ClientVpnEndpoint", version: "1.106.1" };
function renderAuthenticationOptions(clientCertificateArn, userBasedAuthentication) {
    const authenticationOptions = [];
    if (clientCertificateArn) {
        authenticationOptions.push({
            type: 'certificate-authentication',
            mutualAuthentication: {
                clientRootCertificateChainArn: clientCertificateArn,
            },
        });
    }
    if (userBasedAuthentication) {
        authenticationOptions.push(userBasedAuthentication.render());
    }
    if (authenticationOptions.length === 0) {
        throw new Error('A client VPN endpoint must use at least one authentication option');
    }
    return authenticationOptions;
}
function booleanToEnabledDisabled(val) {
    switch (val) {
        case undefined:
            return undefined;
        case true:
            return 'enabled';
        case false:
            return 'disabled';
    }
}
//# sourceMappingURL=data:application/json;base64,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