import { ISamlProvider } from "../../aws-iam";
import * as logs from "../../aws-logs";
import { IDependable, Resource } from "../../core";
import { Construct } from 'constructs';
import { ClientVpnAuthorizationRule, ClientVpnAuthorizationRuleOptions } from './client-vpn-authorization-rule';
import { IClientVpnConnectionHandler, IClientVpnEndpoint, TransportProtocol, VpnPort } from './client-vpn-endpoint-types';
import { ClientVpnRoute, ClientVpnRouteOptions } from './client-vpn-route';
import { Connections } from './connections';
import { ISecurityGroup } from './security-group';
import { IVpc, SubnetSelection } from './vpc';
/**
 * (experimental) Options for a client VPN endpoint.
 *
 * @experimental
 */
export interface ClientVpnEndpointOptions {
    /**
     * (experimental) The IPv4 address range, in CIDR notation, from which to assign client IP addresses.
     *
     * The address range cannot overlap with the local CIDR of the VPC
     * in which the associated subnet is located, or the routes that you add manually.
     *
     * Changing the address range will replace the Client VPN endpoint.
     *
     * The CIDR block should be /22 or greater.
     *
     * @experimental
     */
    readonly cidr: string;
    /**
     * (experimental) The ARN of the client certificate for mutual authentication.
     *
     * The certificate must be signed by a certificate authority (CA) and it must
     * be provisioned in AWS Certificate Manager (ACM).
     *
     * @default - use user-based authentication
     * @experimental
     */
    readonly clientCertificateArn?: string;
    /**
     * (experimental) The type of user-based authentication to use.
     *
     * @default - use mutual authentication
     * @see https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html
     * @experimental
     */
    readonly userBasedAuthentication?: ClientVpnUserBasedAuthentication;
    /**
     * (experimental) Whether to enable connections logging.
     *
     * @default true
     * @experimental
     */
    readonly logging?: boolean;
    /**
     * (experimental) A CloudWatch Logs log group for connection logging.
     *
     * @default - a new group is created
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * (experimental) A CloudWatch Logs log stream for connection logging.
     *
     * @default - a new stream is created
     * @experimental
     */
    readonly logStream?: logs.ILogStream;
    /**
     * (experimental) The AWS Lambda function used for connection authorization.
     *
     * The name of the Lambda function must begin with the `AWSClientVPN-` prefix
     *
     * @default - no connection handler
     * @experimental
     */
    readonly clientConnectionHandler?: IClientVpnConnectionHandler;
    /**
     * (experimental) A brief description of the Client VPN endpoint.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The security groups to apply to the target network.
     *
     * @default - a new security group is created
     * @experimental
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * (experimental) Specify whether to enable the self-service portal for the Client VPN endpoint.
     *
     * @default true
     * @experimental
     */
    readonly selfServicePortal?: boolean;
    /**
     * (experimental) The ARN of the server certificate.
     *
     * @experimental
     */
    readonly serverCertificateArn: string;
    /**
     * (experimental) Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
     *
     * @default false
     * @see https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
     * @experimental
     */
    readonly splitTunnel?: boolean;
    /**
     * (experimental) The transport protocol to be used by the VPN session.
     *
     * @default TransportProtocol.UDP
     * @experimental
     */
    readonly transportProtocol?: TransportProtocol;
    /**
     * (experimental) The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     *
     * @default VpnPort.HTTPS
     * @experimental
     */
    readonly port?: VpnPort;
    /**
     * (experimental) Information about the DNS servers to be used for DNS resolution.
     *
     * A Client VPN endpoint can have up to two DNS servers.
     *
     * @default - use the DNS address configured on the device
     * @experimental
     */
    readonly dnsServers?: string[];
    /**
     * (experimental) Subnets to associate to the client VPN endpoint.
     *
     * @default - the VPC default strategy
     * @experimental
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * (experimental) Whether to authorize all users to the VPC CIDR.
     *
     * This automatically creates an authorization rule. Set this to `false` and
     * use `addAuthorizationRule()` to create your own rules instead.
     *
     * @default true
     * @experimental
     */
    readonly authorizeAllUsersToVpcCidr?: boolean;
}
/**
 * (experimental) User-based authentication for a client VPN endpoint.
 *
 * @experimental
 */
export declare abstract class ClientVpnUserBasedAuthentication {
    /**
     * (experimental) Active Directory authentication.
     *
     * @experimental
     */
    static activeDirectory(directoryId: string): ClientVpnUserBasedAuthentication;
    /**
     * (experimental) Federated authentication.
     *
     * @experimental
     */
    static federated(samlProvider: ISamlProvider, selfServiceSamlProvider?: ISamlProvider): ClientVpnUserBasedAuthentication;
    /**
     * (experimental) Renders the user based authentication.
     *
     * @experimental
     */
    abstract render(): any;
}
/**
 * (experimental) Properties for a client VPN endpoint.
 *
 * @experimental
 */
export interface ClientVpnEndpointProps extends ClientVpnEndpointOptions {
    /**
     * (experimental) The VPC to connect to.
     *
     * @experimental
     */
    readonly vpc: IVpc;
}
/**
 * (experimental) Attributes when importing an existing client VPN endpoint.
 *
 * @experimental
 */
export interface ClientVpnEndpointAttributes {
    /**
     * (experimental) The endpoint ID.
     *
     * @experimental
     */
    readonly endpointId: string;
    /**
     * (experimental) The security groups associated with the endpoint.
     *
     * @experimental
     */
    readonly securityGroups: ISecurityGroup[];
}
/**
 * (experimental) A client VPN connnection.
 *
 * @experimental
 */
export declare class ClientVpnEndpoint extends Resource implements IClientVpnEndpoint {
    /**
     * (experimental) Import an existing client VPN endpoint.
     *
     * @experimental
     */
    static fromEndpointAttributes(scope: Construct, id: string, attrs: ClientVpnEndpointAttributes): IClientVpnEndpoint;
    /**
     * (experimental) The endpoint ID.
     *
     * @experimental
     */
    readonly endpointId: string;
    /**
     * (experimental) Allows specify security group connections for the endpoint.
     *
     * @experimental
     */
    readonly connections: Connections;
    /**
     * (experimental) Dependable that can be depended upon to force target networks associations.
     *
     * @experimental
     */
    readonly targetNetworksAssociated: IDependable;
    private readonly _targetNetworksAssociated;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClientVpnEndpointProps);
    /**
     * (experimental) Adds an authorization rule to this endpoint.
     *
     * @experimental
     */
    addAuthorizationRule(id: string, props: ClientVpnAuthorizationRuleOptions): ClientVpnAuthorizationRule;
    /**
     * (experimental) Adds a route to this endpoint.
     *
     * @experimental
     */
    addRoute(id: string, props: ClientVpnRouteOptions): ClientVpnRoute;
}
