import { IDependable, IResource } from "../../core";
import { IConnectable } from './connections';
/**
 * (experimental) A client VPN endpoint.
 *
 * @experimental
 */
export interface IClientVpnEndpoint extends IResource, IConnectable {
    /**
     * (experimental) The endpoint ID.
     *
     * @experimental
     */
    readonly endpointId: string;
    /**
     * (experimental) Dependable that can be depended upon to force target networks associations.
     *
     * @experimental
     */
    readonly targetNetworksAssociated: IDependable;
}
/**
 * (experimental) A connection handler for client VPN endpoints.
 *
 * @experimental
 */
export interface IClientVpnConnectionHandler {
    /**
     * (experimental) The name of the function.
     *
     * @experimental
     */
    readonly functionName: string;
    /**
     * (experimental) The ARN of the function.
     *
     * @experimental
     */
    readonly functionArn: string;
}
/**
 * (experimental) Transport protocol for client VPN.
 *
 * @experimental
 */
export declare enum TransportProtocol {
    /**
     * (experimental) Transmission Control Protocol (TCP).
     *
     * @experimental
     */
    TCP = "tcp",
    /**
     * (experimental) User Datagram Protocol (UDP).
     *
     * @experimental
     */
    UDP = "udp"
}
/**
 * (experimental) Port for client VPN.
 *
 * @experimental
 */
export declare enum VpnPort {
    /**
     * (experimental) HTTPS.
     *
     * @experimental
     */
    HTTPS = 443,
    /**
     * (experimental) OpenVPN.
     *
     * @experimental
     */
    OPENVPN = 1194
}
