import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IClientVpnEndpoint } from './client-vpn-endpoint-types';
/**
 * (experimental) Options for a ClientVpnAuthorizationRule.
 *
 * @experimental
 */
export interface ClientVpnAuthorizationRuleOptions {
    /**
     * (experimental) The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     *
     * @experimental
     */
    readonly cidr: string;
    /**
     * (experimental) The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
     *
     * @default - authorize all groups
     * @experimental
     */
    readonly groupId?: string;
    /**
     * (experimental) A brief description of the authorization rule.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Properties for a ClientVpnAuthorizationRule.
 *
 * @experimental
 */
export interface ClientVpnAuthorizationRuleProps extends ClientVpnAuthorizationRuleOptions {
    /**
     * (experimental) The client VPN endpoint to which to add the rule.
     *
     * @experimental
     */
    readonly clientVpnEndoint: IClientVpnEndpoint;
}
/**
 * (experimental) A client VPN authorization rule.
 *
 * @experimental
 */
export declare class ClientVpnAuthorizationRule extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClientVpnAuthorizationRuleProps);
}
