import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export interface CfnGlobalTableProps {
    /**
     * `AWS::DynamoDB::GlobalTable.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions
     */
    readonly attributeDefinitions: Array<CfnGlobalTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema
     */
    readonly keySchema: Array<CfnGlobalTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.Replicas`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas
     */
    readonly replicas: Array<CfnGlobalTable.ReplicaSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode
     */
    readonly billingMode?: string;
    /**
     * `AWS::DynamoDB::GlobalTable.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes
     */
    readonly globalSecondaryIndexes?: Array<CfnGlobalTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes
     */
    readonly localSecondaryIndexes?: Array<CfnGlobalTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification
     */
    readonly sseSpecification?: CfnGlobalTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification
     */
    readonly streamSpecification?: CfnGlobalTable.StreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename
     */
    readonly tableName?: string;
    /**
     * `AWS::DynamoDB::GlobalTable.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification
     */
    readonly timeToLiveSpecification?: CfnGlobalTable.TimeToLiveSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.WriteProvisionedThroughputSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings
     */
    readonly writeProvisionedThroughputSettings?: CfnGlobalTable.WriteProvisionedThroughputSettingsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare class CfnGlobalTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::GlobalTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGlobalTable;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute StreamArn
     */
    readonly attrStreamArn: string;
    /**
     * @external
     * @cloudformationAttribute TableId
     */
    readonly attrTableId: string;
    /**
     * `AWS::DynamoDB::GlobalTable.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions
     */
    attributeDefinitions: Array<CfnGlobalTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema
     */
    keySchema: Array<CfnGlobalTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.Replicas`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas
     */
    replicas: Array<CfnGlobalTable.ReplicaSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::GlobalTable.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode
     */
    billingMode: string | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes
     */
    globalSecondaryIndexes: Array<CfnGlobalTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes
     */
    localSecondaryIndexes: Array<CfnGlobalTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification
     */
    sseSpecification: CfnGlobalTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification
     */
    streamSpecification: CfnGlobalTable.StreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename
     */
    tableName: string | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification
     */
    timeToLiveSpecification: CfnGlobalTable.TimeToLiveSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::GlobalTable.WriteProvisionedThroughputSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings
     */
    writeProvisionedThroughputSettings: CfnGlobalTable.WriteProvisionedThroughputSettingsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::DynamoDB::GlobalTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGlobalTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html
     */
    interface AttributeDefinitionProperty {
        /**
         * `CfnGlobalTable.AttributeDefinitionProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnGlobalTable.AttributeDefinitionProperty.AttributeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributetype
         */
        readonly attributeType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html
     */
    interface CapacityAutoScalingSettingsProperty {
        /**
         * `CfnGlobalTable.CapacityAutoScalingSettingsProperty.MaxCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-maxcapacity
         */
        readonly maxCapacity: number;
        /**
         * `CfnGlobalTable.CapacityAutoScalingSettingsProperty.MinCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-mincapacity
         */
        readonly minCapacity: number;
        /**
         * `CfnGlobalTable.CapacityAutoScalingSettingsProperty.SeedCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-seedcapacity
         */
        readonly seedCapacity?: number;
        /**
         * `CfnGlobalTable.CapacityAutoScalingSettingsProperty.TargetTrackingScalingPolicyConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-targettrackingscalingpolicyconfiguration
         */
        readonly targetTrackingScalingPolicyConfiguration: CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html
     */
    interface ContributorInsightsSpecificationProperty {
        /**
         * `CfnGlobalTable.ContributorInsightsSpecificationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html#cfn-dynamodb-globaltable-contributorinsightsspecification-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html
     */
    interface GlobalSecondaryIndexProperty {
        /**
         * `CfnGlobalTable.GlobalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-indexname
         */
        readonly indexName: string;
        /**
         * `CfnGlobalTable.GlobalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-keyschema
         */
        readonly keySchema: Array<CfnGlobalTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnGlobalTable.GlobalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-projection
         */
        readonly projection: CfnGlobalTable.ProjectionProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.GlobalSecondaryIndexProperty.WriteProvisionedThroughputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-writeprovisionedthroughputsettings
         */
        readonly writeProvisionedThroughputSettings?: CfnGlobalTable.WriteProvisionedThroughputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html
     */
    interface KeySchemaProperty {
        /**
         * `CfnGlobalTable.KeySchemaProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnGlobalTable.KeySchemaProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-keytype
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html
     */
    interface LocalSecondaryIndexProperty {
        /**
         * `CfnGlobalTable.LocalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-indexname
         */
        readonly indexName: string;
        /**
         * `CfnGlobalTable.LocalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-keyschema
         */
        readonly keySchema: Array<CfnGlobalTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnGlobalTable.LocalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-projection
         */
        readonly projection: CfnGlobalTable.ProjectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html
     */
    interface PointInTimeRecoverySpecificationProperty {
        /**
         * `CfnGlobalTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html#cfn-dynamodb-globaltable-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        readonly pointInTimeRecoveryEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html
     */
    interface ProjectionProperty {
        /**
         * `CfnGlobalTable.ProjectionProperty.NonKeyAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-nonkeyattributes
         */
        readonly nonKeyAttributes?: string[];
        /**
         * `CfnGlobalTable.ProjectionProperty.ProjectionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-projectiontype
         */
        readonly projectionType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html
     */
    interface ReadProvisionedThroughputSettingsProperty {
        /**
         * `CfnGlobalTable.ReadProvisionedThroughputSettingsProperty.ReadCapacityAutoScalingSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityautoscalingsettings
         */
        readonly readCapacityAutoScalingSettings?: CfnGlobalTable.CapacityAutoScalingSettingsProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReadProvisionedThroughputSettingsProperty.ReadCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityunits
         */
        readonly readCapacityUnits?: number;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html
     */
    interface ReplicaGlobalSecondaryIndexSpecificationProperty {
        /**
         * `CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty.ContributorInsightsSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-contributorinsightsspecification
         */
        readonly contributorInsightsSpecification?: CfnGlobalTable.ContributorInsightsSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-indexname
         */
        readonly indexName: string;
        /**
         * `CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty.ReadProvisionedThroughputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-readprovisionedthroughputsettings
         */
        readonly readProvisionedThroughputSettings?: CfnGlobalTable.ReadProvisionedThroughputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html
     */
    interface ReplicaSSESpecificationProperty {
        /**
         * `CfnGlobalTable.ReplicaSSESpecificationProperty.KMSMasterKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html#cfn-dynamodb-globaltable-replicassespecification-kmsmasterkeyid
         */
        readonly kmsMasterKeyId: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html
     */
    interface ReplicaSpecificationProperty {
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.ContributorInsightsSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-contributorinsightsspecification
         */
        readonly contributorInsightsSpecification?: CfnGlobalTable.ContributorInsightsSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.GlobalSecondaryIndexes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-globalsecondaryindexes
         */
        readonly globalSecondaryIndexes?: Array<CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.PointInTimeRecoverySpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-pointintimerecoveryspecification
         */
        readonly pointInTimeRecoverySpecification?: CfnGlobalTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.ReadProvisionedThroughputSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-readprovisionedthroughputsettings
         */
        readonly readProvisionedThroughputSettings?: CfnGlobalTable.ReadProvisionedThroughputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-region
         */
        readonly region: string;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.SSESpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-ssespecification
         */
        readonly sseSpecification?: CfnGlobalTable.ReplicaSSESpecificationProperty | cdk.IResolvable;
        /**
         * `CfnGlobalTable.ReplicaSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html
     */
    interface SSESpecificationProperty {
        /**
         * `CfnGlobalTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-sseenabled
         */
        readonly sseEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnGlobalTable.SSESpecificationProperty.SSEType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-ssetype
         */
        readonly sseType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html
     */
    interface StreamSpecificationProperty {
        /**
         * `CfnGlobalTable.StreamSpecificationProperty.StreamViewType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html#cfn-dynamodb-globaltable-streamspecification-streamviewtype
         */
        readonly streamViewType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html
     */
    interface TargetTrackingScalingPolicyConfigurationProperty {
        /**
         * `CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty.DisableScaleIn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-disablescalein
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty.ScaleInCooldown`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleincooldown
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty.ScaleOutCooldown`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleoutcooldown
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty.TargetValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-targetvalue
         */
        readonly targetValue: number;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html
     */
    interface TimeToLiveSpecificationProperty {
        /**
         * `CfnGlobalTable.TimeToLiveSpecificationProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-attributename
         */
        readonly attributeName?: string;
        /**
         * `CfnGlobalTable.TimeToLiveSpecificationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
export declare namespace CfnGlobalTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html
     */
    interface WriteProvisionedThroughputSettingsProperty {
        /**
         * `CfnGlobalTable.WriteProvisionedThroughputSettingsProperty.WriteCapacityAutoScalingSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings-writecapacityautoscalingsettings
         */
        readonly writeCapacityAutoScalingSettings?: CfnGlobalTable.CapacityAutoScalingSettingsProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::DynamoDB::Table`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export interface CfnTableProps {
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    readonly attributeDefinitions?: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    readonly billingMode?: string;
    /**
     * `AWS::DynamoDB::Table.ContributorInsightsSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-contributorinsightsspecification-enabled
     */
    readonly contributorInsightsSpecification?: CfnTable.ContributorInsightsSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    readonly globalSecondaryIndexes?: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.KinesisStreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification
     */
    readonly kinesisStreamSpecification?: CfnTable.KinesisStreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    readonly localSecondaryIndexes?: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    readonly pointInTimeRecoverySpecification?: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    readonly sseSpecification?: CfnTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    readonly streamSpecification?: CfnTable.StreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    readonly tableName?: string;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    readonly timeToLiveSpecification?: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::Table";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTable;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute StreamArn
     */
    readonly attrStreamArn: string;
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    attributeDefinitions: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    billingMode: string | undefined;
    /**
     * `AWS::DynamoDB::Table.ContributorInsightsSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-contributorinsightsspecification-enabled
     */
    contributorInsightsSpecification: CfnTable.ContributorInsightsSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    globalSecondaryIndexes: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.KinesisStreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification
     */
    kinesisStreamSpecification: CfnTable.KinesisStreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    localSecondaryIndexes: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    pointInTimeRecoverySpecification: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    provisionedThroughput: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    sseSpecification: CfnTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    streamSpecification: CfnTable.StreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    tableName: string | undefined;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    timeToLiveSpecification: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::DynamoDB::Table`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    interface AttributeDefinitionProperty {
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        readonly attributeType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-contributorinsightsspecification.html
     */
    interface ContributorInsightsSpecificationProperty {
        /**
         * `CfnTable.ContributorInsightsSpecificationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-contributorinsightsspecification.html#cfn-dynamodb-contributorinsightsspecification-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    interface GlobalSecondaryIndexProperty {
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ContributorInsightsSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-contributorinsightsspecification-enabled
         */
        readonly contributorInsightsSpecification?: CfnTable.ContributorInsightsSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        readonly indexName: string;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    interface KeySchemaProperty {
        /**
         * `CfnTable.KeySchemaProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.KeySchemaProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-kinesisstreamspecification.html
     */
    interface KinesisStreamSpecificationProperty {
        /**
         * `CfnTable.KinesisStreamSpecificationProperty.StreamArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-kinesisstreamspecification.html#cfn-dynamodb-kinesisstreamspecification-streamarn
         */
        readonly streamArn: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    interface LocalSecondaryIndexProperty {
        /**
         * `CfnTable.LocalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        readonly indexName: string;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    interface PointInTimeRecoverySpecificationProperty {
        /**
         * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        readonly pointInTimeRecoveryEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    interface ProjectionProperty {
        /**
         * `CfnTable.ProjectionProperty.NonKeyAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        readonly nonKeyAttributes?: string[];
        /**
         * `CfnTable.ProjectionProperty.ProjectionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        readonly projectionType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        readonly readCapacityUnits: number;
        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        readonly writeCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    interface SSESpecificationProperty {
        /**
         * `CfnTable.SSESpecificationProperty.KMSMasterKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        readonly sseEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnTable.SSESpecificationProperty.SSEType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype
         */
        readonly sseType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    interface StreamSpecificationProperty {
        /**
         * `CfnTable.StreamSpecificationProperty.StreamViewType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        readonly streamViewType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    interface TimeToLiveSpecificationProperty {
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
