"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DynamoDBMetrics {
    static userErrorsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'UserErrors',
            dimensions,
            statistic: 'Sum',
        };
    }
    static throttledRequestsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ThrottledRequests',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedReadCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConsumedReadCapacityUnits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static provisionedReadCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ProvisionedReadCapacityUnits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedWriteCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConsumedWriteCapacityUnits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static provisionedWriteCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ProvisionedWriteCapacityUnits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static successfulRequestLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'SuccessfulRequestLatency',
            dimensions,
            statistic: 'Average',
        };
    }
    static returnedBytesAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReturnedBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static returnedItemCountSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReturnedItemCount',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DynamoDBMetrics = DynamoDBMetrics;
//# sourceMappingURL=data:application/json;base64,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