import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A parameter group.
 *
 * @experimental
 */
export interface IClusterParameterGroup extends IResource {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
}
/**
 * A new cluster or instance parameter group
 */
declare abstract class ClusterParameterGroupBase extends Resource implements IClusterParameterGroup {
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IClusterParameterGroup;
    /**
     * The name of the parameter group
     */
    abstract readonly parameterGroupName: string;
}
/**
 * (experimental) Properties for a cluster parameter group.
 *
 * @experimental
 */
export interface ClusterParameterGroupProps {
    /**
     * (experimental) Description for this parameter group.
     *
     * @default a CDK generated description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Database family of this parameter group.
     *
     * @experimental
     */
    readonly family: string;
    /**
     * (experimental) The name of the cluster parameter group.
     *
     * @default A CDK generated name for the cluster parameter group
     * @experimental
     */
    readonly dbClusterParameterGroupName?: string;
    /**
     * (experimental) The parameters in this parameter group.
     *
     * @experimental
     */
    readonly parameters: {
        [key: string]: string;
    };
}
/**
 * (experimental) A cluster parameter group.
 *
 * @experimental
 * @resource AWS::DocDB::DBClusterParameterGroup
 */
export declare class ClusterParameterGroup extends ClusterParameterGroupBase implements IClusterParameterGroup {
    /**
     * (experimental) The name of the parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
export {};
