import * as ec2 from "../../aws-ec2";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IDatabaseCluster } from './cluster-ref';
import { Endpoint } from './endpoint';
/**
 * (experimental) A database instance.
 *
 * @experimental
 */
export interface IDatabaseInstance extends cdk.IResource {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance arn.
     *
     * @experimental
     */
    readonly instanceArn: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     * @attribute Endpoint
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     * @attribute Port
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     */
    readonly instanceEndpoint: Endpoint;
}
/**
 * (experimental) Properties that describe an existing instance.
 *
 * @experimental
 */
export interface DatabaseInstanceAttributes {
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The endpoint address.
     *
     * @experimental
     */
    readonly instanceEndpointAddress: string;
    /**
     * (experimental) The database port.
     *
     * @experimental
     */
    readonly port: number;
}
/**
 * A new or imported database instance.
 */
declare abstract class DatabaseInstanceBase extends cdk.Resource implements IDatabaseInstance {
    /**
     * (experimental) Import an existing database instance.
     *
     * @experimental
     */
    static fromDatabaseInstanceAttributes(scope: Construct, id: string, attrs: DatabaseInstanceAttributes): IDatabaseInstance;
    /**
     * @inheritdoc
     */
    abstract readonly instanceIdentifier: string;
    /**
     * @inheritdoc
     */
    abstract readonly dbInstanceEndpointAddress: string;
    /**
     * @inheritdoc
     */
    abstract readonly dbInstanceEndpointPort: string;
    /**
     * @inheritdoc
     */
    abstract readonly instanceEndpoint: Endpoint;
    /**
     * (experimental) The instance arn.
     *
     * @experimental
     */
    get instanceArn(): string;
}
/**
 * (experimental) Construction properties for a DatabaseInstanceNew.
 *
 * @experimental
 */
export interface DatabaseInstanceProps {
    /**
     * (experimental) The DocumentDB database cluster the instance should launch into.
     *
     * @experimental
     */
    readonly cluster: IDatabaseCluster;
    /**
     * (experimental) The name of the compute and memory capacity classes.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) The name of the Availability Zone where the DB instance will be located.
     *
     * @default - no preference
     * @experimental
     */
    readonly availabilityZone?: string;
    /**
     * (experimental) A name for the DB instance.
     *
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly dbInstanceName?: string;
    /**
     * (experimental) Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     *
     * @default true
     * @experimental
     */
    readonly autoMinorVersionUpgrade?: boolean;
    /**
     * (experimental) The weekly time range (in UTC) during which system maintenance can occur.
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     * Constraint: Minimum 30-minute window
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region, occurring on a random day of the week. To see
     * the time blocks available, see https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window
     * @experimental
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * (experimental) The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * (experimental) A database instance.
 *
 * @experimental
 * @resource AWS::DocDB::DBInstance
 */
export declare class DatabaseInstance extends DatabaseInstanceBase implements IDatabaseInstance {
    /**
     * (experimental) The instance's database cluster.
     *
     * @experimental
     */
    readonly cluster: IDatabaseCluster;
    /**
     * (experimental) The instance identifier.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly instanceIdentifier: string;
    /**
     * (experimental) The instance endpoint address.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * (experimental) The instance endpoint port.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly dbInstanceEndpointPort: string;
    /**
     * (experimental) The instance endpoint.
     *
     * @experimental
     * @inheritdoc true
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseInstanceProps);
}
export {};
