import { IKey } from "../../aws-kms";
import { ISecret, Secret } from "../../aws-secretsmanager";
import { Construct } from 'constructs';
/**
 * (experimental) Construction properties for a DatabaseSecret.
 *
 * @experimental
 */
export interface DatabaseSecretProps {
    /**
     * (experimental) The username.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The KMS key to use to encrypt the secret.
     *
     * @default default master key
     * @experimental
     */
    readonly encryptionKey?: IKey;
    /**
     * (experimental) The physical name of the secret.
     *
     * @default Secretsmanager will generate a physical name for the secret
     * @experimental
     */
    readonly secretName?: string;
    /**
     * (experimental) The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     * @experimental
     */
    readonly masterSecret?: ISecret;
}
/**
 * (experimental) A database secret.
 *
 * @experimental
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends Secret {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
