import { IConnectable, ISecurityGroup } from "../../aws-ec2";
import { ISecretAttachmentTarget } from "../../aws-secretsmanager";
import { IResource } from "../../core";
import { Endpoint } from './endpoint';
/**
 * (experimental) Create a clustered database with a given number of instances.
 *
 * @experimental
 */
export interface IDatabaseCluster extends IResource, IConnectable, ISecretAttachmentTarget {
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) Identifiers of the replicas.
     *
     * @experimental
     */
    readonly instanceIdentifiers: string[];
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     * @attribute Endpoint,Port
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     * @attribute ReadEndpoint
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) Endpoints which address each individual replica.
     *
     * @experimental
     */
    readonly instanceEndpoints: Endpoint[];
    /**
     * (experimental) The security group for this database cluster.
     *
     * @experimental
     */
    readonly securityGroupId: string;
}
/**
 * (experimental) Properties that describe an existing cluster instance.
 *
 * @experimental
 */
export interface DatabaseClusterAttributes {
    /**
     * (experimental) The database port.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) The security group of the database cluster.
     *
     * @experimental
     */
    readonly securityGroup: ISecurityGroup;
    /**
     * (experimental) Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) Identifier for the instances.
     *
     * @experimental
     */
    readonly instanceIdentifiers: string[];
    /**
     * (experimental) Cluster endpoint address.
     *
     * @experimental
     */
    readonly clusterEndpointAddress: string;
    /**
     * (experimental) Reader endpoint address.
     *
     * @experimental
     */
    readonly readerEndpointAddress: string;
    /**
     * (experimental) Endpoint addresses of individual instances.
     *
     * @experimental
     */
    readonly instanceEndpointAddresses: string[];
}
