"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DMSMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DMSMetrics {
    static cdcLatencyTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCLatencyTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcLatencySourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCLatencySource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static availableMemoryAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'AvailableMemory',
            dimensions,
            statistic: 'Average',
        };
    }
    static cdcChangesDiskTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCChangesDiskTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcChangesMemorySourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCChangesMemorySource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcChangesMemoryTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCChangesMemoryTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcIncomingChangesSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCIncomingChanges',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcThroughputBandwidthSourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCThroughputBandwidthSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcThroughputBandwidthTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCThroughputBandwidthTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcThroughputRowsSourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCThroughputRowsSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cdcThroughputRowsTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CDCThroughputRowsTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cpuAllocatedSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CPUAllocated',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static freeMemoryAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'FreeMemory',
            dimensions,
            statistic: 'Average',
        };
    }
    static fullLoadThroughputBandwidthSourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'FullLoadThroughputBandwidthSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static fullLoadThroughputBandwidthTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'FullLoadThroughputBandwidthTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static fullLoadThroughputRowsSourceSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'FullLoadThroughputRowsSource',
            dimensions,
            statistic: 'Sum',
        };
    }
    static fullLoadThroughputRowsTargetSum(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'FullLoadThroughputRowsTarget',
            dimensions,
            statistic: 'Sum',
        };
    }
    static memoryAllocatedAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'MemoryAllocated',
            dimensions,
            statistic: 'Average',
        };
    }
    static memoryUsageAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'MemoryUsage',
            dimensions,
            statistic: 'Average',
        };
    }
    static swapUsageAverage(dimensions) {
        return {
            namespace: 'AWS/DMS',
            metricName: 'SwapUsage',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.DMSMetrics = DMSMetrics;
//# sourceMappingURL=data:application/json;base64,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