import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 */
export interface CfnNotificationChannelProps {
    /**
     * `AWS::DevOpsGuru::NotificationChannel.Config`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html#cfn-devopsguru-notificationchannel-config
     */
    readonly config: CfnNotificationChannel.NotificationChannelConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 */
export declare class CfnNotificationChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DevOpsGuru::NotificationChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotificationChannel;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::DevOpsGuru::NotificationChannel.Config`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html#cfn-devopsguru-notificationchannel-config
     */
    config: CfnNotificationChannel.NotificationChannelConfigProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::DevOpsGuru::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotificationChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 */
export declare namespace CfnNotificationChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-notificationchannelconfig.html
     */
    interface NotificationChannelConfigProperty {
        /**
         * `CfnNotificationChannel.NotificationChannelConfigProperty.Sns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-notificationchannelconfig.html#cfn-devopsguru-notificationchannel-notificationchannelconfig-sns
         */
        readonly sns?: CfnNotificationChannel.SnsChannelConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 */
export declare namespace CfnNotificationChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-snschannelconfig.html
     */
    interface SnsChannelConfigProperty {
        /**
         * `CfnNotificationChannel.SnsChannelConfigProperty.TopicArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-snschannelconfig.html#cfn-devopsguru-notificationchannel-snschannelconfig-topicarn
         */
        readonly topicArn?: string;
    }
}
/**
 * Properties for defining a `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 */
export interface CfnResourceCollectionProps {
    /**
     * `AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter
     */
    readonly resourceCollectionFilter: CfnResourceCollection.ResourceCollectionFilterProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 */
export declare class CfnResourceCollection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DevOpsGuru::ResourceCollection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceCollection;
    /**
     * @external
     * @cloudformationAttribute ResourceCollectionType
     */
    readonly attrResourceCollectionType: string;
    /**
     * `AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter
     */
    resourceCollectionFilter: CfnResourceCollection.ResourceCollectionFilterProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::DevOpsGuru::ResourceCollection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceCollectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 */
export declare namespace CfnResourceCollection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html
     */
    interface CloudFormationCollectionFilterProperty {
        /**
         * `CfnResourceCollection.CloudFormationCollectionFilterProperty.StackNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html#cfn-devopsguru-resourcecollection-cloudformationcollectionfilter-stacknames
         */
        readonly stackNames?: string[];
    }
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 */
export declare namespace CfnResourceCollection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html
     */
    interface ResourceCollectionFilterProperty {
        /**
         * `CfnResourceCollection.ResourceCollectionFilterProperty.CloudFormation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-cloudformation
         */
        readonly cloudFormation?: CfnResourceCollection.CloudFormationCollectionFilterProperty | cdk.IResolvable;
    }
}
