"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DAXMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DAXMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static itemCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static itemCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static batchGetItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchGetItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static batchWriteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchWriteItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheMemoryUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CacheMemoryUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static clientConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ClientConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static deleteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'DeleteItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static errorRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ErrorRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static estimatedDbSizeAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EstimatedDbSize',
            dimensions,
            statistic: 'Average',
        };
    }
    static evictedSizeSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EvictedSize',
            dimensions,
            statistic: 'Sum',
        };
    }
    static failedRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FailedRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static faultRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FaultRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static getItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'GetItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static putItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'PutItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static throttledRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ThrottledRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TotalRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static transactGetItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactGetItemsCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static transactWriteItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactWriteItemsCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static updateItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'UpdateItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DAXMetrics = DAXMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF4LWNhbm5lZC1tZXRyaWNzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRheC1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0VBQStFO0FBQy9FLDRCQUE0QixDQUFDLGlFQUFpRTtBQUM5RixNQUFhLFVBQVU7SUFDWixNQUFNLENBQUMscUJBQXFCLENBQUMsVUFFbkM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixVQUFVO1lBQ1YsU0FBUyxFQUFFLFNBQVM7U0FDdkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsVUFFOUI7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGVBQWU7WUFDM0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLGtCQUFrQixDQUFDLFVBRWhDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxpQkFBaUI7WUFDN0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLDJCQUEyQixDQUFDLFVBRXpDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSwwQkFBMEI7WUFDdEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLDZCQUE2QixDQUFDLFVBRTNDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSw0QkFBNEI7WUFDeEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLDZCQUE2QixDQUFDLFVBRTNDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx3QkFBd0I7WUFDcEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3ZCLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLG9CQUFvQixDQUFDLFVBRWxDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxtQkFBbUI7WUFDL0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLHlCQUF5QixDQUFDLFVBRXZDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx3QkFBd0I7WUFDcEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLG9CQUFvQixDQUFDLFVBRWxDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxtQkFBbUI7WUFDL0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLHNCQUFzQixDQUFDLFVBRXBDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxpQkFBaUI7WUFDN0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxTQUFTO1NBQ3ZCLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLGNBQWMsQ0FBQyxVQUU1QjtRQUNHLE9BQU87WUFDSCxTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsYUFBYTtZQUN6QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMscUJBQXFCLENBQUMsVUFFbkM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLG9CQUFvQjtZQUNoQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsb0JBQW9CLENBQUMsVUFFbEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLG1CQUFtQjtZQUMvQixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsc0JBQXNCLENBQUMsVUFFcEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLHFCQUFxQjtZQUNqQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsaUJBQWlCLENBQUMsVUFFL0I7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsa0JBQWtCLENBQUMsVUFFaEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsbUJBQW1CLENBQUMsVUFFakM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGtCQUFrQjtZQUM5QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsb0JBQW9CLENBQUMsVUFFbEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLG1CQUFtQjtZQUMvQixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsc0JBQXNCLENBQUMsVUFFcEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLHFCQUFxQjtZQUNqQyxVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsaUJBQWlCLENBQUMsVUFFL0I7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsbUJBQW1CLENBQUMsVUFFakM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGtCQUFrQjtZQUM5QixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsb0JBQW9CLENBQUMsVUFFbEM7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLG1CQUFtQjtZQUMvQixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUs7U0FDbkIsQ0FBQztJQUNOLENBQUM7SUFDTSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsVUFFOUI7UUFDRyxPQUFPO1lBQ0gsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGVBQWU7WUFDM0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLGtCQUFrQixDQUFDLFVBRWhDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxpQkFBaUI7WUFDN0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLG1CQUFtQixDQUFDLFVBRWpDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxrQkFBa0I7WUFDOUIsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLHdCQUF3QixDQUFDLFVBRXRDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx1QkFBdUI7WUFDbkMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLG9CQUFvQixDQUFDLFVBRWxDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSxtQkFBbUI7WUFDL0IsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLHdCQUF3QixDQUFDLFVBRXRDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx1QkFBdUI7WUFDbkMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLDBCQUEwQixDQUFDLFVBRXhDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx5QkFBeUI7WUFDckMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0lBQ00sTUFBTSxDQUFDLHlCQUF5QixDQUFDLFVBRXZDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxTQUFTO1lBQ3BCLFVBQVUsRUFBRSx3QkFBd0I7WUFDcEMsVUFBVTtZQUNWLFNBQVMsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUFDTixDQUFDO0NBQ0o7QUE3U0QsZ0NBNlNDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTItMjAyMSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiAqLyAvLyBUaGlzIGlzIGdlbmVyYXRlZCBjb2RlIC0gbGluZSBsZW5ndGhzIGFyZSBkaWZmaWN1bHQgdG8gY29udHJvbFxuZXhwb3J0IGNsYXNzIERBWE1ldHJpY3Mge1xuICAgIHB1YmxpYyBzdGF0aWMgY3B1VXRpbGl6YXRpb25BdmVyYWdlKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnQ1BVVXRpbGl6YXRpb24nLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGl0ZW1DYWNoZUhpdHNTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdJdGVtQ2FjaGVIaXRzJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGl0ZW1DYWNoZU1pc3Nlc1N1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0l0ZW1DYWNoZU1pc3NlcycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBiYXRjaEdldEl0ZW1SZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdCYXRjaEdldEl0ZW1SZXF1ZXN0Q291bnQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgYmF0Y2hXcml0ZUl0ZW1SZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdCYXRjaFdyaXRlSXRlbVJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBjYWNoZU1lbW9yeVV0aWxpemF0aW9uQXZlcmFnZShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0NhY2hlTWVtb3J5VXRpbGl6YXRpb24nLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGNsaWVudENvbm5lY3Rpb25zU3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnQ2xpZW50Q29ubmVjdGlvbnMnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgZGVsZXRlSXRlbVJlcXVlc3RDb3VudFN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0RlbGV0ZUl0ZW1SZXF1ZXN0Q291bnQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgZXJyb3JSZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdFcnJvclJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBlc3RpbWF0ZWREYlNpemVBdmVyYWdlKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnRXN0aW1hdGVkRGJTaXplJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBldmljdGVkU2l6ZVN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0V2aWN0ZWRTaXplJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGZhaWxlZFJlcXVlc3RDb3VudFN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0ZhaWxlZFJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBmYXVsdFJlcXVlc3RDb3VudFN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0ZhdWx0UmVxdWVzdENvdW50JyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGdldEl0ZW1SZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdHZXRJdGVtUmVxdWVzdENvdW50JyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIG5ldHdvcmtCeXRlc0luU3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnTmV0d29ya0J5dGVzSW4nLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgbmV0d29ya0J5dGVzT3V0U3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnTmV0d29ya0J5dGVzT3V0JyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIG5ldHdvcmtQYWNrZXRzSW5TdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdOZXR3b3JrUGFja2V0c0luJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIG5ldHdvcmtQYWNrZXRzT3V0U3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnTmV0d29ya1BhY2tldHNPdXQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgcHV0SXRlbVJlcXVlc3RDb3VudFN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ1B1dEl0ZW1SZXF1ZXN0Q291bnQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgcXVlcnlDYWNoZUhpdHNTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdRdWVyeUNhY2hlSGl0cycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBxdWVyeUNhY2hlTWlzc2VzU3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnUXVlcnlDYWNoZU1pc3NlcycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBxdWVyeVJlcXVlc3RDb3VudFN1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ1F1ZXJ5UmVxdWVzdENvdW50JyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIHNjYW5DYWNoZUhpdHNTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdTY2FuQ2FjaGVIaXRzJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIHNjYW5DYWNoZU1pc3Nlc1N1bShkaW1lbnNpb25zOiB7XG4gICAgICAgIENsdXN0ZXJJZDogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9EQVgnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ1NjYW5DYWNoZU1pc3NlcycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyBzY2FuUmVxdWVzdENvdW50U3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnU2NhblJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyB0aHJvdHRsZWRSZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdUaHJvdHRsZWRSZXF1ZXN0Q291bnQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgdG90YWxSZXF1ZXN0Q291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdUb3RhbFJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyB0cmFuc2FjdEdldEl0ZW1zQ291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdUcmFuc2FjdEdldEl0ZW1zQ291bnQnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgdHJhbnNhY3RXcml0ZUl0ZW1zQ291bnRTdW0oZGltZW5zaW9uczoge1xuICAgICAgICBDbHVzdGVySWQ6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvREFYJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdUcmFuc2FjdFdyaXRlSXRlbXNDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHVibGljIHN0YXRpYyB1cGRhdGVJdGVtUmVxdWVzdENvdW50U3VtKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgQ2x1c3RlcklkOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0RBWCcsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnVXBkYXRlSXRlbVJlcXVlc3RDb3VudCcsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=