"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceType = exports.ManagedRuleIdentifiers = exports.CustomRule = exports.ManagedRule = exports.MaximumExecutionFrequency = exports.RuleScope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const config_generated_1 = require("./config.generated");
/**
 * A new or imported rule.
 */
class RuleBase extends core_1.Resource {
    /**
     * (experimental) Defines an EventBridge event rule which triggers for rule events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @experimental
     */
    onEvent(id, options = {}) {
        const rule = new events.Rule(this, id, options);
        rule.addEventPattern({
            source: ['aws.config'],
            detail: {
                configRuleName: [this.configRuleName],
            },
        });
        rule.addTarget(options.target);
        return rule;
    }
    /**
     * (experimental) Defines an EventBridge event rule which triggers for rule compliance events.
     *
     * @experimental
     */
    onComplianceChange(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Compliance Change'],
        });
        return rule;
    }
    /**
     * (experimental) Defines an EventBridge event rule which triggers for rule re-evaluation status events.
     *
     * @experimental
     */
    onReEvaluationStatus(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Re-evaluation Status'],
        });
        return rule;
    }
}
/**
 * A new managed or custom rule.
 */
class RuleNew extends RuleBase {
    /**
     * (experimental) Imports an existing rule.
     *
     * @param configRuleName the name of the rule.
     * @experimental
     */
    static fromConfigRuleName(scope, id, configRuleName) {
        class Import extends RuleBase {
            constructor() {
                super(...arguments);
                this.configRuleName = configRuleName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * (experimental) Determines which resources trigger an evaluation of an AWS Config rule.
 *
 * @experimental
 */
class RuleScope {
    constructor(resourceId, resourceTypes, tagKey, tagValue) {
        this.resourceTypes = resourceTypes;
        this.resourceId = resourceId;
        this.key = tagKey;
        this.value = tagValue;
    }
    /**
     * (experimental) restricts scope of changes to a specific resource type or resource identifier.
     *
     * @experimental
     */
    static fromResource(resourceType, resourceId) {
        return new RuleScope(resourceId, [resourceType]);
    }
    /**
     * (experimental) restricts scope of changes to specific resource types.
     *
     * @experimental
     */
    static fromResources(resourceTypes) {
        return new RuleScope(undefined, resourceTypes);
    }
    /**
     * (experimental) restricts scope of changes to a specific tag.
     *
     * @experimental
     */
    static fromTag(key, value) {
        return new RuleScope(undefined, undefined, key, value);
    }
}
exports.RuleScope = RuleScope;
_a = JSII_RTTI_SYMBOL_1;
RuleScope[_a] = { fqn: "monocdk.aws_config.RuleScope", version: "1.106.1" };
/**
 * (experimental) The maximum frequency at which the AWS Config rule runs evaluations.
 *
 * @experimental
 */
var MaximumExecutionFrequency;
(function (MaximumExecutionFrequency) {
    MaximumExecutionFrequency["ONE_HOUR"] = "One_Hour";
    MaximumExecutionFrequency["THREE_HOURS"] = "Three_Hours";
    MaximumExecutionFrequency["SIX_HOURS"] = "Six_Hours";
    MaximumExecutionFrequency["TWELVE_HOURS"] = "Twelve_Hours";
    MaximumExecutionFrequency["TWENTY_FOUR_HOURS"] = "TwentyFour_Hours";
})(MaximumExecutionFrequency = exports.MaximumExecutionFrequency || (exports.MaximumExecutionFrequency = {}));
/**
 * (experimental) A new managed rule.
 *
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
class ManagedRule extends RuleNew {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        this.ruleScope = props.ruleScope;
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'AWS',
                sourceIdentifier: props.identifier,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        this.isManaged = true;
    }
}
exports.ManagedRule = ManagedRule;
_b = JSII_RTTI_SYMBOL_1;
ManagedRule[_b] = { fqn: "monocdk.aws_config.ManagedRule", version: "1.106.1" };
/**
 * (experimental) A new custom rule.
 *
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
class CustomRule extends RuleNew {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        if (!props.configurationChanges && !props.periodic) {
            throw new Error('At least one of `configurationChanges` or `periodic` must be set to true.');
        }
        const sourceDetails = [];
        this.ruleScope = props.ruleScope;
        if (props.configurationChanges) {
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'ConfigurationItemChangeNotification',
            });
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'OversizedConfigurationItemChangeNotification',
            });
        }
        if (props.periodic) {
            sourceDetails.push({
                eventSource: 'aws.config',
                maximumExecutionFrequency: props.maximumExecutionFrequency,
                messageType: 'ScheduledNotification',
            });
        }
        props.lambdaFunction.addPermission('Permission', {
            principal: new iam.ServicePrincipal('config.amazonaws.com'),
        });
        if (props.lambdaFunction.role) {
            props.lambdaFunction.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSConfigRulesExecutionRole'));
        }
        // The lambda permission must be created before the rule
        this.node.addDependency(props.lambdaFunction);
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'CUSTOM_LAMBDA',
                sourceDetails,
                sourceIdentifier: props.lambdaFunction.functionArn,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        if (props.configurationChanges) {
            this.isCustomWithChanges = true;
        }
    }
}
exports.CustomRule = CustomRule;
_c = JSII_RTTI_SYMBOL_1;
CustomRule[_c] = { fqn: "monocdk.aws_config.CustomRule", version: "1.106.1" };
/**
 * (experimental) Managed rules that are supported by AWS Config.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html
 * @experimental
 */
class ManagedRuleIdentifiers {
    // utility class
    constructor() { }
}
exports.ManagedRuleIdentifiers = ManagedRuleIdentifiers;
_d = JSII_RTTI_SYMBOL_1;
ManagedRuleIdentifiers[_d] = { fqn: "monocdk.aws_config.ManagedRuleIdentifiers", version: "1.106.1" };
/**
 * (experimental) Checks that the inline policies attached to your AWS Identity and Access Management users, roles, and groups do not allow blocked actions on all AWS Key Management Service keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * (experimental) Checks that the managed AWS Identity and Access Management policies that you create do not allow blocked actions on all AWS AWS KMS keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * (experimental) Checks whether the active access keys are rotated within the number of days specified in maxAccessKeyAge.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * @experimental
 */
ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED = 'ACCESS_KEYS_ROTATED';
/**
 * (experimental) Checks whether AWS account is part of AWS Organizations.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html
 * @experimental
 */
ManagedRuleIdentifiers.ACCOUNT_PART_OF_ORGANIZATIONS = 'ACCOUNT_PART_OF_ORGANIZATIONS';
/**
 * (experimental) Checks whether ACM Certificates in your account are marked for expiration within the specified number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ACM_CERTIFICATE_EXPIRATION_CHECK = 'ACM_CERTIFICATE_EXPIRATION_CHECK';
/**
 * (experimental) Checks if rule evaluates Application Load Balancers (ALBs) to ensure they are configured to drop http headers.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ALB_HTTP_DROP_INVALID_HEADER_ENABLED = 'ALB_HTTP_DROP_INVALID_HEADER_ENABLED';
/**
 * (experimental) Checks whether HTTP to HTTPS redirection is configured on all HTTP listeners of Application Load Balancer.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK = 'ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK';
/**
 * (experimental) Checks if Web Application Firewall (WAF) is enabled on Application Load Balancers (ALBs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ALB_WAF_ENABLED = 'ALB_WAF_ENABLED';
/**
 * (experimental) Checks that all methods in Amazon API Gateway stages have caching enabled and encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html
 * @experimental
 */
ManagedRuleIdentifiers.API_GW_CACHE_ENABLED_AND_ENCRYPTED = 'API_GW_CACHE_ENABLED_AND_ENCRYPTED';
/**
 * (experimental) Checks that Amazon API Gateway APIs are of the type specified in the rule parameter endpointConfigurationType.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html
 * @experimental
 */
ManagedRuleIdentifiers.API_GW_ENDPOINT_TYPE_CHECK = 'API_GW_ENDPOINT_TYPE_CHECK';
/**
 * (experimental) Checks that all methods in Amazon API Gateway stage has logging enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.API_GW_EXECUTION_LOGGING_ENABLED = 'API_GW_EXECUTION_LOGGING_ENABLED';
/**
 * (experimental) Checks whether running instances are using specified AMIs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html
 * @experimental
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_ID = 'APPROVED_AMIS_BY_ID';
/**
 * (experimental) Checks whether running instances are using specified AMIs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html
 * @experimental
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_TAG = 'APPROVED_AMIS_BY_TAG';
/**
 * (experimental) Checks whether your Auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html
 * @experimental
 */
ManagedRuleIdentifiers.AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED = 'AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED';
/**
 * (experimental) Checks whether an AWS CloudFormation stack's actual configuration differs, or has drifted, from it's expected configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK = 'CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK';
/**
 * (experimental) Checks whether your CloudFormation stacks are sending event notifications to an SNS topic.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_NOTIFICATION_CHECK = 'CLOUDFORMATION_STACK_NOTIFICATION_CHECK';
/**
 * (experimental) Checks if an Amazon CloudFront distribution is configured to return a specific object that is the default root object.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED = 'CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED';
/**
 * (experimental) Checks that Amazon CloudFront distribution with Amazon S3 Origin type has Origin Access Identity (OAI) configured.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED = 'CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED';
/**
 * (experimental) Checks whether an origin group is configured for the distribution of at least 2 origins in the origin group for Amazon CloudFront.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_FAILOVER_ENABLED = 'CLOUDFRONT_ORIGIN_FAILOVER_ENABLED';
/**
 * (experimental) Checks if Amazon CloudFront distributions are using a custom SSL certificate and are configured to use SNI to serve HTTPS requests.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFRONT_SNI_ENABLED = 'CLOUDFRONT_SNI_ENABLED';
/**
 * (experimental) Checks whether your Amazon CloudFront distributions use HTTPS (directly or via a redirection).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDFRONT_VIEWER_POLICY_HTTPS = 'CLOUDFRONT_VIEWER_POLICY_HTTPS';
/**
 * (experimental) Checks whether AWS CloudTrail trails are configured to send logs to Amazon CloudWatch Logs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED = 'CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED';
/**
 * (experimental) Checks whether AWS CloudTrail is enabled in your AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENABLED = 'CLOUD_TRAIL_ENABLED';
/**
 * (experimental) Checks whether AWS CloudTrail is configured to use the server side encryption (SSE) AWS Key Management Service (AWS KMS) customer master key (CMK) encryption.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENCRYPTION_ENABLED = 'CLOUD_TRAIL_ENCRYPTION_ENABLED';
/**
 * (experimental) Checks whether AWS CloudTrail creates a signed digest file with logs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED = 'CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED';
/**
 * (experimental) Checks whether at least one AWS CloudTrail trail is logging Amazon S3 data events for all S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDTRAIL_S3_DATAEVENTS_ENABLED = 'CLOUDTRAIL_S3_DATAEVENTS_ENABLED';
/**
 * (experimental) Checks that there is at least one AWS CloudTrail trail defined with security best practices.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDTRAIL_SECURITY_TRAIL_ENABLED = 'CLOUDTRAIL_SECURITY_TRAIL_ENABLED';
/**
 * (experimental) Checks whether CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_ACTION_CHECK = 'CLOUDWATCH_ALARM_ACTION_CHECK';
/**
 * (experimental) Checks whether the specified resource type has a CloudWatch alarm for the specified metric.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_RESOURCE_CHECK = 'CLOUDWATCH_ALARM_RESOURCE_CHECK';
/**
 * (experimental) Checks whether CloudWatch alarms with the given metric name have the specified settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_SETTINGS_CHECK = 'CLOUDWATCH_ALARM_SETTINGS_CHECK';
/**
 * (experimental) Checks whether a log group in Amazon CloudWatch Logs is encrypted with a AWS Key Management Service (KMS) managed Customer Master Keys (CMK).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDWATCH_LOG_GROUP_ENCRYPTED = 'CLOUDWATCH_LOG_GROUP_ENCRYPTED';
/**
 * (experimental) Checks that key rotation is enabled for each key and matches to the key ID of the customer created customer master key (CMK).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CMK_BACKING_KEY_ROTATION_ENABLED = 'CMK_BACKING_KEY_ROTATION_ENABLED';
/**
 * (experimental) Checks whether the project contains environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK = 'CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK';
/**
 * (experimental) Checks whether the GitHub or Bitbucket source repository URL contains either personal access tokens or user name and password.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK = 'CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK';
/**
 * (experimental) Checks whether the first deployment stage of the AWS CodePipeline performs more than one deployment.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CODEPIPELINE_DEPLOYMENT_COUNT_CHECK = 'CODEPIPELINE_DEPLOYMENT_COUNT_CHECK';
/**
 * (experimental) Checks whether each stage in the AWS CodePipeline deploys to more than N times the number of the regions the AWS CodePipeline has deployed in all the previous combined stages, where N is the region fanout number.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CODEPIPELINE_REGION_FANOUT_CHECK = 'CODEPIPELINE_REGION_FANOUT_CHECK';
/**
 * (experimental) Checks whether Amazon CloudWatch LogGroup retention period is set to specific number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html
 * @experimental
 */
ManagedRuleIdentifiers.CW_LOGGROUP_RETENTION_PERIOD_CHECK = 'CW_LOGGROUP_RETENTION_PERIOD_CHECK';
/**
 * (experimental) Checks that DynamoDB Accelerator (DAX) clusters are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.DAX_ENCRYPTION_ENABLED = 'DAX_ENCRYPTION_ENABLED';
/**
 * (experimental) Checks whether RDS DB instances have backups enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_DB_INSTANCE_BACKUP_ENABLED = 'DB_INSTANCE_BACKUP_ENABLED';
/**
 * (experimental) Checks instances for specified tenancy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TENANCY = 'DESIRED_INSTANCE_TENANCY';
/**
 * (experimental) Checks whether your EC2 instances are of the specified instance types.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TYPE = 'DESIRED_INSTANCE_TYPE';
/**
 * (experimental) Checks whether AWS Database Migration Service replication instances are public.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html
 * @experimental
 */
ManagedRuleIdentifiers.DMS_REPLICATION_NOT_PUBLIC = 'DMS_REPLICATION_NOT_PUBLIC';
/**
 * (experimental) Checks whether Auto Scaling or On-Demand is enabled on your DynamoDB tables and/or global secondary indexes.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_AUTOSCALING_ENABLED = 'DYNAMODB_AUTOSCALING_ENABLED';
/**
 * (experimental) Checks whether Amazon DynamoDB table is present in AWS Backup plans.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_IN_BACKUP_PLAN = 'DYNAMODB_IN_BACKUP_PLAN';
/**
 * (experimental) Checks that point in time recovery (PITR) is enabled for Amazon DynamoDB tables.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_PITR_ENABLED = 'DYNAMODB_PITR_ENABLED';
/**
 * (experimental) Checks whether Amazon DynamoDB table is encrypted with AWS Key Management Service (KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTED_KMS = 'DYNAMODB_TABLE_ENCRYPTED_KMS';
/**
 * (experimental) Checks whether the Amazon DynamoDB tables are encrypted and checks their status.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTION_ENABLED = 'DYNAMODB_TABLE_ENCRYPTION_ENABLED';
/**
 * (experimental) Checks whether provisioned DynamoDB throughput is approaching the maximum limit for your account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html
 * @experimental
 */
ManagedRuleIdentifiers.DYNAMODB_THROUGHPUT_LIMIT_CHECK = 'DYNAMODB_THROUGHPUT_LIMIT_CHECK';
/**
 * (experimental) Checks if Amazon Elastic Block Store (Amazon EBS) volumes are added in backup plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html
 * @experimental
 */
ManagedRuleIdentifiers.EBS_IN_BACKUP_PLAN = 'EBS_IN_BACKUP_PLAN';
/**
 * (experimental) Checks whether Amazon Elastic File System (Amazon EFS) file systems are added in the backup plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html
 * @experimental
 */
ManagedRuleIdentifiers.EFS_IN_BACKUP_PLAN = 'EFS_IN_BACKUP_PLAN';
/**
 * (experimental) Check that Amazon Elastic Block Store (EBS) encryption is enabled by default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_EBS_ENCRYPTION_BY_DEFAULT = 'EC2_EBS_ENCRYPTION_BY_DEFAULT';
/**
 * (experimental) Checks whether EBS optimization is enabled for your EC2 instances that can be EBS-optimized.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html
 * @experimental
 */
ManagedRuleIdentifiers.EBS_OPTIMIZED_INSTANCE = 'EBS_OPTIMIZED_INSTANCE';
/**
 * (experimental) Checks whether Amazon Elastic Block Store snapshots are not publicly restorable.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK = 'EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK';
/**
 * (experimental) Checks whether detailed monitoring is enabled for EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_INSTANCE_DETAILED_MONITORING_ENABLED = 'EC2_INSTANCE_DETAILED_MONITORING_ENABLED';
/**
 * (experimental) Checks whether the Amazon EC2 instances in your account are managed by AWS Systems Manager.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_INSTANCE_MANAGED_BY_SSM = 'EC2_INSTANCE_MANAGED_BY_SSM';
/**
 * (experimental) Checks whether Amazon Elastic Compute Cloud (Amazon EC2) instances have a public IP association.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_INSTANCE_NO_PUBLIC_IP = 'EC2_INSTANCE_NO_PUBLIC_IP';
/**
 * (experimental) Checks whether your EC2 instances belong to a virtual private cloud (VPC).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_INSTANCES_IN_VPC = 'INSTANCES_IN_VPC';
/**
 * (experimental) Checks that none of the specified applications are installed on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_BLACKLISTED';
/**
 * (experimental) Checks whether all of the specified applications are installed on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_REQUIRED';
/**
 * (experimental) Checks whether the compliance status of AWS Systems Manager association compliance is COMPLIANT or NON_COMPLIANT after the association execution on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK';
/**
 * (experimental) Checks whether instances managed by AWS Systems Manager are configured to collect blocked inventory types.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED = 'EC2_MANAGEDINSTANCE_INVENTORY_BLACKLISTED';
/**
 * (experimental) Checks whether the compliance status of the Amazon EC2 Systems Manager patch compliance is COMPLIANT or NON_COMPLIANT after the patch installation on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_PATCH_COMPLIANCE_STATUS_CHECK';
/**
 * (experimental) Checks whether EC2 managed instances have the desired configurations.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PLATFORM_CHECK = 'EC2_MANAGEDINSTANCE_PLATFORM_CHECK';
/**
 * (experimental) Checks that security groups are attached to Amazon Elastic Compute Cloud (Amazon EC2) instances or to an elastic network interface.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUP_ATTACHED_TO_ENI = 'EC2_SECURITY_GROUP_ATTACHED_TO_ENI';
/**
 * (experimental) Checks whether there are instances stopped for more than the allowed number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_STOPPED_INSTANCE = 'EC2_STOPPED_INSTANCE';
/**
 * (experimental) Checks whether EBS volumes are attached to EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_VOLUME_INUSE_CHECK = 'EC2_VOLUME_INUSE_CHECK';
/**
 * (experimental) hecks whether Amazon Elastic File System (Amazon EFS) is configured to encrypt the file data using AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EFS_ENCRYPTED_CHECK = 'EFS_ENCRYPTED_CHECK';
/**
 * (experimental) Checks whether all Elastic IP addresses that are allocated to a VPC are attached to EC2 instances or in-use elastic network interfaces (ENIs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html
 * @experimental
 */
ManagedRuleIdentifiers.EIP_ATTACHED = 'EIP_ATTACHED';
/**
 * (experimental) Checks whether Amazon Elasticsearch Service (Amazon ES) domains have encryption at rest configuration enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html
 * @experimental
 */
ManagedRuleIdentifiers.ELASTICSEARCH_ENCRYPTED_AT_REST = 'ELASTICSEARCH_ENCRYPTED_AT_REST';
/**
 * (experimental) Checks whether Amazon Elasticsearch Service (Amazon ES) domains are in Amazon Virtual Private Cloud (Amazon VPC).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html
 * @experimental
 */
ManagedRuleIdentifiers.ELASTICSEARCH_IN_VPC_ONLY = 'ELASTICSEARCH_IN_VPC_ONLY';
/**
 * (experimental) Check if the Amazon ElastiCache Redis clusters have automatic backup turned on.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK = 'ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK';
/**
 * (experimental) Checks whether your Amazon Elastic Compute Cloud (Amazon EC2) instance metadata version is configured with Instance Metadata Service Version 2 (IMDSv2).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_IMDSV2_CHECK = 'EC2_IMDSV2_CHECK';
/**
 * (experimental) Checks whether Amazon Elastic Kubernetes Service (Amazon EKS) endpoint is not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html
 * @experimental
 */
ManagedRuleIdentifiers.EKS_ENDPOINT_NO_PUBLIC_ACCESS = 'EKS_ENDPOINT_NO_PUBLIC_ACCESS';
/**
 * (experimental) Checks whether Amazon Elastic Kubernetes Service clusters are configured to have Kubernetes secrets encrypted using AWS Key Management Service (KMS) keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html
 * @experimental
 */
ManagedRuleIdentifiers.EKS_SECRETS_ENCRYPTED = 'EKS_SECRETS_ENCRYPTED';
/**
 * (experimental) Check that Amazon ElasticSearch Service nodes are encrypted end to end.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = 'ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK';
/**
 * (experimental) Checks if cross-zone load balancing is enabled for the Classic Load Balancers (CLBs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED = 'ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED';
/**
 * (experimental) Checks whether your Classic Load Balancer is configured with SSL or HTTPS listeners.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_TLS_HTTPS_LISTENERS_ONLY = 'ELB_TLS_HTTPS_LISTENERS_ONLY';
/**
 * (experimental) Checks whether the Classic Load Balancers use SSL certificates provided by AWS Certificate Manager.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_ACM_CERTIFICATE_REQUIRED = 'ELB_ACM_CERTIFICATE_REQUIRED';
/**
 * (experimental) Checks whether your Classic Load Balancer SSL listeners are using a custom policy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK = 'ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK';
/**
 * (experimental) Checks whether Elastic Load Balancing has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_DELETION_PROTECTION_ENABLED = 'ELB_DELETION_PROTECTION_ENABLED';
/**
 * (experimental) Checks whether the Application Load Balancer and the Classic Load Balancer have logging enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_LOGGING_ENABLED = 'ELB_LOGGING_ENABLED';
/**
 * (experimental) Checks whether your Classic Load Balancer SSL listeners are using a predefined policy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html
 * @experimental
 */
ManagedRuleIdentifiers.ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK = 'ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK';
/**
 * (experimental) Checks that Amazon EMR clusters have Kerberos enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.EMR_KERBEROS_ENABLED = 'EMR_KERBEROS_ENABLED';
/**
 * (experimental) Checks whether Amazon Elastic MapReduce (EMR) clusters' master nodes have public IPs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html
 * @experimental
 */
ManagedRuleIdentifiers.EMR_MASTER_NO_PUBLIC_IP = 'EMR_MASTER_NO_PUBLIC_IP';
/**
 * (experimental) Checks whether the EBS volumes that are in an attached state are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html
 * @experimental
 */
ManagedRuleIdentifiers.EBS_ENCRYPTED_VOLUMES = 'ENCRYPTED_VOLUMES';
/**
 * (experimental) Checks whether the security groups associated inScope resources are compliant with the master security groups at each rule level based on allowSecurityGroup and denySecurityGroup flag.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK = 'FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK';
/**
 * (experimental) Checks whether AWS Firewall Manager created security groups content is the same as the master security groups.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_CONTENT_CHECK = 'FMS_SECURITY_GROUP_CONTENT_CHECK';
/**
 * (experimental) Checks whether Amazon EC2 or an elastic network interface is associated with AWS Firewall Manager security groups.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK = 'FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK';
/**
 * (experimental) Checks whether an Application Load Balancer, Amazon CloudFront distributions, Elastic Load Balancer or Elastic IP has AWS Shield protection.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_SHIELD_RESOURCE_POLICY_CHECK = 'FMS_SHIELD_RESOURCE_POLICY_CHECK';
/**
 * (experimental) Checks whether the web ACL is associated with an Application Load Balancer, API Gateway stage, or Amazon CloudFront distributions.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_WEBACL_RESOURCE_POLICY_CHECK = 'FMS_WEBACL_RESOURCE_POLICY_CHECK';
/**
 * (experimental) Checks that the rule groups associate with the web ACL at the correct priority.
 *
 * The correct priority is decided by the rank of the rule groups in the ruleGroups parameter.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html
 * @experimental
 */
ManagedRuleIdentifiers.FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK = 'FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK';
/**
 * (experimental) Checks whether Amazon GuardDuty is enabled in your AWS account and region.
 *
 * If you provide an AWS account for centralization,
 * the rule evaluates the Amazon GuardDuty results in the centralized account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html
 * @experimental
 */
ManagedRuleIdentifiers.GUARDDUTY_ENABLED_CENTRALIZED = 'GUARDDUTY_ENABLED_CENTRALIZED';
/**
 * (experimental) Checks whether the Amazon GuardDuty has findings that are non archived.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html
 * @experimental
 */
ManagedRuleIdentifiers.GUARDDUTY_NON_ARCHIVED_FINDINGS = 'GUARDDUTY_NON_ARCHIVED_FINDINGS';
/**
 * (experimental) Checks that inline policy feature is not in use.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_NO_INLINE_POLICY_CHECK = 'IAM_NO_INLINE_POLICY_CHECK';
/**
 * (experimental) Checks whether IAM groups have at least one IAM user.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_GROUP_HAS_USERS_CHECK = 'IAM_GROUP_HAS_USERS_CHECK';
/**
 * (experimental) Checks whether the account password policy for IAM users meets the specified requirements indicated in the parameters.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_PASSWORD_POLICY = 'IAM_PASSWORD_POLICY';
/**
 * (experimental) Checks whether for each IAM resource, a policy ARN in the input parameter is attached to the IAM resource.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_POLICY_BLOCKED_CHECK = 'IAM_POLICY_BLACKLISTED_CHECK';
/**
 * (experimental) Checks whether the IAM policy ARN is attached to an IAM user, or an IAM group with one or more IAM users, or an IAM role with one or more trusted entity.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_POLICY_IN_USE = 'IAM_POLICY_IN_USE';
/**
 * (experimental) Checks the IAM policies that you create for Allow statements that grant permissions to all actions on all resources.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS = 'IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS';
/**
 * (experimental) Checks that AWS Identity and Access Management (IAM) policies in a list of policies are attached to all AWS roles.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_ROLE_MANAGED_POLICY_CHECK = 'IAM_ROLE_MANAGED_POLICY_CHECK';
/**
 * (experimental) Checks whether the root user access key is available.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_ROOT_ACCESS_KEY_CHECK = 'IAM_ROOT_ACCESS_KEY_CHECK';
/**
 * (experimental) Checks whether IAM users are members of at least one IAM group.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_USER_GROUP_MEMBERSHIP_CHECK = 'IAM_USER_GROUP_MEMBERSHIP_CHECK';
/**
 * (experimental) Checks whether the AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_USER_MFA_ENABLED = 'IAM_USER_MFA_ENABLED';
/**
 * (experimental) Checks that none of your IAM users have policies attached.
 *
 * IAM users must inherit permissions from IAM groups or roles.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_USER_NO_POLICIES_CHECK = 'IAM_USER_NO_POLICIES_CHECK';
/**
 * (experimental) Checks whether your AWS Identity and Access Management (IAM) users have passwords or active access keys that have not been used within the specified number of days you provided.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html
 * @experimental
 */
ManagedRuleIdentifiers.IAM_USER_UNUSED_CREDENTIALS_CHECK = 'IAM_USER_UNUSED_CREDENTIALS_CHECK';
/**
 * (experimental) Checks that Internet gateways (IGWs) are only attached to an authorized Amazon Virtual Private Cloud (VPCs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html
 * @experimental
 */
ManagedRuleIdentifiers.INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY = 'INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY';
/**
 * (experimental) Checks whether customer master keys (CMKs) are not scheduled for deletion in AWS Key Management Service (KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html
 * @experimental
 */
ManagedRuleIdentifiers.KMS_CMK_NOT_SCHEDULED_FOR_DELETION = 'KMS_CMK_NOT_SCHEDULED_FOR_DELETION';
/**
 * (experimental) Checks whether the AWS Lambda function is configured with function-level concurrent execution limit.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html
 * @experimental
 */
ManagedRuleIdentifiers.LAMBDA_CONCURRENCY_CHECK = 'LAMBDA_CONCURRENCY_CHECK';
/**
 * (experimental) Checks whether an AWS Lambda function is configured with a dead-letter queue.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html
 * @experimental
 */
ManagedRuleIdentifiers.LAMBDA_DLQ_CHECK = 'LAMBDA_DLQ_CHECK';
/**
 * (experimental) Checks whether the AWS Lambda function policy attached to the Lambda resource prohibits public access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html
 * @experimental
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED = 'LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED';
/**
 * (experimental) Checks that the lambda function settings for runtime, role, timeout, and memory size match the expected values.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html
 * @experimental
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_SETTINGS_CHECK = 'LAMBDA_FUNCTION_SETTINGS_CHECK';
/**
 * (experimental) Checks whether an AWS Lambda function is in an Amazon Virtual Private Cloud.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html
 * @experimental
 */
ManagedRuleIdentifiers.LAMBDA_INSIDE_VPC = 'LAMBDA_INSIDE_VPC';
/**
 * (experimental) Checks whether AWS Multi-Factor Authentication (MFA) is enabled for all IAM users that use a console password.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html
 * @experimental
 */
ManagedRuleIdentifiers.MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS = 'MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS';
/**
 * (experimental) Checks that there is at least one multi-region AWS CloudTrail.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.CLOUDTRAIL_MULTI_REGION_ENABLED = 'MULTI_REGION_CLOUD_TRAIL_ENABLED';
/**
 * (experimental) Checks if an Amazon Relational Database Service (Amazon RDS) cluster has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_CLUSTER_DELETION_PROTECTION_ENABLED = 'RDS_CLUSTER_DELETION_PROTECTION_ENABLED';
/**
 * (experimental) Checks if an Amazon Relational Database Service (Amazon RDS) instance has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_INSTANCE_DELETION_PROTECTION_ENABLED = 'RDS_INSTANCE_DELETION_PROTECTION_ENABLED';
/**
 * (experimental) Checks if an Amazon RDS instance has AWS Identity and Access Management (IAM) authentication enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED = 'RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED';
/**
 * (experimental) Checks that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_LOGGING_ENABLED = 'RDS_LOGGING_ENABLED';
/**
 * (experimental) Checks that Amazon Redshift automated snapshots are enabled for clusters.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.REDSHIFT_BACKUP_ENABLED = 'REDSHIFT_BACKUP_ENABLED';
/**
 * (experimental) Checks whether enhanced monitoring is enabled for Amazon Relational Database Service (Amazon RDS) instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_ENHANCED_MONITORING_ENABLED = 'RDS_ENHANCED_MONITORING_ENABLED';
/**
 * (experimental) Checks whether Amazon Relational Database Service (Amazon RDS) DB snapshots are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_SNAPSHOT_ENCRYPTED = 'RDS_SNAPSHOT_ENCRYPTED';
/**
 * (experimental) Checks whether Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html
 * @experimental
 */
ManagedRuleIdentifiers.REDSHIFT_REQUIRE_TLS_SSL = 'REDSHIFT_REQUIRE_TLS_SSL';
/**
 * (experimental) Checks whether Amazon RDS database is present in back plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_IN_BACKUP_PLAN = 'RDS_IN_BACKUP_PLAN';
/**
 * (experimental) Check whether the Amazon Relational Database Service instances are not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_INSTANCE_PUBLIC_ACCESS_CHECK = 'RDS_INSTANCE_PUBLIC_ACCESS_CHECK';
/**
 * (experimental) Checks whether high availability is enabled for your RDS DB instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_MULTI_AZ_SUPPORT = 'RDS_MULTI_AZ_SUPPORT';
/**
 * (experimental) Checks if Amazon Relational Database Service (Amazon RDS) snapshots are public.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_SNAPSHOTS_PUBLIC_PROHIBITED = 'RDS_SNAPSHOTS_PUBLIC_PROHIBITED';
/**
 * (experimental) Checks whether storage encryption is enabled for your RDS DB instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html
 * @experimental
 */
ManagedRuleIdentifiers.RDS_STORAGE_ENCRYPTED = 'RDS_STORAGE_ENCRYPTED';
/**
 * (experimental) Checks whether Amazon Redshift clusters have the specified settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html
 * @experimental
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_CONFIGURATION_CHECK = 'REDSHIFT_CLUSTER_CONFIGURATION_CHECK';
/**
 * (experimental) Checks whether Amazon Redshift clusters have the specified maintenance settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html
 * @experimental
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK = 'REDSHIFT_CLUSTER_MAINTENANCESETTINGS_CHECK';
/**
 * (experimental) Checks whether Amazon Redshift clusters are not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html
 * @experimental
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK = 'REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK';
/**
 * (experimental) Checks whether your resources have the tags that you specify.
 *
 * For example, you can check whether your Amazon EC2 instances have the CostCenter tag.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html
 * @experimental
 */
ManagedRuleIdentifiers.REQUIRED_TAGS = 'REQUIRED_TAGS';
/**
 * (experimental) Checks whether the security groups in use do not allow unrestricted incoming TCP traffic to the specified ports.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC = 'RESTRICTED_INCOMING_TRAFFIC';
/**
 * (experimental) Checks whether the incoming SSH traffic for the security groups is accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html
 * @experimental
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED = 'INCOMING_SSH_DISABLED';
/**
 * (experimental) Checks whether your AWS account is enabled to use multi-factor authentication (MFA) hardware device to sign in with root credentials.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_HARDWARE_MFA_ENABLED = 'ROOT_ACCOUNT_HARDWARE_MFA_ENABLED';
/**
 * (experimental) Checks whether users of your AWS account require a multi-factor authentication (MFA) device to sign in with root credentials.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_MFA_ENABLED = 'ROOT_ACCOUNT_MFA_ENABLED';
/**
 * (experimental) Checks whether Amazon Simple Storage Service (Amazon S3) bucket has lock enabled, by default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_DEFAULT_LOCK_ENABLED = 'S3_BUCKET_DEFAULT_LOCK_ENABLED';
/**
 * (experimental) Checks whether the Amazon Simple Storage Service (Amazon S3) buckets are encrypted with AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_DEFAULT_ENCRYPTION_KMS = 'S3_DEFAULT_ENCRYPTION_KMS';
/**
 * (experimental) Checks that AWS Security Hub is enabled for an AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.SECURITYHUB_ENABLED = 'SECURITYHUB_ENABLED';
/**
 * (experimental) Checks whether Amazon SNS topic is encrypted with AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html
 * @experimental
 */
ManagedRuleIdentifiers.SNS_ENCRYPTED_KMS = 'SNS_ENCRYPTED_KMS';
/**
 * (experimental) Checks whether the required public access block settings are configured from account level.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS = 'S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS';
/**
 * (experimental) Checks that the Amazon Simple Storage Service bucket policy does not allow blocked bucket-level and object-level actions on resources in the bucket for principals from other AWS accounts.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED = 'S3_BUCKET_BLACKLISTED_ACTIONS_PROHIBITED';
/**
 * (experimental) Verifies that your Amazon Simple Storage Service bucket policies do not allow other inter-account permissions than the control Amazon S3 bucket policy provided.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE = 'S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE';
/**
 * (experimental) Checks whether logging is enabled for your S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_LOGGING_ENABLED = 'S3_BUCKET_LOGGING_ENABLED';
/**
 * (experimental) Checks that the access granted by the Amazon S3 bucket is restricted by any of the AWS principals, federated users, service principals, IP addresses, or VPCs that you provide.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_GRANTEE_CHECK = 'S3_BUCKET_POLICY_GRANTEE_CHECK';
/**
 * (experimental) Checks that your Amazon S3 buckets do not allow public read access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_READ_PROHIBITED = 'S3_BUCKET_PUBLIC_READ_PROHIBITED';
/**
 * (experimental) Checks that your Amazon S3 buckets do not allow public write access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_WRITE_PROHIBITED = 'S3_BUCKET_PUBLIC_WRITE_PROHIBITED';
/**
 * (experimental) Checks whether S3 buckets have cross-region replication enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_REPLICATION_ENABLED = 'S3_BUCKET_REPLICATION_ENABLED';
/**
 * (experimental) Checks that your Amazon S3 bucket either has Amazon S3 default encryption enabled or that the S3 bucket policy explicitly denies put-object requests without server side encryption that uses AES-256 or AWS Key Management Service.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED = 'S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED';
/**
 * (experimental) Checks whether S3 buckets have policies that require requests to use Secure Socket Layer (SSL).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_SSL_REQUESTS_ONLY = 'S3_BUCKET_SSL_REQUESTS_ONLY';
/**
 * (experimental) Checks whether versioning is enabled for your S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.S3_BUCKET_VERSIONING_ENABLED = 'S3_BUCKET_VERSIONING_ENABLED';
/**
 * (experimental) Checks whether AWS Key Management Service (KMS) key is configured for an Amazon SageMaker endpoint configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html
 * @experimental
 */
ManagedRuleIdentifiers.SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED = 'SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED';
/**
 * (experimental) Check whether an AWS Key Management Service (KMS) key is configured for SageMaker notebook instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html
 * @experimental
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED = 'SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED';
/**
 * (experimental) Checks whether direct internet access is disabled for an Amazon SageMaker notebook instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html
 * @experimental
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS = 'SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS';
/**
 * (experimental) Checks whether AWS Secrets Manager secret has rotation enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html
 * @experimental
 */
ManagedRuleIdentifiers.SECRETSMANAGER_ROTATION_ENABLED_CHECK = 'SECRETSMANAGER_ROTATION_ENABLED_CHECK';
/**
 * (experimental) Checks whether AWS Secrets Manager secret rotation has rotated successfully as per the rotation schedule.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html
 * @experimental
 */
ManagedRuleIdentifiers.SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK = 'SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK';
/**
 * (experimental) Checks whether Service Endpoint for the service provided in rule parameter is created for each Amazon VPC.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.SERVICE_VPC_ENDPOINT_ENABLED = 'SERVICE_VPC_ENDPOINT_ENABLED';
/**
 * (experimental) Checks whether EBS volumes are attached to EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html
 * @experimental
 */
ManagedRuleIdentifiers.SHIELD_ADVANCED_ENABLED_AUTO_RENEW = 'SHIELD_ADVANCED_ENABLED_AUTORENEW';
/**
 * (experimental) Verify that DDoS response team (DRT) can access AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html
 * @experimental
 */
ManagedRuleIdentifiers.SHIELD_DRT_ACCESS = 'SHIELD_DRT_ACCESS';
/**
 * (experimental) Checks that the default security group of any Amazon Virtual Private Cloud (VPC) does not allow inbound or outbound traffic.
 *
 * The rule returns NOT_APPLICABLE if the security group
 * is not default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html
 * @experimental
 */
ManagedRuleIdentifiers.VPC_DEFAULT_SECURITY_GROUP_CLOSED = 'VPC_DEFAULT_SECURITY_GROUP_CLOSED';
/**
 * (experimental) Checks whether Amazon Virtual Private Cloud flow logs are found and enabled for Amazon VPC.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.VPC_FLOW_LOGS_ENABLED = 'VPC_FLOW_LOGS_ENABLED';
/**
 * (experimental) Checks whether the security group with 0.0.0.0/0 of any Amazon Virtual Private Cloud (Amazon VPC) allows only specific inbound TCP or UDP traffic.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html
 * @experimental
 */
ManagedRuleIdentifiers.VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS = 'VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS';
/**
 * (experimental) Checks that both AWS Virtual Private Network tunnels provided by AWS Site-to-Site VPN are in UP status.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html
 * @experimental
 */
ManagedRuleIdentifiers.VPC_VPN_2_TUNNELS_UP = 'VPC_VPN_2_TUNNELS_UP';
/**
 * (experimental) Checks if logging is enabled on AWS Web Application Firewall (WAF) classic global web ACLs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.WAF_CLASSIC_LOGGING_ENABLED = 'WAF_CLASSIC_LOGGING_ENABLED';
/**
 * (experimental) Checks whether logging is enabled on AWS Web Application Firewall (WAFV2) regional and global web access control list (ACLs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html
 * @experimental
 */
ManagedRuleIdentifiers.WAFV2_LOGGING_ENABLED = 'WAFV2_LOGGING_ENABLED';
/**
 * (experimental) Resources types that are supported by AWS Config.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html
 * @experimental
 */
class ResourceType {
    constructor(type) {
        this.complianceResourceType = type;
    }
    /**
     * (experimental) A custom resource type to support future cases.
     *
     * @experimental
     */
    static of(type) {
        return new ResourceType(type);
    }
}
exports.ResourceType = ResourceType;
_e = JSII_RTTI_SYMBOL_1;
ResourceType[_e] = { fqn: "monocdk.aws_config.ResourceType", version: "1.106.1" };
/**
 * (experimental) API Gateway Stage.
 *
 * @experimental
 */
ResourceType.APIGATEWAY_STAGE = new ResourceType('AWS::ApiGateway::Stage');
/**
 * (experimental) API Gatewayv2 Stage.
 *
 * @experimental
 */
ResourceType.APIGATEWAYV2_STAGE = new ResourceType('AWS::ApiGatewayV2::Stage');
/**
 * (experimental) API Gateway REST API.
 *
 * @experimental
 */
ResourceType.APIGATEWAY_REST_API = new ResourceType('AWS::ApiGateway::RestApi');
/**
 * (experimental) API Gatewayv2 API.
 *
 * @experimental
 */
ResourceType.APIGATEWAYV2_API = new ResourceType('AWS::ApiGatewayV2::Api');
/**
 * (experimental) Amazon CloudFront Distribution.
 *
 * @experimental
 */
ResourceType.CLOUDFRONT_DISTRIBUTION = new ResourceType('AWS::CloudFront::Distribution');
/**
 * (experimental) Amazon CloudFront streaming distribution.
 *
 * @experimental
 */
ResourceType.CLOUDFRONT_STREAMING_DISTRIBUTION = new ResourceType('AWS::CloudFront::StreamingDistribution');
/**
 * (experimental) Amazon CloudWatch Alarm.
 *
 * @experimental
 */
ResourceType.CLOUDWATCH_ALARM = new ResourceType('AWS::CloudWatch::Alarm');
/**
 * (experimental) Amazon DynamoDB Table.
 *
 * @experimental
 */
ResourceType.DYNAMODB_TABLE = new ResourceType('AWS::DynamoDB::Table');
/**
 * (experimental) Elastic Block Store (EBS) volume.
 *
 * @experimental
 */
ResourceType.EBS_VOLUME = new ResourceType('AWS::EC2::Volume');
/**
 * (experimental) EC2 host.
 *
 * @experimental
 */
ResourceType.EC2_HOST = new ResourceType('AWS::EC2::Host');
/**
 * (experimental) EC2 Elastic IP.
 *
 * @experimental
 */
ResourceType.EC2_EIP = new ResourceType('AWS::EC2::EIP');
/**
 * (experimental) EC2 instance.
 *
 * @experimental
 */
ResourceType.EC2_INSTANCE = new ResourceType('AWS::EC2::Instance');
/**
 * (experimental) EC2 security group.
 *
 * @experimental
 */
ResourceType.EC2_SECURITY_GROUP = new ResourceType('AWS::EC2::SecurityGroup');
/**
 * (experimental) EC2 NAT gateway.
 *
 * @experimental
 */
ResourceType.EC2_NAT_GATEWAY = new ResourceType('AWS::EC2::NatGateway');
/**
 * (experimental) EC2 Egress only internet gateway.
 *
 * @experimental
 */
ResourceType.EC2_EGRESS_ONLY_INTERNET_GATEWAY = new ResourceType('AWS::EC2::EgressOnlyInternetGateway');
/**
 * (experimental) EC2 flow log.
 *
 * @experimental
 */
ResourceType.EC2_FLOW_LOG = new ResourceType('AWS::EC2::FlowLog');
/**
 * (experimental) EC2 VPC endpoint.
 *
 * @experimental
 */
ResourceType.EC2_VPC_ENDPOINT = new ResourceType('AWS::EC2::VPCEndpoint');
/**
 * (experimental) EC2 VPC endpoint service.
 *
 * @experimental
 */
ResourceType.EC2_VPC_ENDPOINT_SERVICE = new ResourceType('AWS::EC2::VPCEndpointService');
/**
 * (experimental) EC2 VPC peering connection.
 *
 * @experimental
 */
ResourceType.EC2_VPC_PEERING_CONNECTION = new ResourceType('AWS::EC2::VPCPeeringConnection');
/**
 * (experimental) Amazon ElasticSearch domain.
 *
 * @experimental
 */
ResourceType.ELASTICSEARCH_DOMAIN = new ResourceType('AWS::Elasticsearch::Domain');
/**
 * (experimental) Amazon QLDB ledger.
 *
 * @experimental
 */
ResourceType.QLDB_LEDGER = new ResourceType('AWS::QLDB::Ledger');
/**
 * (experimental) Amazon Redshift cluster.
 *
 * @experimental
 */
ResourceType.REDSHIFT_CLUSTER = new ResourceType('AWS::Redshift::Cluster');
/**
 * (experimental) Amazon Redshift cluster parameter group.
 *
 * @experimental
 */
ResourceType.REDSHIFT_CLUSTER_PARAMETER_GROUP = new ResourceType('AWS::Redshift::ClusterParameterGroup');
/**
 * (experimental) Amazon Redshift cluster security group.
 *
 * @experimental
 */
ResourceType.REDSHIFT_CLUSTER_SECURITY_GROUP = new ResourceType('AWS::Redshift::ClusterSecurityGroup');
/**
 * (experimental) Amazon Redshift cluster snapshot.
 *
 * @experimental
 */
ResourceType.REDSHIFT_CLUSTER_SNAPSHOT = new ResourceType('AWS::Redshift::ClusterSnapshot');
/**
 * (experimental) Amazon Redshift cluster subnet group.
 *
 * @experimental
 */
ResourceType.REDSHIFT_CLUSTER_SUBNET_GROUP = new ResourceType('AWS::Redshift::ClusterSubnetGroup');
/**
 * (experimental) Amazon Redshift event subscription.
 *
 * @experimental
 */
ResourceType.REDSHIFT_EVENT_SUBSCRIPTION = new ResourceType('AWS::Redshift::EventSubscription');
/**
 * (experimental) Amazon RDS database instance.
 *
 * @experimental
 */
ResourceType.RDS_DB_INSTANCE = new ResourceType('AWS::RDS::DBInstance');
/**
 * (experimental) Amazon RDS database security group.
 *
 * @experimental
 */
ResourceType.RDS_DB_SECURITY_GROUP = new ResourceType('AWS::RDS::DBSecurityGroup');
/**
 * (experimental) Amazon RDS database snapshot.
 *
 * @experimental
 */
ResourceType.RDS_DB_SNAPSHOT = new ResourceType('AWS::RDS::DBSnapshot');
/**
 * (experimental) Amazon RDS database subnet group.
 *
 * @experimental
 */
ResourceType.RDS_DB_SUBNET_GROUP = new ResourceType('AWS::RDS::DBSubnetGroup');
/**
 * (experimental) Amazon RDS event subscription.
 *
 * @experimental
 */
ResourceType.RDS_EVENT_SUBSCRIPTION = new ResourceType('AWS::RDS::EventSubscription');
/**
 * (experimental) Amazon RDS database cluster.
 *
 * @experimental
 */
ResourceType.RDS_DB_CLUSTER = new ResourceType('AWS::RDS::DBCluster');
/**
 * (experimental) Amazon RDS database cluster snapshot.
 *
 * @experimental
 */
ResourceType.RDS_DB_CLUSTER_SNAPSHOT = new ResourceType('AWS::RDS::DBClusterSnapshot');
/**
 * (experimental) Amazon SQS queue.
 *
 * @experimental
 */
ResourceType.SQS_QUEUE = new ResourceType('AWS::SQS::Queue');
/**
 * (experimental) Amazon SNS topic.
 *
 * @experimental
 */
ResourceType.SNS_TOPIC = new ResourceType('AWS::SNS::Topic');
/**
 * (experimental) Amazon S3 bucket.
 *
 * @experimental
 */
ResourceType.S3_BUCKET = new ResourceType('AWS::S3::Bucket');
/**
 * (experimental) Amazon S3 account public access block.
 *
 * @experimental
 */
ResourceType.S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = new ResourceType('AWS::S3::AccountPublicAccessBlock');
/**
 * (experimental) Amazon EC2 customer gateway.
 *
 * @experimental
 */
ResourceType.EC2_CUSTOMER_GATEWAY = new ResourceType('AWS::EC2::CustomerGateway');
/**
 * (experimental) Amazon EC2 internet gateway.
 *
 * @experimental
 */
ResourceType.EC2_INTERNET_GATEWAY = new ResourceType('AWS::EC2::CustomerGateway');
/**
 * (experimental) Amazon EC2 network ACL.
 *
 * @experimental
 */
ResourceType.EC2_NETWORK_ACL = new ResourceType('AWS::EC2::NetworkAcl');
/**
 * (experimental) Amazon EC2 route table.
 *
 * @experimental
 */
ResourceType.EC2_ROUTE_TABLE = new ResourceType('AWS::EC2::RouteTable');
/**
 * (experimental) Amazon EC2 subnet table.
 *
 * @experimental
 */
ResourceType.EC2_SUBNET = new ResourceType('AWS::EC2::Subnet');
/**
 * (experimental) Amazon EC2 VPC.
 *
 * @experimental
 */
ResourceType.EC2_VPC = new ResourceType('AWS::EC2::VPC');
/**
 * (experimental) Amazon EC2 VPN connection.
 *
 * @experimental
 */
ResourceType.EC2_VPN_CONNECTION = new ResourceType('AWS::EC2::VPNConnection');
/**
 * (experimental) Amazon EC2 VPN gateway.
 *
 * @experimental
 */
ResourceType.EC2_VPN_GATEWAY = new ResourceType('AWS::EC2::VPNGateway');
/**
 * (experimental) AWS Auto Scaling group.
 *
 * @experimental
 */
ResourceType.AUTO_SCALING_GROUP = new ResourceType('AWS::AutoScaling::AutoScalingGroup');
/**
 * (experimental) AWS Auto Scaling launch configuration.
 *
 * @experimental
 */
ResourceType.AUTO_SCALING_LAUNCH_CONFIGURATION = new ResourceType('AWS::AutoScaling::LaunchConfiguration');
/**
 * (experimental) AWS Auto Scaling policy.
 *
 * @experimental
 */
ResourceType.AUTO_SCALING_POLICY = new ResourceType('AWS::AutoScaling::ScalingPolicy');
/**
 * (experimental) AWS Auto Scaling scheduled action.
 *
 * @experimental
 */
ResourceType.AUTO_SCALING_SCHEDULED_ACTION = new ResourceType('AWS::AutoScaling::ScheduledAction');
/**
 * (experimental) AWS Certificate manager certificate.
 *
 * @experimental
 */
ResourceType.ACM_CERTIFICATE = new ResourceType('AWS::ACM::Certificate');
/**
 * (experimental) AWS CloudFormation stack.
 *
 * @experimental
 */
ResourceType.CLOUDFORMATION_STACK = new ResourceType('AWS::CloudFormation::Stack');
/**
 * (experimental) AWS CloudTrail trail.
 *
 * @experimental
 */
ResourceType.CLOUDTRAIL_TRAIL = new ResourceType('AWS::CloudTrail::Trail');
/**
 * (experimental) AWS CodeBuild project.
 *
 * @experimental
 */
ResourceType.CODEBUILD_PROJECT = new ResourceType('AWS::CodeBuild::Project');
/**
 * (experimental) AWS CodePipeline pipeline.
 *
 * @experimental
 */
ResourceType.CODEPIPELINE_PIPELINE = new ResourceType('AWS::CodePipeline::Pipeline');
/**
 * (experimental) AWS Elastic Beanstalk (EB) application.
 *
 * @experimental
 */
ResourceType.ELASTIC_BEANSTALK_APPLICATION = new ResourceType('AWS::ElasticBeanstalk::Application');
/**
 * (experimental) AWS Elastic Beanstalk (EB) application version.
 *
 * @experimental
 */
ResourceType.ELASTIC_BEANSTALK_APPLICATION_VERSION = new ResourceType('AWS::ElasticBeanstalk::ApplicationVersion');
/**
 * (experimental) AWS Elastic Beanstalk (EB) environment.
 *
 * @experimental
 */
ResourceType.ELASTIC_BEANSTALK_ENVIRONMENT = new ResourceType('AWS::ElasticBeanstalk::Environment');
/**
 * (experimental) AWS IAM user.
 *
 * @experimental
 */
ResourceType.IAM_USER = new ResourceType('AWS::IAM::User');
/**
 * (experimental) AWS IAM group.
 *
 * @experimental
 */
ResourceType.IAM_GROUP = new ResourceType('AWS::IAM::Group');
/**
 * (experimental) AWS IAM role.
 *
 * @experimental
 */
ResourceType.IAM_ROLE = new ResourceType('AWS::IAM::Role');
/**
 * (experimental) AWS IAM policy.
 *
 * @experimental
 */
ResourceType.IAM_POLICY = new ResourceType('AWS::IAM::Policy');
/**
 * (experimental) AWS KMS Key.
 *
 * @experimental
 */
ResourceType.KMS_KEY = new ResourceType('AWS::KMS::Key');
/**
 * (experimental) AWS Lambda function.
 *
 * @experimental
 */
ResourceType.LAMBDA_FUNCTION = new ResourceType('AWS::Lambda::Function');
/**
 * (experimental) AWS Secrets Manager secret.
 *
 * @experimental
 */
ResourceType.SECRETS_MANAGER_SECRET = new ResourceType('AWS::SecretsManager::Secret');
/**
 * (experimental) AWS Service Catalog CloudFormation product.
 *
 * @experimental
 */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProduct');
/**
 * (experimental) AWS Service Catalog CloudFormation provisioned product.
 *
 * @experimental
 */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProvisionedProduct');
/**
 * (experimental) AWS Service Catalog portfolio.
 *
 * @experimental
 */
ResourceType.SERVICE_CATALOG_PORTFOLIO = new ResourceType('AWS::ServiceCatalog::Portfolio');
/**
 * (experimental) AWS Shield protection.
 *
 * @experimental
 */
ResourceType.SHIELD_PROTECTION = new ResourceType('AWS::Shield::Protection');
/**
 * (experimental) AWS Shield regional protection.
 *
 * @experimental
 */
ResourceType.SHIELD_REGIONAL_PROTECTION = new ResourceType('AWS::ShieldRegional::Protection');
/**
 * (experimental) AWS Systems Manager managed instance inventory.
 *
 * @experimental
 */
ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = new ResourceType('AWS::SSM::ManagedInstanceInventory');
/**
 * (experimental) AWS Systems Manager patch compliance.
 *
 * @experimental
 */
ResourceType.SYSTEMS_MANAGER_PATCH_COMPLIANCE = new ResourceType('AWS::SSM::PatchCompliance');
/**
 * (experimental) AWS Systems Manager association compliance.
 *
 * @experimental
 */
ResourceType.SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = new ResourceType('AWS::SSM::AssociationCompliance');
/**
 * (experimental) AWS Systems Manager file data.
 *
 * @experimental
 */
ResourceType.SYSTEMS_MANAGER_FILE_DATA = new ResourceType('AWS::SSM::FileData');
/**
 * (experimental) AWS WAF rate based rule.
 *
 * @experimental
 */
ResourceType.WAF_RATE_BASED_RULE = new ResourceType('AWS::WAF::RateBasedRule');
/**
 * (experimental) AWS WAF rule.
 *
 * @experimental
 */
ResourceType.WAF_RULE = new ResourceType('AWS::WAF::Rule');
/**
 * (experimental) AWS WAF web ACL.
 *
 * @experimental
 */
ResourceType.WAF_WEB_ACL = new ResourceType('AWS::WAF::WebACL');
/**
 * (experimental) AWS WAF rule group.
 *
 * @experimental
 */
ResourceType.WAF_RULE_GROUP = new ResourceType('AWS::WAF::RuleGroup');
/**
 * (experimental) AWS WAF regional rate based rule.
 *
 * @experimental
 */
ResourceType.WAF_REGIONAL_RATE_BASED_RULE = new ResourceType('AWS::WAFRegional::RateBasedRule');
/**
 * (experimental) AWS WAF regional rule.
 *
 * @experimental
 */
ResourceType.WAF_REGIONAL_RULE = new ResourceType('AWS::WAFRegional::Rule');
/**
 * (experimental) AWS WAF web ACL.
 *
 * @experimental
 */
ResourceType.WAF_REGIONAL_WEB_ACL = new ResourceType('AWS::WAFRegional::WebACL');
/**
 * (experimental) AWS WAF regional rule group.
 *
 * @experimental
 */
ResourceType.WAF_REGIONAL_RULE_GROUP = new ResourceType('AWS::WAFRegional::RuleGroup');
/**
 * (experimental) AWS WAFv2 web ACL.
 *
 * @experimental
 */
ResourceType.WAFV2_WEB_ACL = new ResourceType('AWS::WAFv2::WebACL');
/**
 * (experimental) AWS WAFv2 rule group.
 *
 * @experimental
 */
ResourceType.WAFV2_RULE_GROUP = new ResourceType('AWS::WAFv2::RuleGroup');
/**
 * (experimental) AWS WAFv2 managed rule set.
 *
 * @experimental
 */
ResourceType.WAFV2_MANAGED_RULE_SET = new ResourceType('AWS::WAFv2::ManagedRuleSet');
/**
 * (experimental) AWS X-Ray encryption configuration.
 *
 * @experimental
 */
ResourceType.XRAY_ENCRYPTION_CONFIGURATION = new ResourceType('AWS::XRay::EncryptionConfig');
/**
 * (experimental) AWS ELB classic load balancer.
 *
 * @experimental
 */
ResourceType.ELB_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancing::LoadBalancer');
/**
 * (experimental) AWS ELBv2 network load balancer or AWS ELBv2 application load balancer.
 *
 * @experimental
 */
ResourceType.ELBV2_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancingV2::LoadBalancer');
function renderScope(ruleScope) {
    var _f;
    return ruleScope ? {
        complianceResourceId: ruleScope.resourceId,
        complianceResourceTypes: (_f = ruleScope.resourceTypes) === null || _f === void 0 ? void 0 : _f.map(resource => resource.complianceResourceType),
        tagKey: ruleScope.key,
        tagValue: ruleScope.value,
    } : undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJ1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBMkMsQ0FBQyxzREFBc0Q7QUFDbEcscUNBQXFDLENBQUMsbURBQW1EO0FBRXpGLHFDQUF1RCxDQUFDLGdEQUFnRDtBQUV4Ryx5REFBbUQ7QUF5Qm5EOztHQUVHO0FBQ0gsTUFBZSxRQUFTLFNBQVEsZUFBUTs7Ozs7Ozs7O0lBTTdCLE9BQU8sQ0FBQyxFQUFVLEVBQUUsVUFBaUMsRUFBRTtRQUMxRCxNQUFNLElBQUksR0FBRyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUNoRCxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQ2pCLE1BQU0sRUFBRSxDQUFDLFlBQVksQ0FBQztZQUN0QixNQUFNLEVBQUU7Z0JBQ0osY0FBYyxFQUFFLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQzthQUN4QztTQUNKLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2hCLENBQUM7Ozs7OztJQUlNLGtCQUFrQixDQUFDLEVBQVUsRUFBRSxVQUFpQyxFQUFFO1FBQ3JFLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDakIsVUFBVSxFQUFFLENBQUMsZ0NBQWdDLENBQUM7U0FDakQsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQzs7Ozs7O0lBSU0sb0JBQW9CLENBQUMsRUFBVSxFQUFFLFVBQWlDLEVBQUU7UUFDdkUsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDdkMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUNqQixVQUFVLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQztTQUNwRCxDQUFDLENBQUM7UUFDSCxPQUFPLElBQUksQ0FBQztJQUNoQixDQUFDO0NBQ0o7QUFDRDs7R0FFRztBQUNILE1BQWUsT0FBUSxTQUFRLFFBQVE7Ozs7Ozs7SUFNNUIsTUFBTSxDQUFDLGtCQUFrQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLGNBQXNCO1FBQ2pGLE1BQU0sTUFBTyxTQUFRLFFBQVE7WUFBN0I7O2dCQUNvQixtQkFBYyxHQUFHLGNBQWMsQ0FBQztZQUNwRCxDQUFDO1NBQUE7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNqQyxDQUFDO0NBZ0JKOzs7Ozs7QUFJRCxNQUFhLFNBQVM7SUFxQmxCLFlBQW9CLFVBQW1CLEVBQUUsYUFBOEIsRUFBRSxNQUFlLEVBQUUsUUFBaUI7UUFDdkcsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUM7UUFDN0IsSUFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUM7UUFDbEIsSUFBSSxDQUFDLEtBQUssR0FBRyxRQUFRLENBQUM7SUFDMUIsQ0FBQzs7Ozs7O0lBeEJNLE1BQU0sQ0FBQyxZQUFZLENBQUMsWUFBMEIsRUFBRSxVQUFtQjtRQUN0RSxPQUFPLElBQUksU0FBUyxDQUFDLFVBQVUsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDckQsQ0FBQzs7Ozs7O0lBRU0sTUFBTSxDQUFDLGFBQWEsQ0FBQyxhQUE2QjtRQUNyRCxPQUFPLElBQUksU0FBUyxDQUFDLFNBQVMsRUFBRSxhQUFhLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7SUFFTSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQVcsRUFBRSxLQUFjO1FBQzdDLE9BQU8sSUFBSSxTQUFTLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDM0QsQ0FBQzs7QUFaTCw4QkEyQkM7Ozs7Ozs7O0FBSUQsSUFBWSx5QkFxQlg7QUFyQkQsV0FBWSx5QkFBeUI7SUFJakMsa0RBQXFCLENBQUE7SUFJckIsd0RBQTJCLENBQUE7SUFJM0Isb0RBQXVCLENBQUE7SUFJdkIsMERBQTZCLENBQUE7SUFJN0IsbUVBQXNDLENBQUE7QUFDMUMsQ0FBQyxFQXJCVyx5QkFBeUIsR0FBekIsaUNBQXlCLEtBQXpCLGlDQUF5QixRQXFCcEM7Ozs7Ozs7QUFzREQsTUFBYSxXQUFZLFNBQVEsT0FBTzs7OztJQVNwQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2IsWUFBWSxFQUFFLEtBQUssQ0FBQyxjQUFjO1NBQ3JDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxNQUFNLElBQUksR0FBRyxJQUFJLGdDQUFhLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM3QyxjQUFjLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDakMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0Qyx5QkFBeUIsRUFBRSxLQUFLLENBQUMseUJBQXlCO1lBQzFELEtBQUssRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztZQUMvRCxNQUFNLEVBQUU7Z0JBQ0osS0FBSyxFQUFFLEtBQUs7Z0JBQ1osZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLFVBQVU7YUFDckM7U0FDSixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7UUFDL0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQzFDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDeEQsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7SUFDMUIsQ0FBQzs7QUE5Qkwsa0NBK0JDOzs7Ozs7Ozs7QUEyQkQsTUFBYSxVQUFXLFNBQVEsT0FBTzs7OztJQVNuQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXNCO1FBQzVELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2IsWUFBWSxFQUFFLEtBQUssQ0FBQyxjQUFjO1NBQ3JDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFO1lBQ2hELE1BQU0sSUFBSSxLQUFLLENBQUMsMkVBQTJFLENBQUMsQ0FBQztTQUNoRztRQUNELE1BQU0sYUFBYSxHQUFVLEVBQUUsQ0FBQztRQUNoQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxLQUFLLENBQUMsb0JBQW9CLEVBQUU7WUFDNUIsYUFBYSxDQUFDLElBQUksQ0FBQztnQkFDZixXQUFXLEVBQUUsWUFBWTtnQkFDekIsV0FBVyxFQUFFLHFDQUFxQzthQUNyRCxDQUFDLENBQUM7WUFDSCxhQUFhLENBQUMsSUFBSSxDQUFDO2dCQUNmLFdBQVcsRUFBRSxZQUFZO2dCQUN6QixXQUFXLEVBQUUsOENBQThDO2FBQzlELENBQUMsQ0FBQztTQUNOO1FBQ0QsSUFBSSxLQUFLLENBQUMsUUFBUSxFQUFFO1lBQ2hCLGFBQWEsQ0FBQyxJQUFJLENBQUM7Z0JBQ2YsV0FBVyxFQUFFLFlBQVk7Z0JBQ3pCLHlCQUF5QixFQUFFLEtBQUssQ0FBQyx5QkFBeUI7Z0JBQzFELFdBQVcsRUFBRSx1QkFBdUI7YUFDdkMsQ0FBQyxDQUFDO1NBQ047UUFDRCxLQUFLLENBQUMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxZQUFZLEVBQUU7WUFDN0MsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLHNCQUFzQixDQUFDO1NBQzlELENBQUMsQ0FBQztRQUNILElBQUksS0FBSyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUU7WUFDM0IsS0FBSyxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDLENBQUM7U0FDdEk7UUFDRCx3REFBd0Q7UUFDeEQsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQzlDLE1BQU0sSUFBSSxHQUFHLElBQUksZ0NBQWEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdDLGNBQWMsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUNqQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLHlCQUF5QixFQUFFLEtBQUssQ0FBQyx5QkFBeUI7WUFDMUQsS0FBSyxFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxDQUFDO1lBQy9ELE1BQU0sRUFBRTtnQkFDSixLQUFLLEVBQUUsZUFBZTtnQkFDdEIsYUFBYTtnQkFDYixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsY0FBYyxDQUFDLFdBQVc7YUFDckQ7U0FDSixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7UUFDL0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQzFDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDeEQsSUFBSSxLQUFLLENBQUMsb0JBQW9CLEVBQUU7WUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQztTQUNuQztJQUNMLENBQUM7O0FBOURMLGdDQStEQzs7Ozs7Ozs7O0FBS0QsTUFBYSxzQkFBc0I7SUFpMkIvQixnQkFBZ0I7SUFDaEIsZ0JBQXdCLENBQUM7O0FBbDJCN0Isd0RBbTJCQzs7Ozs7Ozs7O0FBNzFCMEIsNERBQXFDLEdBQUcsdUNBQXVDLENBQUM7Ozs7Ozs7QUFNaEYsOERBQXVDLEdBQUcseUNBQXlDLENBQUM7Ozs7Ozs7QUFLcEYsMENBQW1CLEdBQUcscUJBQXFCLENBQUM7Ozs7Ozs7QUFLNUMsb0RBQTZCLEdBQUcsK0JBQStCLENBQUM7Ozs7Ozs7QUFLaEUsdURBQWdDLEdBQUcsa0NBQWtDLENBQUM7Ozs7Ozs7QUFLdEUsMkRBQW9DLEdBQUcsc0NBQXNDLENBQUM7Ozs7Ozs7QUFLOUUsMERBQW1DLEdBQUcscUNBQXFDLENBQUM7Ozs7Ozs7QUFLNUUsc0NBQWUsR0FBRyxpQkFBaUIsQ0FBQzs7Ozs7OztBQUtwQyx5REFBa0MsR0FBRyxvQ0FBb0MsQ0FBQzs7Ozs7OztBQUsxRSxpREFBMEIsR0FBRyw0QkFBNEIsQ0FBQzs7Ozs7OztBQUsxRCx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSwwQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQzs7Ozs7OztBQUs1QywyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQzs7Ozs7OztBQU05QyxpRUFBMEMsR0FBRyw0Q0FBNEMsQ0FBQzs7Ozs7OztBQU0xRixpRUFBMEMsR0FBRyw0Q0FBNEMsQ0FBQzs7Ozs7OztBQUsxRiw4REFBdUMsR0FBRyx5Q0FBeUMsQ0FBQzs7Ozs7OztBQUtwRixnRUFBeUMsR0FBRywyQ0FBMkMsQ0FBQzs7Ozs7OztBQUt4RixnRUFBeUMsR0FBRywyQ0FBMkMsQ0FBQzs7Ozs7OztBQUt4Rix5REFBa0MsR0FBRyxvQ0FBb0MsQ0FBQzs7Ozs7OztBQU0xRSw2Q0FBc0IsR0FBRyx3QkFBd0IsQ0FBQzs7Ozs7OztBQUlsRCxxREFBOEIsR0FBRyxnQ0FBZ0MsQ0FBQzs7Ozs7OztBQUtsRSwyREFBb0MsR0FBRyxzQ0FBc0MsQ0FBQzs7Ozs7OztBQUs5RSwwQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQzs7Ozs7OztBQU01QyxxREFBOEIsR0FBRyxnQ0FBZ0MsQ0FBQzs7Ozs7OztBQUtsRSw4REFBdUMsR0FBRyx5Q0FBeUMsQ0FBQzs7Ozs7OztBQUtwRix1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSx3REFBaUMsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQU14RSxvREFBNkIsR0FBRywrQkFBK0IsQ0FBQzs7Ozs7OztBQUtoRSxzREFBK0IsR0FBRyxpQ0FBaUMsQ0FBQzs7Ozs7OztBQUtwRSxzREFBK0IsR0FBRyxpQ0FBaUMsQ0FBQzs7Ozs7OztBQU1wRSxxREFBOEIsR0FBRyxnQ0FBZ0MsQ0FBQzs7Ozs7OztBQU1sRSx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSw2REFBc0MsR0FBRyx3Q0FBd0MsQ0FBQzs7Ozs7OztBQU1sRiw4REFBdUMsR0FBRyx5Q0FBeUMsQ0FBQzs7Ozs7OztBQUtwRiwwREFBbUMsR0FBRyxxQ0FBcUMsQ0FBQzs7Ozs7OztBQU81RSx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSx5REFBa0MsR0FBRyxvQ0FBb0MsQ0FBQzs7Ozs7OztBQUsxRSw2Q0FBc0IsR0FBRyx3QkFBd0IsQ0FBQzs7Ozs7OztBQUtsRCxxREFBOEIsR0FBRyw0QkFBNEIsQ0FBQzs7Ozs7OztBQUs5RCxtREFBNEIsR0FBRywwQkFBMEIsQ0FBQzs7Ozs7OztBQUsxRCxnREFBeUIsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQUtwRCxpREFBMEIsR0FBRyw0QkFBNEIsQ0FBQzs7Ozs7OztBQUsxRCxtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCw4Q0FBdUIsR0FBRyx5QkFBeUIsQ0FBQzs7Ozs7OztBQUtwRCw0Q0FBcUIsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQUtoRCxtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCx3REFBaUMsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQUt4RSxzREFBK0IsR0FBRyxpQ0FBaUMsQ0FBQzs7Ozs7OztBQUtwRSx5Q0FBa0IsR0FBRyxvQkFBb0IsQ0FBQzs7Ozs7OztBQU0xQyx5Q0FBa0IsR0FBRyxvQkFBb0IsQ0FBQzs7Ozs7OztBQUsxQyxvREFBNkIsR0FBRywrQkFBK0IsQ0FBQzs7Ozs7OztBQUtoRSw2Q0FBc0IsR0FBRyx3QkFBd0IsQ0FBQzs7Ozs7OztBQUtsRCwyREFBb0MsR0FBRyxzQ0FBc0MsQ0FBQzs7Ozs7OztBQUs5RSwrREFBd0MsR0FBRywwQ0FBMEMsQ0FBQzs7Ozs7OztBQUt0RixrREFBMkIsR0FBRyw2QkFBNkIsQ0FBQzs7Ozs7OztBQUs1RCxnREFBeUIsR0FBRywyQkFBMkIsQ0FBQzs7Ozs7OztBQUt4RCwyQ0FBb0IsR0FBRyxrQkFBa0IsQ0FBQzs7Ozs7OztBQUsxQyxnRUFBeUMsR0FBRyw4Q0FBOEMsQ0FBQzs7Ozs7OztBQUszRixpRUFBMEMsR0FBRywyQ0FBMkMsQ0FBQzs7Ozs7OztBQU16RiwrRUFBd0QsR0FBRyx5REFBeUQsQ0FBQzs7Ozs7OztBQUtySCw2REFBc0MsR0FBRywyQ0FBMkMsQ0FBQzs7Ozs7OztBQU1yRix5RUFBa0QsR0FBRyxtREFBbUQsQ0FBQzs7Ozs7OztBQUt6RywwREFBbUMsR0FBRyxvQ0FBb0MsQ0FBQzs7Ozs7OztBQU0zRSx5REFBa0MsR0FBRyxvQ0FBb0MsQ0FBQzs7Ozs7OztBQUsxRSwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQzs7Ozs7OztBQUs5Qyw2Q0FBc0IsR0FBRyx3QkFBd0IsQ0FBQzs7Ozs7OztBQU1sRCwwQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQzs7Ozs7OztBQU01QyxtQ0FBWSxHQUFHLGNBQWMsQ0FBQzs7Ozs7OztBQU05QixzREFBK0IsR0FBRyxpQ0FBaUMsQ0FBQzs7Ozs7OztBQU1wRSxnREFBeUIsR0FBRywyQkFBMkIsQ0FBQzs7Ozs7OztBQUt4RCx1RUFBZ0QsR0FBRyxrREFBa0QsQ0FBQzs7Ozs7OztBQU10Ryx1Q0FBZ0IsR0FBRyxrQkFBa0IsQ0FBQzs7Ozs7OztBQUt0QyxvREFBNkIsR0FBRywrQkFBK0IsQ0FBQzs7Ozs7OztBQU1oRSw0Q0FBcUIsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQUtoRCxrRUFBMkMsR0FBRyw2Q0FBNkMsQ0FBQzs7Ozs7OztBQUs1Riw0REFBcUMsR0FBRyx1Q0FBdUMsQ0FBQzs7Ozs7OztBQUtoRixtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCxtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCwyREFBb0MsR0FBRyxzQ0FBc0MsQ0FBQzs7Ozs7OztBQUs5RSxzREFBK0IsR0FBRyxpQ0FBaUMsQ0FBQzs7Ozs7OztBQUtwRSwwQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQzs7Ozs7OztBQUs1QywrREFBd0MsR0FBRywwQ0FBMEMsQ0FBQzs7Ozs7OztBQUt0RiwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQzs7Ozs7OztBQUs5Qyw4Q0FBdUIsR0FBRyx5QkFBeUIsQ0FBQzs7Ozs7OztBQUtwRCw0Q0FBcUIsR0FBRyxtQkFBbUIsQ0FBQzs7Ozs7OztBQU01Qyw0REFBcUMsR0FBRyx1Q0FBdUMsQ0FBQzs7Ozs7OztBQUtoRix1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSxvRUFBNkMsR0FBRywrQ0FBK0MsQ0FBQzs7Ozs7OztBQU1oRyx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQU10RSx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7Ozs7O0FBTXRFLDZEQUFzQyxHQUFHLHdDQUF3QyxDQUFDOzs7Ozs7Ozs7O0FBTWxGLG9EQUE2QixHQUFHLCtCQUErQixDQUFDOzs7Ozs7O0FBS2hFLHNEQUErQixHQUFHLGlDQUFpQyxDQUFDOzs7Ozs7O0FBS3BFLGlEQUEwQixHQUFHLDRCQUE0QixDQUFDOzs7Ozs7O0FBSzFELGdEQUF5QixHQUFHLDJCQUEyQixDQUFDOzs7Ozs7O0FBTXhELDBDQUFtQixHQUFHLHFCQUFxQixDQUFDOzs7Ozs7O0FBSzVDLCtDQUF3QixHQUFHLDhCQUE4QixDQUFDOzs7Ozs7O0FBTTFELHdDQUFpQixHQUFHLG1CQUFtQixDQUFDOzs7Ozs7O0FBS3hDLGlFQUEwQyxHQUFHLDRDQUE0QyxDQUFDOzs7Ozs7O0FBSzFGLG9EQUE2QixHQUFHLCtCQUErQixDQUFDOzs7Ozs7O0FBS2hFLGdEQUF5QixHQUFHLDJCQUEyQixDQUFDOzs7Ozs7O0FBS3hELHNEQUErQixHQUFHLGlDQUFpQyxDQUFDOzs7Ozs7O0FBS3BFLDJDQUFvQixHQUFHLHNCQUFzQixDQUFDOzs7Ozs7Ozs7QUFLOUMsaURBQTBCLEdBQUcsNEJBQTRCLENBQUM7Ozs7Ozs7QUFNMUQsd0RBQWlDLEdBQUcsbUNBQW1DLENBQUM7Ozs7Ozs7QUFLeEUsMkRBQW9DLEdBQUcsc0NBQXNDLENBQUM7Ozs7Ozs7QUFLOUUseURBQWtDLEdBQUcsb0NBQW9DLENBQUM7Ozs7Ozs7QUFLMUUsK0NBQXdCLEdBQUcsMEJBQTBCLENBQUM7Ozs7Ozs7QUFLdEQsdUNBQWdCLEdBQUcsa0JBQWtCLENBQUM7Ozs7Ozs7QUFLdEMsK0RBQXdDLEdBQUcsMENBQTBDLENBQUM7Ozs7Ozs7QUFLdEYscURBQThCLEdBQUcsZ0NBQWdDLENBQUM7Ozs7Ozs7QUFLbEUsd0NBQWlCLEdBQUcsbUJBQW1CLENBQUM7Ozs7Ozs7QUFLeEMseURBQWtDLEdBQUcsb0NBQW9DLENBQUM7Ozs7Ozs7QUFLMUUsc0RBQStCLEdBQUcsa0NBQWtDLENBQUM7Ozs7Ozs7QUFLckUsOERBQXVDLEdBQUcseUNBQXlDLENBQUM7Ozs7Ozs7QUFLcEYsK0RBQXdDLEdBQUcsMENBQTBDLENBQUM7Ozs7Ozs7QUFLdEYsOERBQXVDLEdBQUcseUNBQXlDLENBQUM7Ozs7Ozs7QUFLcEYsMENBQW1CLEdBQUcscUJBQXFCLENBQUM7Ozs7Ozs7QUFLNUMsOENBQXVCLEdBQUcseUJBQXlCLENBQUM7Ozs7Ozs7QUFLcEQsc0RBQStCLEdBQUcsaUNBQWlDLENBQUM7Ozs7Ozs7QUFLcEUsNkNBQXNCLEdBQUcsd0JBQXdCLENBQUM7Ozs7Ozs7QUFLbEQsK0NBQXdCLEdBQUcsMEJBQTBCLENBQUM7Ozs7Ozs7QUFLdEQseUNBQWtCLEdBQUcsb0JBQW9CLENBQUM7Ozs7Ozs7QUFLMUMsdURBQWdDLEdBQUcsa0NBQWtDLENBQUM7Ozs7Ozs7QUFLdEUsMkNBQW9CLEdBQUcsc0JBQXNCLENBQUM7Ozs7Ozs7QUFLOUMsc0RBQStCLEdBQUcsaUNBQWlDLENBQUM7Ozs7Ozs7QUFLcEUsNENBQXFCLEdBQUcsdUJBQXVCLENBQUM7Ozs7Ozs7QUFLaEQsMkRBQW9DLEdBQUcsc0NBQXNDLENBQUM7Ozs7Ozs7QUFLOUUsa0VBQTJDLEdBQUcsNENBQTRDLENBQUM7Ozs7Ozs7QUFLM0YsMkRBQW9DLEdBQUcsc0NBQXNDLENBQUM7Ozs7Ozs7OztBQU05RSxvQ0FBYSxHQUFHLGVBQWUsQ0FBQzs7Ozs7OztBQUtoQyxzRUFBK0MsR0FBRyw2QkFBNkIsQ0FBQzs7Ozs7OztBQUtoRixnRUFBeUMsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQU1wRSx3REFBaUMsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQU14RSwrQ0FBd0IsR0FBRywwQkFBMEIsQ0FBQzs7Ozs7OztBQUt0RCxxREFBOEIsR0FBRyxnQ0FBZ0MsQ0FBQzs7Ozs7OztBQU1sRSxnREFBeUIsR0FBRywyQkFBMkIsQ0FBQzs7Ozs7OztBQUt4RCwwQ0FBbUIsR0FBRyxxQkFBcUIsQ0FBQzs7Ozs7OztBQUs1Qyx3Q0FBaUIsR0FBRyxtQkFBbUIsQ0FBQzs7Ozs7OztBQUt4Qyw0REFBcUMsR0FBRyx1Q0FBdUMsQ0FBQzs7Ozs7OztBQU9oRiwyREFBb0MsR0FBRywwQ0FBMEMsQ0FBQzs7Ozs7OztBQU1sRiwyREFBb0MsR0FBRyxzQ0FBc0MsQ0FBQzs7Ozs7OztBQUs5RSxnREFBeUIsR0FBRywyQkFBMkIsQ0FBQzs7Ozs7OztBQU14RCxxREFBOEIsR0FBRyxnQ0FBZ0MsQ0FBQzs7Ozs7OztBQUtsRSx1REFBZ0MsR0FBRyxrQ0FBa0MsQ0FBQzs7Ozs7OztBQUt0RSx3REFBaUMsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQUt4RSxvREFBNkIsR0FBRywrQkFBK0IsQ0FBQzs7Ozs7OztBQU9oRSwrREFBd0MsR0FBRywwQ0FBMEMsQ0FBQzs7Ozs7OztBQUt0RixrREFBMkIsR0FBRyw2QkFBNkIsQ0FBQzs7Ozs7OztBQUs1RCxtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCwwRUFBbUQsR0FBRyxxREFBcUQsQ0FBQzs7Ozs7OztBQUs1RyxxRUFBOEMsR0FBRyxnREFBZ0QsQ0FBQzs7Ozs7OztBQUtsRyxtRUFBNEMsR0FBRyw4Q0FBOEMsQ0FBQzs7Ozs7OztBQUs5Riw0REFBcUMsR0FBRyx1Q0FBdUMsQ0FBQzs7Ozs7OztBQUtoRixzRUFBK0MsR0FBRyxpREFBaUQsQ0FBQzs7Ozs7OztBQUtwRyxtREFBNEIsR0FBRyw4QkFBOEIsQ0FBQzs7Ozs7OztBQUs5RCx5REFBa0MsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQUt6RSx3Q0FBaUIsR0FBRyxtQkFBbUIsQ0FBQzs7Ozs7Ozs7OztBQU94Qyx3REFBaUMsR0FBRyxtQ0FBbUMsQ0FBQzs7Ozs7OztBQUt4RSw0Q0FBcUIsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQU1oRCwyREFBb0MsR0FBRyxzQ0FBc0MsQ0FBQzs7Ozs7OztBQU05RSwyQ0FBb0IsR0FBRyxzQkFBc0IsQ0FBQzs7Ozs7OztBQUs5QyxrREFBMkIsR0FBRyw2QkFBNkIsQ0FBQzs7Ozs7OztBQU01RCw0Q0FBcUIsR0FBRyx1QkFBdUIsQ0FBQzs7Ozs7OztBQVEzRSxNQUFhLFlBQVk7SUF5THJCLFlBQW9CLElBQVk7UUFDNUIsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQztJQUN2QyxDQUFDOzs7Ozs7SUFUTSxNQUFNLENBQUMsRUFBRSxDQUFDLElBQVk7UUFDekIsT0FBTyxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNsQyxDQUFDOztBQXBMTCxvQ0E0TEM7Ozs7Ozs7O0FBMUwwQiw2QkFBZ0IsR0FBRyxJQUFJLFlBQVksQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUQsK0JBQWtCLEdBQUcsSUFBSSxZQUFZLENBQUMsMEJBQTBCLENBQUMsQ0FBQzs7Ozs7O0FBRWxFLGdDQUFtQixHQUFHLElBQUksWUFBWSxDQUFDLDBCQUEwQixDQUFDLENBQUM7Ozs7OztBQUVuRSw2QkFBZ0IsR0FBRyxJQUFJLFlBQVksQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUQsb0NBQXVCLEdBQUcsSUFBSSxZQUFZLENBQUMsK0JBQStCLENBQUMsQ0FBQzs7Ozs7O0FBRTVFLDhDQUFpQyxHQUFHLElBQUksWUFBWSxDQUFDLHdDQUF3QyxDQUFDLENBQUM7Ozs7OztBQUUvRiw2QkFBZ0IsR0FBRyxJQUFJLFlBQVksQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUQsMkJBQWMsR0FBRyxJQUFJLFlBQVksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDOzs7Ozs7QUFFMUQsdUJBQVUsR0FBRyxJQUFJLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDOzs7Ozs7QUFFbEQscUJBQVEsR0FBRyxJQUFJLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUMsb0JBQU8sR0FBRyxJQUFJLFlBQVksQ0FBQyxlQUFlLENBQUMsQ0FBQzs7Ozs7O0FBRTVDLHlCQUFZLEdBQUcsSUFBSSxZQUFZLENBQUMsb0JBQW9CLENBQUMsQ0FBQzs7Ozs7O0FBRXRELCtCQUFrQixHQUFHLElBQUksWUFBWSxDQUFDLHlCQUF5QixDQUFDLENBQUM7Ozs7OztBQUVqRSw0QkFBZSxHQUFHLElBQUksWUFBWSxDQUFDLHNCQUFzQixDQUFDLENBQUM7Ozs7OztBQUUzRCw2Q0FBZ0MsR0FBRyxJQUFJLFlBQVksQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDOzs7Ozs7QUFFM0YseUJBQVksR0FBRyxJQUFJLFlBQVksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDOzs7Ozs7QUFFckQsNkJBQWdCLEdBQUcsSUFBSSxZQUFZLENBQUMsdUJBQXVCLENBQUMsQ0FBQzs7Ozs7O0FBRTdELHFDQUF3QixHQUFHLElBQUksWUFBWSxDQUFDLDhCQUE4QixDQUFDLENBQUM7Ozs7OztBQUU1RSx1Q0FBMEIsR0FBRyxJQUFJLFlBQVksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDOzs7Ozs7QUFFaEYsaUNBQW9CLEdBQUcsSUFBSSxZQUFZLENBQUMsNEJBQTRCLENBQUMsQ0FBQzs7Ozs7O0FBRXRFLHdCQUFXLEdBQUcsSUFBSSxZQUFZLENBQUMsbUJBQW1CLENBQUMsQ0FBQzs7Ozs7O0FBRXBELDZCQUFnQixHQUFHLElBQUksWUFBWSxDQUFDLHdCQUF3QixDQUFDLENBQUM7Ozs7OztBQUU5RCw2Q0FBZ0MsR0FBRyxJQUFJLFlBQVksQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDOzs7Ozs7QUFFNUYsNENBQStCLEdBQUcsSUFBSSxZQUFZLENBQUMscUNBQXFDLENBQUMsQ0FBQzs7Ozs7O0FBRTFGLHNDQUF5QixHQUFHLElBQUksWUFBWSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7Ozs7OztBQUUvRSwwQ0FBNkIsR0FBRyxJQUFJLFlBQVksQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDOzs7Ozs7QUFFdEYsd0NBQTJCLEdBQUcsSUFBSSxZQUFZLENBQUMsa0NBQWtDLENBQUMsQ0FBQzs7Ozs7O0FBRW5GLDRCQUFlLEdBQUcsSUFBSSxZQUFZLENBQUMsc0JBQXNCLENBQUMsQ0FBQzs7Ozs7O0FBRTNELGtDQUFxQixHQUFHLElBQUksWUFBWSxDQUFDLDJCQUEyQixDQUFDLENBQUM7Ozs7OztBQUV0RSw0QkFBZSxHQUFHLElBQUksWUFBWSxDQUFDLHNCQUFzQixDQUFDLENBQUM7Ozs7OztBQUUzRCxnQ0FBbUIsR0FBRyxJQUFJLFlBQVksQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDOzs7Ozs7QUFFbEUsbUNBQXNCLEdBQUcsSUFBSSxZQUFZLENBQUMsNkJBQTZCLENBQUMsQ0FBQzs7Ozs7O0FBRXpFLDJCQUFjLEdBQUcsSUFBSSxZQUFZLENBQUMscUJBQXFCLENBQUMsQ0FBQzs7Ozs7O0FBRXpELG9DQUF1QixHQUFHLElBQUksWUFBWSxDQUFDLDZCQUE2QixDQUFDLENBQUM7Ozs7OztBQUUxRSxzQkFBUyxHQUFHLElBQUksWUFBWSxDQUFDLGlCQUFpQixDQUFDLENBQUM7Ozs7OztBQUVoRCxzQkFBUyxHQUFHLElBQUksWUFBWSxDQUFDLGlCQUFpQixDQUFDLENBQUM7Ozs7OztBQUVoRCxzQkFBUyxHQUFHLElBQUksWUFBWSxDQUFDLGlCQUFpQixDQUFDLENBQUM7Ozs7OztBQUVoRCwyQ0FBOEIsR0FBRyxJQUFJLFlBQVksQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDOzs7Ozs7QUFFdkYsaUNBQW9CLEdBQUcsSUFBSSxZQUFZLENBQUMsMkJBQTJCLENBQUMsQ0FBQzs7Ozs7O0FBRXJFLGlDQUFvQixHQUFHLElBQUksWUFBWSxDQUFDLDJCQUEyQixDQUFDLENBQUM7Ozs7OztBQUVyRSw0QkFBZSxHQUFHLElBQUksWUFBWSxDQUFDLHNCQUFzQixDQUFDLENBQUM7Ozs7OztBQUUzRCw0QkFBZSxHQUFHLElBQUksWUFBWSxDQUFDLHNCQUFzQixDQUFDLENBQUM7Ozs7OztBQUUzRCx1QkFBVSxHQUFHLElBQUksWUFBWSxDQUFDLGtCQUFrQixDQUFDLENBQUM7Ozs7OztBQUVsRCxvQkFBTyxHQUFHLElBQUksWUFBWSxDQUFDLGVBQWUsQ0FBQyxDQUFDOzs7Ozs7QUFFNUMsK0JBQWtCLEdBQUcsSUFBSSxZQUFZLENBQUMseUJBQXlCLENBQUMsQ0FBQzs7Ozs7O0FBRWpFLDRCQUFlLEdBQUcsSUFBSSxZQUFZLENBQUMsc0JBQXNCLENBQUMsQ0FBQzs7Ozs7O0FBRTNELCtCQUFrQixHQUFHLElBQUksWUFBWSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7Ozs7OztBQUU1RSw4Q0FBaUMsR0FBRyxJQUFJLFlBQVksQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDOzs7Ozs7QUFFOUYsZ0NBQW1CLEdBQUcsSUFBSSxZQUFZLENBQUMsaUNBQWlDLENBQUMsQ0FBQzs7Ozs7O0FBRTFFLDBDQUE2QixHQUFHLElBQUksWUFBWSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7Ozs7OztBQUV0Riw0QkFBZSxHQUFHLElBQUksWUFBWSxDQUFDLHVCQUF1QixDQUFDLENBQUM7Ozs7OztBQUU1RCxpQ0FBb0IsR0FBRyxJQUFJLFlBQVksQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDOzs7Ozs7QUFFdEUsNkJBQWdCLEdBQUcsSUFBSSxZQUFZLENBQUMsd0JBQXdCLENBQUMsQ0FBQzs7Ozs7O0FBRTlELDhCQUFpQixHQUFHLElBQUksWUFBWSxDQUFDLHlCQUF5QixDQUFDLENBQUM7Ozs7OztBQUVoRSxrQ0FBcUIsR0FBRyxJQUFJLFlBQVksQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDOzs7Ozs7QUFFeEUsMENBQTZCLEdBQUcsSUFBSSxZQUFZLENBQUMsb0NBQW9DLENBQUMsQ0FBQzs7Ozs7O0FBRXZGLGtEQUFxQyxHQUFHLElBQUksWUFBWSxDQUFDLDJDQUEyQyxDQUFDLENBQUM7Ozs7OztBQUV0RywwQ0FBNkIsR0FBRyxJQUFJLFlBQVksQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDOzs7Ozs7QUFFdkYscUJBQVEsR0FBRyxJQUFJLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUMsc0JBQVMsR0FBRyxJQUFJLFlBQVksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDOzs7Ozs7QUFFaEQscUJBQVEsR0FBRyxJQUFJLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUMsdUJBQVUsR0FBRyxJQUFJLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDOzs7Ozs7QUFFbEQsb0JBQU8sR0FBRyxJQUFJLFlBQVksQ0FBQyxlQUFlLENBQUMsQ0FBQzs7Ozs7O0FBRTVDLDRCQUFlLEdBQUcsSUFBSSxZQUFZLENBQUMsdUJBQXVCLENBQUMsQ0FBQzs7Ozs7O0FBRTVELG1DQUFzQixHQUFHLElBQUksWUFBWSxDQUFDLDZCQUE2QixDQUFDLENBQUM7Ozs7OztBQUV6RSxtREFBc0MsR0FBRyxJQUFJLFlBQVksQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDOzs7Ozs7QUFFeEcsK0RBQWtELEdBQUcsSUFBSSxZQUFZLENBQUMsdURBQXVELENBQUMsQ0FBQzs7Ozs7O0FBRS9ILHNDQUF5QixHQUFHLElBQUksWUFBWSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7Ozs7OztBQUUvRSw4QkFBaUIsR0FBRyxJQUFJLFlBQVksQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDOzs7Ozs7QUFFaEUsdUNBQTBCLEdBQUcsSUFBSSxZQUFZLENBQUMsaUNBQWlDLENBQUMsQ0FBQzs7Ozs7O0FBRWpGLHVEQUEwQyxHQUFHLElBQUksWUFBWSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7Ozs7OztBQUVwRyw2Q0FBZ0MsR0FBRyxJQUFJLFlBQVksQ0FBQywyQkFBMkIsQ0FBQyxDQUFDOzs7Ozs7QUFFakYsbURBQXNDLEdBQUcsSUFBSSxZQUFZLENBQUMsaUNBQWlDLENBQUMsQ0FBQzs7Ozs7O0FBRTdGLHNDQUF5QixHQUFHLElBQUksWUFBWSxDQUFDLG9CQUFvQixDQUFDLENBQUM7Ozs7OztBQUVuRSxnQ0FBbUIsR0FBRyxJQUFJLFlBQVksQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDOzs7Ozs7QUFFbEUscUJBQVEsR0FBRyxJQUFJLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDOzs7Ozs7QUFFOUMsd0JBQVcsR0FBRyxJQUFJLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDOzs7Ozs7QUFFbkQsMkJBQWMsR0FBRyxJQUFJLFlBQVksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDOzs7Ozs7QUFFekQseUNBQTRCLEdBQUcsSUFBSSxZQUFZLENBQUMsaUNBQWlDLENBQUMsQ0FBQzs7Ozs7O0FBRW5GLDhCQUFpQixHQUFHLElBQUksWUFBWSxDQUFDLHdCQUF3QixDQUFDLENBQUM7Ozs7OztBQUUvRCxpQ0FBb0IsR0FBRyxJQUFJLFlBQVksQ0FBQywwQkFBMEIsQ0FBQyxDQUFDOzs7Ozs7QUFFcEUsb0NBQXVCLEdBQUcsSUFBSSxZQUFZLENBQUMsNkJBQTZCLENBQUMsQ0FBQzs7Ozs7O0FBRTFFLDBCQUFhLEdBQUcsSUFBSSxZQUFZLENBQUMsb0JBQW9CLENBQUMsQ0FBQzs7Ozs7O0FBRXZELDZCQUFnQixHQUFHLElBQUksWUFBWSxDQUFDLHVCQUF1QixDQUFDLENBQUM7Ozs7OztBQUU3RCxtQ0FBc0IsR0FBRyxJQUFJLFlBQVksQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDOzs7Ozs7QUFFeEUsMENBQTZCLEdBQUcsSUFBSSxZQUFZLENBQUMsNkJBQTZCLENBQUMsQ0FBQzs7Ozs7O0FBRWhGLDhCQUFpQixHQUFHLElBQUksWUFBWSxDQUFDLHlDQUF5QyxDQUFDLENBQUM7Ozs7OztBQUVoRixnQ0FBbUIsR0FBRyxJQUFJLFlBQVksQ0FBQywyQ0FBMkMsQ0FBQyxDQUFDO0FBYS9HLFNBQVMsV0FBVyxDQUFDLFNBQXFCOztJQUN0QyxPQUFPLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFDZixvQkFBb0IsRUFBRSxTQUFTLENBQUMsVUFBVTtRQUMxQyx1QkFBdUIsUUFBRSxTQUFTLENBQUMsYUFBYSwwQ0FBRSxHQUFHLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsc0JBQXNCLENBQUM7UUFDbEcsTUFBTSxFQUFFLFNBQVMsQ0FBQyxHQUFHO1FBQ3JCLFFBQVEsRUFBRSxTQUFTLENBQUMsS0FBSztLQUM1QixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7QUFDbEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGV2ZW50cyBmcm9tIFwiLi4vLi4vYXdzLWV2ZW50c1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cydcbmltcG9ydCAqIGFzIGlhbSBmcm9tIFwiLi4vLi4vYXdzLWlhbVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSdcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCB7IElSZXNvdXJjZSwgTGF6eSwgUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuQ29uZmlnUnVsZSB9IGZyb20gJy4vY29uZmlnLmdlbmVyYXRlZCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElSdWxlIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGNvbmZpZ1J1bGVOYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIG9uRXZlbnQoaWQ6IHN0cmluZywgb3B0aW9ucz86IGV2ZW50cy5PbkV2ZW50T3B0aW9ucyk6IGV2ZW50cy5SdWxlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBvbkNvbXBsaWFuY2VDaGFuZ2UoaWQ6IHN0cmluZywgb3B0aW9ucz86IGV2ZW50cy5PbkV2ZW50T3B0aW9ucyk6IGV2ZW50cy5SdWxlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgb25SZUV2YWx1YXRpb25TdGF0dXMoaWQ6IHN0cmluZywgb3B0aW9ucz86IGV2ZW50cy5PbkV2ZW50T3B0aW9ucyk6IGV2ZW50cy5SdWxlO1xufVxuLyoqXG4gKiBBIG5ldyBvciBpbXBvcnRlZCBydWxlLlxuICovXG5hYnN0cmFjdCBjbGFzcyBSdWxlQmFzZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVJ1bGUge1xuICAgIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBjb25maWdSdWxlTmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgb25FdmVudChpZDogc3RyaW5nLCBvcHRpb25zOiBldmVudHMuT25FdmVudE9wdGlvbnMgPSB7fSkge1xuICAgICAgICBjb25zdCBydWxlID0gbmV3IGV2ZW50cy5SdWxlKHRoaXMsIGlkLCBvcHRpb25zKTtcbiAgICAgICAgcnVsZS5hZGRFdmVudFBhdHRlcm4oe1xuICAgICAgICAgICAgc291cmNlOiBbJ2F3cy5jb25maWcnXSxcbiAgICAgICAgICAgIGRldGFpbDoge1xuICAgICAgICAgICAgICAgIGNvbmZpZ1J1bGVOYW1lOiBbdGhpcy5jb25maWdSdWxlTmFtZV0sXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICAgICAgcnVsZS5hZGRUYXJnZXQob3B0aW9ucy50YXJnZXQpO1xuICAgICAgICByZXR1cm4gcnVsZTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgb25Db21wbGlhbmNlQ2hhbmdlKGlkOiBzdHJpbmcsIG9wdGlvbnM6IGV2ZW50cy5PbkV2ZW50T3B0aW9ucyA9IHt9KTogZXZlbnRzLlJ1bGUge1xuICAgICAgICBjb25zdCBydWxlID0gdGhpcy5vbkV2ZW50KGlkLCBvcHRpb25zKTtcbiAgICAgICAgcnVsZS5hZGRFdmVudFBhdHRlcm4oe1xuICAgICAgICAgICAgZGV0YWlsVHlwZTogWydDb25maWcgUnVsZXMgQ29tcGxpYW5jZSBDaGFuZ2UnXSxcbiAgICAgICAgfSk7XG4gICAgICAgIHJldHVybiBydWxlO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgb25SZUV2YWx1YXRpb25TdGF0dXMoaWQ6IHN0cmluZywgb3B0aW9uczogZXZlbnRzLk9uRXZlbnRPcHRpb25zID0ge30pOiBldmVudHMuUnVsZSB7XG4gICAgICAgIGNvbnN0IHJ1bGUgPSB0aGlzLm9uRXZlbnQoaWQsIG9wdGlvbnMpO1xuICAgICAgICBydWxlLmFkZEV2ZW50UGF0dGVybih7XG4gICAgICAgICAgICBkZXRhaWxUeXBlOiBbJ0NvbmZpZyBSdWxlcyBSZS1ldmFsdWF0aW9uIFN0YXR1cyddLFxuICAgICAgICB9KTtcbiAgICAgICAgcmV0dXJuIHJ1bGU7XG4gICAgfVxufVxuLyoqXG4gKiBBIG5ldyBtYW5hZ2VkIG9yIGN1c3RvbSBydWxlLlxuICovXG5hYnN0cmFjdCBjbGFzcyBSdWxlTmV3IGV4dGVuZHMgUnVsZUJhc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBmcm9tQ29uZmlnUnVsZU5hbWUoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnUnVsZU5hbWU6IHN0cmluZyk6IElSdWxlIHtcbiAgICAgICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUnVsZUJhc2Uge1xuICAgICAgICAgICAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ1J1bGVOYW1lID0gY29uZmlnUnVsZU5hbWU7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogVGhlIGFybiBvZiB0aGUgcnVsZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgY29uZmlnUnVsZUFybjogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBpZCBvZiB0aGUgcnVsZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgY29uZmlnUnVsZUlkOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGNvbXBsaWFuY2Ugc3RhdHVzIG9mIHRoZSBydWxlLlxuICAgICAqL1xuICAgIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBjb25maWdSdWxlQ29tcGxpYW5jZVR5cGU6IHN0cmluZztcbiAgICBwcm90ZWN0ZWQgcnVsZVNjb3BlPzogUnVsZVNjb3BlO1xuICAgIHByb3RlY3RlZCBpc01hbmFnZWQ/OiBib29sZWFuO1xuICAgIHByb3RlY3RlZCBpc0N1c3RvbVdpdGhDaGFuZ2VzPzogYm9vbGVhbjtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBSdWxlU2NvcGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgZnJvbVJlc291cmNlKHJlc291cmNlVHlwZTogUmVzb3VyY2VUeXBlLCByZXNvdXJjZUlkPzogc3RyaW5nKSB7XG4gICAgICAgIHJldHVybiBuZXcgUnVsZVNjb3BlKHJlc291cmNlSWQsIFtyZXNvdXJjZVR5cGVdKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBmcm9tUmVzb3VyY2VzKHJlc291cmNlVHlwZXM6IFJlc291cmNlVHlwZVtdKSB7XG4gICAgICAgIHJldHVybiBuZXcgUnVsZVNjb3BlKHVuZGVmaW5lZCwgcmVzb3VyY2VUeXBlcyk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgZnJvbVRhZyhrZXk6IHN0cmluZywgdmFsdWU/OiBzdHJpbmcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBSdWxlU2NvcGUodW5kZWZpbmVkLCB1bmRlZmluZWQsIGtleSwgdmFsdWUpO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VUeXBlcz86IFJlc291cmNlVHlwZVtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VJZD86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG4gICAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihyZXNvdXJjZUlkPzogc3RyaW5nLCByZXNvdXJjZVR5cGVzPzogUmVzb3VyY2VUeXBlW10sIHRhZ0tleT86IHN0cmluZywgdGFnVmFsdWU/OiBzdHJpbmcpIHtcbiAgICAgICAgdGhpcy5yZXNvdXJjZVR5cGVzID0gcmVzb3VyY2VUeXBlcztcbiAgICAgICAgdGhpcy5yZXNvdXJjZUlkID0gcmVzb3VyY2VJZDtcbiAgICAgICAgdGhpcy5rZXkgPSB0YWdLZXk7XG4gICAgICAgIHRoaXMudmFsdWUgPSB0YWdWYWx1ZTtcbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBNYXhpbXVtRXhlY3V0aW9uRnJlcXVlbmN5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIE9ORV9IT1VSID0gJ09uZV9Ib3VyJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBUSFJFRV9IT1VSUyA9ICdUaHJlZV9Ib3VycycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgU0lYX0hPVVJTID0gJ1NpeF9Ib3VycycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIFRXRUxWRV9IT1VSUyA9ICdUd2VsdmVfSG91cnMnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBUV0VOVFlfRk9VUl9IT1VSUyA9ICdUd2VudHlGb3VyX0hvdXJzJ1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUnVsZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBjb25maWdSdWxlTmFtZT86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaW5wdXRQYXJhbWV0ZXJzPzoge1xuICAgICAgICBba2V5OiBzdHJpbmddOiBhbnk7XG4gICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgbWF4aW11bUV4ZWN1dGlvbkZyZXF1ZW5jeT86IE1heGltdW1FeGVjdXRpb25GcmVxdWVuY3k7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IHJ1bGVTY29wZT86IFJ1bGVTY29wZTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE1hbmFnZWRSdWxlUHJvcHMgZXh0ZW5kcyBSdWxlUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaWRlbnRpZmllcjogc3RyaW5nO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIE1hbmFnZWRSdWxlIGV4dGVuZHMgUnVsZU5ldyB7XG4gICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnUnVsZU5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZWFkb25seSBjb25maWdSdWxlQXJuOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnUnVsZUlkOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnUnVsZUNvbXBsaWFuY2VUeXBlOiBzdHJpbmc7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE1hbmFnZWRSdWxlUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAgICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmNvbmZpZ1J1bGVOYW1lLFxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5ydWxlU2NvcGUgPSBwcm9wcy5ydWxlU2NvcGU7XG4gICAgICAgIGNvbnN0IHJ1bGUgPSBuZXcgQ2ZuQ29uZmlnUnVsZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBjb25maWdSdWxlTmFtZTogdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICAgICAgICBpbnB1dFBhcmFtZXRlcnM6IHByb3BzLmlucHV0UGFyYW1ldGVycyxcbiAgICAgICAgICAgIG1heGltdW1FeGVjdXRpb25GcmVxdWVuY3k6IHByb3BzLm1heGltdW1FeGVjdXRpb25GcmVxdWVuY3ksXG4gICAgICAgICAgICBzY29wZTogTGF6eS5hbnkoeyBwcm9kdWNlOiAoKSA9PiByZW5kZXJTY29wZSh0aGlzLnJ1bGVTY29wZSkgfSksXG4gICAgICAgICAgICBzb3VyY2U6IHtcbiAgICAgICAgICAgICAgICBvd25lcjogJ0FXUycsXG4gICAgICAgICAgICAgICAgc291cmNlSWRlbnRpZmllcjogcHJvcHMuaWRlbnRpZmllcixcbiAgICAgICAgICAgIH0sXG4gICAgICAgIH0pO1xuICAgICAgICB0aGlzLmNvbmZpZ1J1bGVOYW1lID0gcnVsZS5yZWY7XG4gICAgICAgIHRoaXMuY29uZmlnUnVsZUFybiA9IHJ1bGUuYXR0ckFybjtcbiAgICAgICAgdGhpcy5jb25maWdSdWxlSWQgPSBydWxlLmF0dHJDb25maWdSdWxlSWQ7XG4gICAgICAgIHRoaXMuY29uZmlnUnVsZUNvbXBsaWFuY2VUeXBlID0gcnVsZS5hdHRyQ29tcGxpYW5jZVR5cGU7XG4gICAgICAgIHRoaXMuaXNNYW5hZ2VkID0gdHJ1ZTtcbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEN1c3RvbVJ1bGVQcm9wcyBleHRlbmRzIFJ1bGVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuSUZ1bmN0aW9uO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBjb25maWd1cmF0aW9uQ2hhbmdlcz86IGJvb2xlYW47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcGVyaW9kaWM/OiBib29sZWFuO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQ3VzdG9tUnVsZSBleHRlbmRzIFJ1bGVOZXcge1xuICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ1J1bGVOYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnUnVsZUFybjogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ1J1bGVJZDogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlYWRvbmx5IGNvbmZpZ1J1bGVDb21wbGlhbmNlVHlwZTogc3RyaW5nO1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDdXN0b21SdWxlUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAgICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmNvbmZpZ1J1bGVOYW1lLFxuICAgICAgICB9KTtcbiAgICAgICAgaWYgKCFwcm9wcy5jb25maWd1cmF0aW9uQ2hhbmdlcyAmJiAhcHJvcHMucGVyaW9kaWMpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignQXQgbGVhc3Qgb25lIG9mIGBjb25maWd1cmF0aW9uQ2hhbmdlc2Agb3IgYHBlcmlvZGljYCBtdXN0IGJlIHNldCB0byB0cnVlLicpO1xuICAgICAgICB9XG4gICAgICAgIGNvbnN0IHNvdXJjZURldGFpbHM6IGFueVtdID0gW107XG4gICAgICAgIHRoaXMucnVsZVNjb3BlID0gcHJvcHMucnVsZVNjb3BlO1xuICAgICAgICBpZiAocHJvcHMuY29uZmlndXJhdGlvbkNoYW5nZXMpIHtcbiAgICAgICAgICAgIHNvdXJjZURldGFpbHMucHVzaCh7XG4gICAgICAgICAgICAgICAgZXZlbnRTb3VyY2U6ICdhd3MuY29uZmlnJyxcbiAgICAgICAgICAgICAgICBtZXNzYWdlVHlwZTogJ0NvbmZpZ3VyYXRpb25JdGVtQ2hhbmdlTm90aWZpY2F0aW9uJyxcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgc291cmNlRGV0YWlscy5wdXNoKHtcbiAgICAgICAgICAgICAgICBldmVudFNvdXJjZTogJ2F3cy5jb25maWcnLFxuICAgICAgICAgICAgICAgIG1lc3NhZ2VUeXBlOiAnT3ZlcnNpemVkQ29uZmlndXJhdGlvbkl0ZW1DaGFuZ2VOb3RpZmljYXRpb24nLFxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHByb3BzLnBlcmlvZGljKSB7XG4gICAgICAgICAgICBzb3VyY2VEZXRhaWxzLnB1c2goe1xuICAgICAgICAgICAgICAgIGV2ZW50U291cmNlOiAnYXdzLmNvbmZpZycsXG4gICAgICAgICAgICAgICAgbWF4aW11bUV4ZWN1dGlvbkZyZXF1ZW5jeTogcHJvcHMubWF4aW11bUV4ZWN1dGlvbkZyZXF1ZW5jeSxcbiAgICAgICAgICAgICAgICBtZXNzYWdlVHlwZTogJ1NjaGVkdWxlZE5vdGlmaWNhdGlvbicsXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICBwcm9wcy5sYW1iZGFGdW5jdGlvbi5hZGRQZXJtaXNzaW9uKCdQZXJtaXNzaW9uJywge1xuICAgICAgICAgICAgcHJpbmNpcGFsOiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2NvbmZpZy5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAocHJvcHMubGFtYmRhRnVuY3Rpb24ucm9sZSkge1xuICAgICAgICAgICAgcHJvcHMubGFtYmRhRnVuY3Rpb24ucm9sZS5hZGRNYW5hZ2VkUG9saWN5KGlhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZSgnc2VydmljZS1yb2xlL0FXU0NvbmZpZ1J1bGVzRXhlY3V0aW9uUm9sZScpKTtcbiAgICAgICAgfVxuICAgICAgICAvLyBUaGUgbGFtYmRhIHBlcm1pc3Npb24gbXVzdCBiZSBjcmVhdGVkIGJlZm9yZSB0aGUgcnVsZVxuICAgICAgICB0aGlzLm5vZGUuYWRkRGVwZW5kZW5jeShwcm9wcy5sYW1iZGFGdW5jdGlvbik7XG4gICAgICAgIGNvbnN0IHJ1bGUgPSBuZXcgQ2ZuQ29uZmlnUnVsZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBjb25maWdSdWxlTmFtZTogdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICAgICAgICBpbnB1dFBhcmFtZXRlcnM6IHByb3BzLmlucHV0UGFyYW1ldGVycyxcbiAgICAgICAgICAgIG1heGltdW1FeGVjdXRpb25GcmVxdWVuY3k6IHByb3BzLm1heGltdW1FeGVjdXRpb25GcmVxdWVuY3ksXG4gICAgICAgICAgICBzY29wZTogTGF6eS5hbnkoeyBwcm9kdWNlOiAoKSA9PiByZW5kZXJTY29wZSh0aGlzLnJ1bGVTY29wZSkgfSksXG4gICAgICAgICAgICBzb3VyY2U6IHtcbiAgICAgICAgICAgICAgICBvd25lcjogJ0NVU1RPTV9MQU1CREEnLFxuICAgICAgICAgICAgICAgIHNvdXJjZURldGFpbHMsXG4gICAgICAgICAgICAgICAgc291cmNlSWRlbnRpZmllcjogcHJvcHMubGFtYmRhRnVuY3Rpb24uZnVuY3Rpb25Bcm4sXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5jb25maWdSdWxlTmFtZSA9IHJ1bGUucmVmO1xuICAgICAgICB0aGlzLmNvbmZpZ1J1bGVBcm4gPSBydWxlLmF0dHJBcm47XG4gICAgICAgIHRoaXMuY29uZmlnUnVsZUlkID0gcnVsZS5hdHRyQ29uZmlnUnVsZUlkO1xuICAgICAgICB0aGlzLmNvbmZpZ1J1bGVDb21wbGlhbmNlVHlwZSA9IHJ1bGUuYXR0ckNvbXBsaWFuY2VUeXBlO1xuICAgICAgICBpZiAocHJvcHMuY29uZmlndXJhdGlvbkNoYW5nZXMpIHtcbiAgICAgICAgICAgIHRoaXMuaXNDdXN0b21XaXRoQ2hhbmdlcyA9IHRydWU7XG4gICAgICAgIH1cbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBNYW5hZ2VkUnVsZUlkZW50aWZpZXJzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9JTkxJTkVfUE9MSUNZX0JMT0NLRURfS01TX0FDVElPTlMgPSAnSUFNX0lOTElORV9QT0xJQ1lfQkxPQ0tFRF9LTVNfQUNUSU9OUyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSUFNX0NVU1RPTUVSX1BPTElDWV9CTE9DS0VEX0tNU19BQ1RJT05TID0gJ0lBTV9DVVNUT01FUl9QT0xJQ1lfQkxPQ0tFRF9LTVNfQUNUSU9OUyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFDQ0VTU19LRVlTX1JPVEFURUQgPSAnQUNDRVNTX0tFWVNfUk9UQVRFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFDQ09VTlRfUEFSVF9PRl9PUkdBTklaQVRJT05TID0gJ0FDQ09VTlRfUEFSVF9PRl9PUkdBTklaQVRJT05TJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUNNX0NFUlRJRklDQVRFX0VYUElSQVRJT05fQ0hFQ0sgPSAnQUNNX0NFUlRJRklDQVRFX0VYUElSQVRJT05fQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUxCX0hUVFBfRFJPUF9JTlZBTElEX0hFQURFUl9FTkFCTEVEID0gJ0FMQl9IVFRQX0RST1BfSU5WQUxJRF9IRUFERVJfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUxCX0hUVFBfVE9fSFRUUFNfUkVESVJFQ1RJT05fQ0hFQ0sgPSAnQUxCX0hUVFBfVE9fSFRUUFNfUkVESVJFQ1RJT05fQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUxCX1dBRl9FTkFCTEVEID0gJ0FMQl9XQUZfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUElfR1dfQ0FDSEVfRU5BQkxFRF9BTkRfRU5DUllQVEVEID0gJ0FQSV9HV19DQUNIRV9FTkFCTEVEX0FORF9FTkNSWVBURUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUElfR1dfRU5EUE9JTlRfVFlQRV9DSEVDSyA9ICdBUElfR1dfRU5EUE9JTlRfVFlQRV9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUElfR1dfRVhFQ1VUSU9OX0xPR0dJTkdfRU5BQkxFRCA9ICdBUElfR1dfRVhFQ1VUSU9OX0xPR0dJTkdfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUFBST1ZFRF9BTUlTX0JZX0lEID0gJ0FQUFJPVkVEX0FNSVNfQllfSUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQUFJPVkVEX0FNSVNfQllfVEFHID0gJ0FQUFJPVkVEX0FNSVNfQllfVEFHJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVVRPU0NBTElOR19HUk9VUF9FTEJfSEVBTFRIQ0hFQ0tfUkVRVUlSRUQgPSAnQVVUT1NDQUxJTkdfR1JPVVBfRUxCX0hFQUxUSENIRUNLX1JFUVVJUkVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERk9STUFUSU9OX1NUQUNLX0RSSUZUX0RFVEVDVElPTl9DSEVDSyA9ICdDTE9VREZPUk1BVElPTl9TVEFDS19EUklGVF9ERVRFQ1RJT05fQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERk9STUFUSU9OX1NUQUNLX05PVElGSUNBVElPTl9DSEVDSyA9ICdDTE9VREZPUk1BVElPTl9TVEFDS19OT1RJRklDQVRJT05fQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfREVGQVVMVF9ST09UX09CSkVDVF9DT05GSUdVUkVEID0gJ0NMT1VERlJPTlRfREVGQVVMVF9ST09UX09CSkVDVF9DT05GSUdVUkVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfT1JJR0lOX0FDQ0VTU19JREVOVElUWV9FTkFCTEVEID0gJ0NMT1VERlJPTlRfT1JJR0lOX0FDQ0VTU19JREVOVElUWV9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfT1JJR0lOX0ZBSUxPVkVSX0VOQUJMRUQgPSAnQ0xPVURGUk9OVF9PUklHSU5fRkFJTE9WRVJfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfU05JX0VOQUJMRUQgPSAnQ0xPVURGUk9OVF9TTklfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURGUk9OVF9WSUVXRVJfUE9MSUNZX0hUVFBTID0gJ0NMT1VERlJPTlRfVklFV0VSX1BPTElDWV9IVFRQUyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEX1RSQUlMX0NMT1VEX1dBVENIX0xPR1NfRU5BQkxFRCA9ICdDTE9VRF9UUkFJTF9DTE9VRF9XQVRDSF9MT0dTX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRF9UUkFJTF9FTkFCTEVEID0gJ0NMT1VEX1RSQUlMX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEX1RSQUlMX0VOQ1JZUFRJT05fRU5BQkxFRCA9ICdDTE9VRF9UUkFJTF9FTkNSWVBUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VEX1RSQUlMX0xPR19GSUxFX1ZBTElEQVRJT05fRU5BQkxFRCA9ICdDTE9VRF9UUkFJTF9MT0dfRklMRV9WQUxJREFUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFRSQUlMX1MzX0RBVEFFVkVOVFNfRU5BQkxFRCA9ICdDTE9VRFRSQUlMX1MzX0RBVEFFVkVOVFNfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFRSQUlMX1NFQ1VSSVRZX1RSQUlMX0VOQUJMRUQgPSAnQ0xPVURUUkFJTF9TRUNVUklUWV9UUkFJTF9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFdBVENIX0FMQVJNX0FDVElPTl9DSEVDSyA9ICdDTE9VRFdBVENIX0FMQVJNX0FDVElPTl9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFdBVENIX0FMQVJNX1JFU09VUkNFX0NIRUNLID0gJ0NMT1VEV0FUQ0hfQUxBUk1fUkVTT1VSQ0VfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9BTEFSTV9TRVRUSU5HU19DSEVDSyA9ICdDTE9VRFdBVENIX0FMQVJNX1NFVFRJTkdTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0xPVURXQVRDSF9MT0dfR1JPVVBfRU5DUllQVEVEID0gJ0NMT1VEV0FUQ0hfTE9HX0dST1VQX0VOQ1JZUFRFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTUtfQkFDS0lOR19LRVlfUk9UQVRJT05fRU5BQkxFRCA9ICdDTUtfQkFDS0lOR19LRVlfUk9UQVRJT05fRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFQlVJTERfUFJPSkVDVF9FTlZWQVJfQVdTQ1JFRF9DSEVDSyA9ICdDT0RFQlVJTERfUFJPSkVDVF9FTlZWQVJfQVdTQ1JFRF9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVCVUlMRF9QUk9KRUNUX1NPVVJDRV9SRVBPX1VSTF9DSEVDSyA9ICdDT0RFQlVJTERfUFJPSkVDVF9TT1VSQ0VfUkVQT19VUkxfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVQSVBFTElORV9ERVBMT1lNRU5UX0NPVU5UX0NIRUNLID0gJ0NPREVQSVBFTElORV9ERVBMT1lNRU5UX0NPVU5UX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDT0RFUElQRUxJTkVfUkVHSU9OX0ZBTk9VVF9DSEVDSyA9ICdDT0RFUElQRUxJTkVfUkVHSU9OX0ZBTk9VVF9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENXX0xPR0dST1VQX1JFVEVOVElPTl9QRVJJT0RfQ0hFQ0sgPSAnQ1dfTE9HR1JPVVBfUkVURU5USU9OX1BFUklPRF9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgREFYX0VOQ1JZUFRJT05fRU5BQkxFRCA9ICdEQVhfRU5DUllQVElPTl9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX0lOU1RBTkNFX0JBQ0tVUF9FTkFCTEVEID0gJ0RCX0lOU1RBTkNFX0JBQ0tVUF9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfREVTSVJFRF9JTlNUQU5DRV9URU5BTkNZID0gJ0RFU0lSRURfSU5TVEFOQ0VfVEVOQU5DWSc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9ERVNJUkVEX0lOU1RBTkNFX1RZUEUgPSAnREVTSVJFRF9JTlNUQU5DRV9UWVBFJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBETVNfUkVQTElDQVRJT05fTk9UX1BVQkxJQyA9ICdETVNfUkVQTElDQVRJT05fTk9UX1BVQkxJQyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCX0FVVE9TQ0FMSU5HX0VOQUJMRUQgPSAnRFlOQU1PREJfQVVUT1NDQUxJTkdfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCX0lOX0JBQ0tVUF9QTEFOID0gJ0RZTkFNT0RCX0lOX0JBQ0tVUF9QTEFOJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCX1BJVFJfRU5BQkxFRCA9ICdEWU5BTU9EQl9QSVRSX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRFlOQU1PREJfVEFCTEVfRU5DUllQVEVEX0tNUyA9ICdEWU5BTU9EQl9UQUJMRV9FTkNSWVBURURfS01TJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCX1RBQkxFX0VOQ1JZUFRJT05fRU5BQkxFRCA9ICdEWU5BTU9EQl9UQUJMRV9FTkNSWVBUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRFlOQU1PREJfVEhST1VHSFBVVF9MSU1JVF9DSEVDSyA9ICdEWU5BTU9EQl9USFJPVUdIUFVUX0xJTUlUX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVCU19JTl9CQUNLVVBfUExBTiA9ICdFQlNfSU5fQkFDS1VQX1BMQU4nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUZTX0lOX0JBQ0tVUF9QTEFOID0gJ0VGU19JTl9CQUNLVVBfUExBTic7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9FQlNfRU5DUllQVElPTl9CWV9ERUZBVUxUID0gJ0VDMl9FQlNfRU5DUllQVElPTl9CWV9ERUZBVUxUJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQlNfT1BUSU1JWkVEX0lOU1RBTkNFID0gJ0VCU19PUFRJTUlaRURfSU5TVEFOQ0UnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUJTX1NOQVBTSE9UX1BVQkxJQ19SRVNUT1JBQkxFX0NIRUNLID0gJ0VCU19TTkFQU0hPVF9QVUJMSUNfUkVTVE9SQUJMRV9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfSU5TVEFOQ0VfREVUQUlMRURfTU9OSVRPUklOR19FTkFCTEVEID0gJ0VDMl9JTlNUQU5DRV9ERVRBSUxFRF9NT05JVE9SSU5HX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfSU5TVEFOQ0VfTUFOQUdFRF9CWV9TU00gPSAnRUMyX0lOU1RBTkNFX01BTkFHRURfQllfU1NNJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX0lOU1RBTkNFX05PX1BVQkxJQ19JUCA9ICdFQzJfSU5TVEFOQ0VfTk9fUFVCTElDX0lQJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX0lOU1RBTkNFU19JTl9WUEMgPSAnSU5TVEFOQ0VTX0lOX1ZQQyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9NQU5BR0VEX0lOU1RBTkNFX0FQUExJQ0FUSU9OU19CTE9DS0VEID0gJ0VDMl9NQU5BR0VESU5TVEFOQ0VfQVBQTElDQVRJT05TX0JMQUNLTElTVEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfTUFOQUdFRF9JTlNUQU5DRV9BUFBMSUNBVElPTlNfUkVRVUlSRUQgPSAnRUMyX01BTkFHRURJTlNUQU5DRV9BUFBMSUNBVElPTlNfUkVRVUlSRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfTUFOQUdFRF9JTlNUQU5DRV9BU1NPQ0lBVElPTl9DT01QTElBTkNFX1NUQVRVU19DSEVDSyA9ICdFQzJfTUFOQUdFRElOU1RBTkNFX0FTU09DSUFUSU9OX0NPTVBMSUFOQ0VfU1RBVFVTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfTUFOQUdFRF9JTlNUQU5DRV9JTlZFTlRPUllfQkxPQ0tFRCA9ICdFQzJfTUFOQUdFRElOU1RBTkNFX0lOVkVOVE9SWV9CTEFDS0xJU1RFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX01BTkFHRURfSU5TVEFOQ0VfUEFUQ0hfQ09NUExJQU5DRV9TVEFUVVNfQ0hFQ0sgPSAnRUMyX01BTkFHRURJTlNUQU5DRV9QQVRDSF9DT01QTElBTkNFX1NUQVRVU19DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9NQU5BR0VEX0lOU1RBTkNFX1BMQVRGT1JNX0NIRUNLID0gJ0VDMl9NQU5BR0VESU5TVEFOQ0VfUExBVEZPUk1fQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfU0VDVVJJVFlfR1JPVVBfQVRUQUNIRURfVE9fRU5JID0gJ0VDMl9TRUNVUklUWV9HUk9VUF9BVFRBQ0hFRF9UT19FTkknO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1NUT1BQRURfSU5TVEFOQ0UgPSAnRUMyX1NUT1BQRURfSU5TVEFOQ0UnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfVk9MVU1FX0lOVVNFX0NIRUNLID0gJ0VDMl9WT0xVTUVfSU5VU0VfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVGU19FTkNSWVBURURfQ0hFQ0sgPSAnRUZTX0VOQ1JZUFRFRF9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFSVBfQVRUQUNIRUQgPSAnRUlQX0FUVEFDSEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ1NFQVJDSF9FTkNSWVBURURfQVRfUkVTVCA9ICdFTEFTVElDU0VBUkNIX0VOQ1JZUFRFRF9BVF9SRVNUJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ1NFQVJDSF9JTl9WUENfT05MWSA9ICdFTEFTVElDU0VBUkNIX0lOX1ZQQ19PTkxZJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ0FDSEVfUkVESVNfQ0xVU1RFUl9BVVRPTUFUSUNfQkFDS1VQX0NIRUNLID0gJ0VMQVNUSUNBQ0hFX1JFRElTX0NMVVNURVJfQVVUT01BVElDX0JBQ0tVUF9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9JTURTVjJfQ0hFQ0sgPSAnRUMyX0lNRFNWMl9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVLU19FTkRQT0lOVF9OT19QVUJMSUNfQUNDRVNTID0gJ0VLU19FTkRQT0lOVF9OT19QVUJMSUNfQUNDRVNTJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVLU19TRUNSRVRTX0VOQ1JZUFRFRCA9ICdFS1NfU0VDUkVUU19FTkNSWVBURUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQVNUSUNTRUFSQ0hfTk9ERV9UT19OT0RFX0VOQ1JZUFRJT05fQ0hFQ0sgPSAnRUxBU1RJQ1NFQVJDSF9OT0RFX1RPX05PREVfRU5DUllQVElPTl9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEJfQ1JPU1NfWk9ORV9MT0FEX0JBTEFOQ0lOR19FTkFCTEVEID0gJ0VMQl9DUk9TU19aT05FX0xPQURfQkFMQU5DSU5HX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEJfVExTX0hUVFBTX0xJU1RFTkVSU19PTkxZID0gJ0VMQl9UTFNfSFRUUFNfTElTVEVORVJTX09OTFknO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEJfQUNNX0NFUlRJRklDQVRFX1JFUVVJUkVEID0gJ0VMQl9BQ01fQ0VSVElGSUNBVEVfUkVRVUlSRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEJfQ1VTVE9NX1NFQ1VSSVRZX1BPTElDWV9TU0xfQ0hFQ0sgPSAnRUxCX0NVU1RPTV9TRUNVUklUWV9QT0xJQ1lfU1NMX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQl9ERUxFVElPTl9QUk9URUNUSU9OX0VOQUJMRUQgPSAnRUxCX0RFTEVUSU9OX1BST1RFQ1RJT05fRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQl9MT0dHSU5HX0VOQUJMRUQgPSAnRUxCX0xPR0dJTkdfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxCX1BSRURFRklORURfU0VDVVJJVFlfUE9MSUNZX1NTTF9DSEVDSyA9ICdFTEJfUFJFREVGSU5FRF9TRUNVUklUWV9QT0xJQ1lfU1NMX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVNUl9LRVJCRVJPU19FTkFCTEVEID0gJ0VNUl9LRVJCRVJPU19FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTVJfTUFTVEVSX05PX1BVQkxJQ19JUCA9ICdFTVJfTUFTVEVSX05PX1BVQkxJQ19JUCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQlNfRU5DUllQVEVEX1ZPTFVNRVMgPSAnRU5DUllQVEVEX1ZPTFVNRVMnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZNU19TRUNVUklUWV9HUk9VUF9BVURJVF9QT0xJQ1lfQ0hFQ0sgPSAnRk1TX1NFQ1VSSVRZX0dST1VQX0FVRElUX1BPTElDWV9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZNU19TRUNVUklUWV9HUk9VUF9DT05URU5UX0NIRUNLID0gJ0ZNU19TRUNVUklUWV9HUk9VUF9DT05URU5UX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBGTVNfU0VDVVJJVFlfR1JPVVBfUkVTT1VSQ0VfQVNTT0NJQVRJT05fQ0hFQ0sgPSAnRk1TX1NFQ1VSSVRZX0dST1VQX1JFU09VUkNFX0FTU09DSUFUSU9OX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZNU19TSElFTERfUkVTT1VSQ0VfUE9MSUNZX0NIRUNLID0gJ0ZNU19TSElFTERfUkVTT1VSQ0VfUE9MSUNZX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRk1TX1dFQkFDTF9SRVNPVVJDRV9QT0xJQ1lfQ0hFQ0sgPSAnRk1TX1dFQkFDTF9SRVNPVVJDRV9QT0xJQ1lfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZNU19XRUJBQ0xfUlVMRUdST1VQX0FTU09DSUFUSU9OX0NIRUNLID0gJ0ZNU19XRUJBQ0xfUlVMRUdST1VQX0FTU09DSUFUSU9OX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdVQVJERFVUWV9FTkFCTEVEX0NFTlRSQUxJWkVEID0gJ0dVQVJERFVUWV9FTkFCTEVEX0NFTlRSQUxJWkVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBHVUFSRERVVFlfTk9OX0FSQ0hJVkVEX0ZJTkRJTkdTID0gJ0dVQVJERFVUWV9OT05fQVJDSElWRURfRklORElOR1MnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSUFNX05PX0lOTElORV9QT0xJQ1lfQ0hFQ0sgPSAnSUFNX05PX0lOTElORV9QT0xJQ1lfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9HUk9VUF9IQVNfVVNFUlNfQ0hFQ0sgPSAnSUFNX0dST1VQX0hBU19VU0VSU19DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSUFNX1BBU1NXT1JEX1BPTElDWSA9ICdJQU1fUEFTU1dPUkRfUE9MSUNZJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9QT0xJQ1lfQkxPQ0tFRF9DSEVDSyA9ICdJQU1fUE9MSUNZX0JMQUNLTElTVEVEX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fUE9MSUNZX0lOX1VTRSA9ICdJQU1fUE9MSUNZX0lOX1VTRSc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fUE9MSUNZX05PX1NUQVRFTUVOVFNfV0lUSF9BRE1JTl9BQ0NFU1MgPSAnSUFNX1BPTElDWV9OT19TVEFURU1FTlRTX1dJVEhfQURNSU5fQUNDRVNTJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9ST0xFX01BTkFHRURfUE9MSUNZX0NIRUNLID0gJ0lBTV9ST0xFX01BTkFHRURfUE9MSUNZX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fUk9PVF9BQ0NFU1NfS0VZX0NIRUNLID0gJ0lBTV9ST09UX0FDQ0VTU19LRVlfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fVVNFUl9HUk9VUF9NRU1CRVJTSElQX0NIRUNLID0gJ0lBTV9VU0VSX0dST1VQX01FTUJFUlNISVBfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fVVNFUl9NRkFfRU5BQkxFRCA9ICdJQU1fVVNFUl9NRkFfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9VU0VSX05PX1BPTElDSUVTX0NIRUNLID0gJ0lBTV9VU0VSX05PX1BPTElDSUVTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSUFNX1VTRVJfVU5VU0VEX0NSRURFTlRJQUxTX0NIRUNLID0gJ0lBTV9VU0VSX1VOVVNFRF9DUkVERU5USUFMU19DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSU5URVJORVRfR0FURVdBWV9BVVRIT1JJWkVEX1ZQQ19PTkxZID0gJ0lOVEVSTkVUX0dBVEVXQVlfQVVUSE9SSVpFRF9WUENfT05MWSc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgS01TX0NNS19OT1RfU0NIRURVTEVEX0ZPUl9ERUxFVElPTiA9ICdLTVNfQ01LX05PVF9TQ0hFRFVMRURfRk9SX0RFTEVUSU9OJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEFNQkRBX0NPTkNVUlJFTkNZX0NIRUNLID0gJ0xBTUJEQV9DT05DVVJSRU5DWV9DSEVDSyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEFNQkRBX0RMUV9DSEVDSyA9ICdMQU1CREFfRExRX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTEFNQkRBX0ZVTkNUSU9OX1BVQkxJQ19BQ0NFU1NfUFJPSElCSVRFRCA9ICdMQU1CREFfRlVOQ1RJT05fUFVCTElDX0FDQ0VTU19QUk9ISUJJVEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBMQU1CREFfRlVOQ1RJT05fU0VUVElOR1NfQ0hFQ0sgPSAnTEFNQkRBX0ZVTkNUSU9OX1NFVFRJTkdTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBMQU1CREFfSU5TSURFX1ZQQyA9ICdMQU1CREFfSU5TSURFX1ZQQyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTUZBX0VOQUJMRURfRk9SX0lBTV9DT05TT0xFX0FDQ0VTUyA9ICdNRkFfRU5BQkxFRF9GT1JfSUFNX0NPTlNPTEVfQUNDRVNTJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFRSQUlMX01VTFRJX1JFR0lPTl9FTkFCTEVEID0gJ01VTFRJX1JFR0lPTl9DTE9VRF9UUkFJTF9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJEU19DTFVTVEVSX0RFTEVUSU9OX1BST1RFQ1RJT05fRU5BQkxFRCA9ICdSRFNfQ0xVU1RFUl9ERUxFVElPTl9QUk9URUNUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfSU5TVEFOQ0VfREVMRVRJT05fUFJPVEVDVElPTl9FTkFCTEVEID0gJ1JEU19JTlNUQU5DRV9ERUxFVElPTl9QUk9URUNUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0lOU1RBTkNFX0lBTV9BVVRIRU5USUNBVElPTl9FTkFCTEVEID0gJ1JEU19JTlNUQU5DRV9JQU1fQVVUSEVOVElDQVRJT05fRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfTE9HR0lOR19FTkFCTEVEID0gJ1JEU19MT0dHSU5HX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFRFNISUZUX0JBQ0tVUF9FTkFCTEVEID0gJ1JFRFNISUZUX0JBQ0tVUF9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0VOSEFOQ0VEX01PTklUT1JJTkdfRU5BQkxFRCA9ICdSRFNfRU5IQU5DRURfTU9OSVRPUklOR19FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX1NOQVBTSE9UX0VOQ1JZUFRFRCA9ICdSRFNfU05BUFNIT1RfRU5DUllQVEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVF9SRVFVSVJFX1RMU19TU0wgPSAnUkVEU0hJRlRfUkVRVUlSRV9UTFNfU1NMJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJEU19JTl9CQUNLVVBfUExBTiA9ICdSRFNfSU5fQkFDS1VQX1BMQU4nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJEU19JTlNUQU5DRV9QVUJMSUNfQUNDRVNTX0NIRUNLID0gJ1JEU19JTlNUQU5DRV9QVUJMSUNfQUNDRVNTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfTVVMVElfQVpfU1VQUE9SVCA9ICdSRFNfTVVMVElfQVpfU1VQUE9SVCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfU05BUFNIT1RTX1BVQkxJQ19QUk9ISUJJVEVEID0gJ1JEU19TTkFQU0hPVFNfUFVCTElDX1BST0hJQklURUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX1NUT1JBR0VfRU5DUllQVEVEID0gJ1JEU19TVE9SQUdFX0VOQ1JZUFRFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVF9DTFVTVEVSX0NPTkZJR1VSQVRJT05fQ0hFQ0sgPSAnUkVEU0hJRlRfQ0xVU1RFUl9DT05GSUdVUkFUSU9OX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFRFNISUZUX0NMVVNURVJfTUFJTlRFTkFOQ0VfU0VUVElOR1NfQ0hFQ0sgPSAnUkVEU0hJRlRfQ0xVU1RFUl9NQUlOVEVOQU5DRVNFVFRJTkdTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFRFNISUZUX0NMVVNURVJfUFVCTElDX0FDQ0VTU19DSEVDSyA9ICdSRURTSElGVF9DTFVTVEVSX1BVQkxJQ19BQ0NFU1NfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVRVUlSRURfVEFHUyA9ICdSRVFVSVJFRF9UQUdTJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfU0VDVVJJVFlfR1JPVVBTX1JFU1RSSUNURURfSU5DT01JTkdfVFJBRkZJQyA9ICdSRVNUUklDVEVEX0lOQ09NSU5HX1RSQUZGSUMnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1NFQ1VSSVRZX0dST1VQU19JTkNPTUlOR19TU0hfRElTQUJMRUQgPSAnSU5DT01JTkdfU1NIX0RJU0FCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPT1RfQUNDT1VOVF9IQVJEV0FSRV9NRkFfRU5BQkxFRCA9ICdST09UX0FDQ09VTlRfSEFSRFdBUkVfTUZBX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPT1RfQUNDT1VOVF9NRkFfRU5BQkxFRCA9ICdST09UX0FDQ09VTlRfTUZBX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9ERUZBVUxUX0xPQ0tfRU5BQkxFRCA9ICdTM19CVUNLRVRfREVGQVVMVF9MT0NLX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19ERUZBVUxUX0VOQ1JZUFRJT05fS01TID0gJ1MzX0RFRkFVTFRfRU5DUllQVElPTl9LTVMnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFQ1VSSVRZSFVCX0VOQUJMRUQgPSAnU0VDVVJJVFlIVUJfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTTlNfRU5DUllQVEVEX0tNUyA9ICdTTlNfRU5DUllQVEVEX0tNUyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19BQ0NPVU5UX0xFVkVMX1BVQkxJQ19BQ0NFU1NfQkxPQ0tTID0gJ1MzX0FDQ09VTlRfTEVWRUxfUFVCTElDX0FDQ0VTU19CTE9DS1MnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19CVUNLRVRfQkxPQ0tFRF9BQ1RJT05TX1BST0hJQklURUQgPSAnUzNfQlVDS0VUX0JMQUNLTElTVEVEX0FDVElPTlNfUFJPSElCSVRFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19CVUNLRVRfUE9MSUNZX05PVF9NT1JFX1BFUk1JU1NJVkUgPSAnUzNfQlVDS0VUX1BPTElDWV9OT1RfTU9SRV9QRVJNSVNTSVZFJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUzNfQlVDS0VUX0xPR0dJTkdfRU5BQkxFRCA9ICdTM19CVUNLRVRfTE9HR0lOR19FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9QT0xJQ1lfR1JBTlRFRV9DSEVDSyA9ICdTM19CVUNLRVRfUE9MSUNZX0dSQU5URUVfQ0hFQ0snO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9QVUJMSUNfUkVBRF9QUk9ISUJJVEVEID0gJ1MzX0JVQ0tFVF9QVUJMSUNfUkVBRF9QUk9ISUJJVEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9QVUJMSUNfV1JJVEVfUFJPSElCSVRFRCA9ICdTM19CVUNLRVRfUFVCTElDX1dSSVRFX1BST0hJQklURUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9SRVBMSUNBVElPTl9FTkFCTEVEID0gJ1MzX0JVQ0tFVF9SRVBMSUNBVElPTl9FTkFCTEVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19CVUNLRVRfU0VSVkVSX1NJREVfRU5DUllQVElPTl9FTkFCTEVEID0gJ1MzX0JVQ0tFVF9TRVJWRVJfU0lERV9FTkNSWVBUSU9OX0VOQUJMRUQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUzNfQlVDS0VUX1NTTF9SRVFVRVNUU19PTkxZID0gJ1MzX0JVQ0tFVF9TU0xfUkVRVUVTVFNfT05MWSc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFMzX0JVQ0tFVF9WRVJTSU9OSU5HX0VOQUJMRUQgPSAnUzNfQlVDS0VUX1ZFUlNJT05JTkdfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTQUdFTUFLRVJfRU5EUE9JTlRfQ09ORklHVVJBVElPTl9LTVNfS0VZX0NPTkZJR1VSRUQgPSAnU0FHRU1BS0VSX0VORFBPSU5UX0NPTkZJR1VSQVRJT05fS01TX0tFWV9DT05GSUdVUkVEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNBR0VNQUtFUl9OT1RFQk9PS19JTlNUQU5DRV9LTVNfS0VZX0NPTkZJR1VSRUQgPSAnU0FHRU1BS0VSX05PVEVCT09LX0lOU1RBTkNFX0tNU19LRVlfQ09ORklHVVJFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNBR0VNQUtFUl9OT1RFQk9PS19OT19ESVJFQ1RfSU5URVJORVRfQUNDRVNTID0gJ1NBR0VNQUtFUl9OT1RFQk9PS19OT19ESVJFQ1RfSU5URVJORVRfQUNDRVNTJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VDUkVUU01BTkFHRVJfUk9UQVRJT05fRU5BQkxFRF9DSEVDSyA9ICdTRUNSRVRTTUFOQUdFUl9ST1RBVElPTl9FTkFCTEVEX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFQ1JFVFNNQU5BR0VSX1NDSEVEVUxFRF9ST1RBVElPTl9TVUNDRVNTX0NIRUNLID0gJ1NFQ1JFVFNNQU5BR0VSX1NDSEVEVUxFRF9ST1RBVElPTl9TVUNDRVNTX0NIRUNLJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFUlZJQ0VfVlBDX0VORFBPSU5UX0VOQUJMRUQgPSAnU0VSVklDRV9WUENfRU5EUE9JTlRfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0hJRUxEX0FEVkFOQ0VEX0VOQUJMRURfQVVUT19SRU5FVyA9ICdTSElFTERfQURWQU5DRURfRU5BQkxFRF9BVVRPUkVORVcnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0hJRUxEX0RSVF9BQ0NFU1MgPSAnU0hJRUxEX0RSVF9BQ0NFU1MnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBWUENfREVGQVVMVF9TRUNVUklUWV9HUk9VUF9DTE9TRUQgPSAnVlBDX0RFRkFVTFRfU0VDVVJJVFlfR1JPVVBfQ0xPU0VEJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVlBDX0ZMT1dfTE9HU19FTkFCTEVEID0gJ1ZQQ19GTE9XX0xPR1NfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVlBDX1NHX09QRU5fT05MWV9UT19BVVRIT1JJWkVEX1BPUlRTID0gJ1ZQQ19TR19PUEVOX09OTFlfVE9fQVVUSE9SSVpFRF9QT1JUUyc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFZQQ19WUE5fMl9UVU5ORUxTX1VQID0gJ1ZQQ19WUE5fMl9UVU5ORUxTX1VQJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgV0FGX0NMQVNTSUNfTE9HR0lOR19FTkFCTEVEID0gJ1dBRl9DTEFTU0lDX0xPR0dJTkdfRU5BQkxFRCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgV0FGVjJfTE9HR0lOR19FTkFCTEVEID0gJ1dBRlYyX0xPR0dJTkdfRU5BQkxFRCc7XG4gICAgLy8gdXRpbGl0eSBjbGFzc1xuICAgIHByaXZhdGUgY29uc3RydWN0b3IoKSB7IH1cbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUmVzb3VyY2VUeXBlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQSUdBVEVXQVlfU1RBR0UgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkFwaUdhdGV3YXk6OlN0YWdlJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFQSUdBVEVXQVlWMl9TVEFHRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6QXBpR2F0ZXdheVYyOjpTdGFnZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVBJR0FURVdBWV9SRVNUX0FQSSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6QXBpR2F0ZXdheTo6UmVzdEFwaScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVBJR0FURVdBWVYyX0FQSSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6QXBpR2F0ZXdheVYyOjpBcGknKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VREZST05UX0RJU1RSSUJVVElPTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6Q2xvdWRGcm9udDo6RGlzdHJpYnV0aW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfU1RSRUFNSU5HX0RJU1RSSUJVVElPTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6Q2xvdWRGcm9udDo6U3RyZWFtaW5nRGlzdHJpYnV0aW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFdBVENIX0FMQVJNID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpDbG91ZFdhdGNoOjpBbGFybScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERZTkFNT0RCX1RBQkxFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpEeW5hbW9EQjo6VGFibGUnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVCU19WT0xVTUUgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVDMjo6Vm9sdW1lJyk7XG4gICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfSE9TVCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpIb3N0Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfRUlQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OkVJUCcpO1xuICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9JTlNUQU5DRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpJbnN0YW5jZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9TRUNVUklUWV9HUk9VUCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpTZWN1cml0eUdyb3VwJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX05BVF9HQVRFV0FZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6Ok5hdEdhdGV3YXknKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9FR1JFU1NfT05MWV9JTlRFUk5FVF9HQVRFV0FZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OkVncmVzc09ubHlJbnRlcm5ldEdhdGV3YXknKTtcbiAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfRkxPV19MT0cgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVDMjo6Rmxvd0xvZycpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfVlBDX0VORFBPSU5UID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OlZQQ0VuZHBvaW50Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1ZQQ19FTkRQT0lOVF9TRVJWSUNFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OlZQQ0VuZHBvaW50U2VydmljZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1ZQQ19QRUVSSU5HX0NPTk5FQ1RJT04gPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVDMjo6VlBDUGVlcmluZ0Nvbm5lY3Rpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDU0VBUkNIX0RPTUFJTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RWxhc3RpY3NlYXJjaDo6RG9tYWluJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUUxEQl9MRURHRVIgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlFMREI6OkxlZGdlcicpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfQ0xVU1RFUiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6UmVkc2hpZnQ6OkNsdXN0ZXInKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVF9DTFVTVEVSX1BBUkFNRVRFUl9HUk9VUCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6UmVkc2hpZnQ6OkNsdXN0ZXJQYXJhbWV0ZXJHcm91cCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfQ0xVU1RFUl9TRUNVUklUWV9HUk9VUCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6UmVkc2hpZnQ6OkNsdXN0ZXJTZWN1cml0eUdyb3VwJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRURTSElGVF9DTFVTVEVSX1NOQVBTSE9UID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpSZWRzaGlmdDo6Q2x1c3RlclNuYXBzaG90Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfQ0xVU1RFUl9TVUJORVRfR1JPVVAgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlJlZHNoaWZ0OjpDbHVzdGVyU3VibmV0R3JvdXAnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkVEU0hJRlRfRVZFTlRfU1VCU0NSSVBUSU9OID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpSZWRzaGlmdDo6RXZlbnRTdWJzY3JpcHRpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX0lOU1RBTkNFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpSRFM6OkRCSW5zdGFuY2UnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX1NFQ1VSSVRZX0dST1VQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpSRFM6OkRCU2VjdXJpdHlHcm91cCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfREJfU05BUFNIT1QgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlJEUzo6REJTbmFwc2hvdCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX1NVQk5FVF9HUk9VUCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6UkRTOjpEQlN1Ym5ldEdyb3VwJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBSRFNfRVZFTlRfU1VCU0NSSVBUSU9OID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpSRFM6OkV2ZW50U3Vic2NyaXB0aW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX0NMVVNURVIgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlJEUzo6REJDbHVzdGVyJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUkRTX0RCX0NMVVNURVJfU05BUFNIT1QgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlJEUzo6REJDbHVzdGVyU25hcHNob3QnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1FTX1FVRVVFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTUVM6OlF1ZXVlJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNOU19UT1BJQyA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6U05TOjpUb3BpYycpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTM19CVUNLRVQgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlMzOjpCdWNrZXQnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUzNfQUNDT1VOVF9QVUJMSUNfQUNDRVNTX0JMT0NLID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTMzo6QWNjb3VudFB1YmxpY0FjY2Vzc0Jsb2NrJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX0NVU1RPTUVSX0dBVEVXQVkgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVDMjo6Q3VzdG9tZXJHYXRld2F5Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX0lOVEVSTkVUX0dBVEVXQVkgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVDMjo6Q3VzdG9tZXJHYXRld2F5Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9ORVRXT1JLX0FDTCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpOZXR3b3JrQWNsJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMl9ST1VURV9UQUJMRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpSb3V0ZVRhYmxlJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFQzJfU1VCTkVUID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OlN1Ym5ldCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1ZQQyA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RUMyOjpWUEMnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1ZQTl9DT05ORUNUSU9OID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OlZQTkNvbm5lY3Rpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUMyX1ZQTl9HQVRFV0FZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFQzI6OlZQTkdhdGV3YXknKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVVUT19TQ0FMSU5HX0dST1VQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpBdXRvU2NhbGluZzo6QXV0b1NjYWxpbmdHcm91cCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVVRPX1NDQUxJTkdfTEFVTkNIX0NPTkZJR1VSQVRJT04gPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkF1dG9TY2FsaW5nOjpMYXVuY2hDb25maWd1cmF0aW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBVVRPX1NDQUxJTkdfUE9MSUNZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpBdXRvU2NhbGluZzo6U2NhbGluZ1BvbGljeScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFVVE9fU0NBTElOR19TQ0hFRFVMRURfQUNUSU9OID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpBdXRvU2NhbGluZzo6U2NoZWR1bGVkQWN0aW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBBQ01fQ0VSVElGSUNBVEUgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkFDTTo6Q2VydGlmaWNhdGUnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VREZPUk1BVElPTl9TVEFDSyA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6Q2xvdWRGb3JtYXRpb246OlN0YWNrJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDTE9VRFRSQUlMX1RSQUlMID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpDbG91ZFRyYWlsOjpUcmFpbCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENPREVCVUlMRF9QUk9KRUNUID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpDb2RlQnVpbGQ6OlByb2plY3QnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09ERVBJUEVMSU5FX1BJUEVMSU5FID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpDb2RlUGlwZWxpbmU6OlBpcGVsaW5lJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDX0JFQU5TVEFMS19BUFBMSUNBVElPTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RWxhc3RpY0JlYW5zdGFsazo6QXBwbGljYXRpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRUxBU1RJQ19CRUFOU1RBTEtfQVBQTElDQVRJT05fVkVSU0lPTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RWxhc3RpY0JlYW5zdGFsazo6QXBwbGljYXRpb25WZXJzaW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBFTEFTVElDX0JFQU5TVEFMS19FTlZJUk9OTUVOVCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6RWxhc3RpY0JlYW5zdGFsazo6RW52aXJvbm1lbnQnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBJQU1fVVNFUiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6SUFNOjpVc2VyJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9HUk9VUCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6SUFNOjpHcm91cCcpO1xuICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9ST0xFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpJQU06OlJvbGUnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElBTV9QT0xJQ1kgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OklBTTo6UG9saWN5Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBLTVNfS0VZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpLTVM6OktleScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBMQU1CREFfRlVOQ1RJT04gPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkxhbWJkYTo6RnVuY3Rpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VDUkVUU19NQU5BR0VSX1NFQ1JFVCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6U2VjcmV0c01hbmFnZXI6OlNlY3JldCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNFUlZJQ0VfQ0FUQUxPR19DTE9VREZPUk1BVElPTl9QUk9EVUNUID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTZXJ2aWNlQ2F0YWxvZzo6Q2xvdWRGb3JtYXRpb25Qcm9kdWN0Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VSVklDRV9DQVRBTE9HX0NMT1VERk9STUFUSU9OX1BST1ZJU0lPTkVEX1BST0RVQ1QgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlNlcnZpY2VDYXRhbG9nOjpDbG91ZEZvcm1hdGlvblByb3Zpc2lvbmVkUHJvZHVjdCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU0VSVklDRV9DQVRBTE9HX1BPUlRGT0xJTyA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6U2VydmljZUNhdGFsb2c6OlBvcnRmb2xpbycpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNISUVMRF9QUk9URUNUSU9OID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTaGllbGQ6OlByb3RlY3Rpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBTSElFTERfUkVHSU9OQUxfUFJPVEVDVElPTiA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6U2hpZWxkUmVnaW9uYWw6OlByb3RlY3Rpb24nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1lTVEVNU19NQU5BR0VSX01BTkFHRURfSU5TVEFOQ0VfSU5WRU5UT1JZID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTU006Ok1hbmFnZWRJbnN0YW5jZUludmVudG9yeScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNZU1RFTVNfTUFOQUdFUl9QQVRDSF9DT01QTElBTkNFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTU006OlBhdGNoQ29tcGxpYW5jZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNZU1RFTVNfTUFOQUdFUl9BU1NPQ0lBVElPTl9DT01QTElBTkNFID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpTU006OkFzc29jaWF0aW9uQ29tcGxpYW5jZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1lTVEVNU19NQU5BR0VSX0ZJTEVfREFUQSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6U1NNOjpGaWxlRGF0YScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgV0FGX1JBVEVfQkFTRURfUlVMRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6V0FGOjpSYXRlQmFzZWRSdWxlJyk7XG4gICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgV0FGX1JVTEUgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OldBRjo6UnVsZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFdBRl9XRUJfQUNMID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUY6OldlYkFDTCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFdBRl9SVUxFX0dST1VQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUY6OlJ1bGVHcm91cCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgV0FGX1JFR0lPTkFMX1JBVEVfQkFTRURfUlVMRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6V0FGUmVnaW9uYWw6OlJhdGVCYXNlZFJ1bGUnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQUZfUkVHSU9OQUxfUlVMRSA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6V0FGUmVnaW9uYWw6OlJ1bGUnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQUZfUkVHSU9OQUxfV0VCX0FDTCA9IG5ldyBSZXNvdXJjZVR5cGUoJ0FXUzo6V0FGUmVnaW9uYWw6OldlYkFDTCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFdBRl9SRUdJT05BTF9SVUxFX0dST1VQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUZSZWdpb25hbDo6UnVsZUdyb3VwJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQUZWMl9XRUJfQUNMID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUZ2Mjo6V2ViQUNMJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQUZWMl9SVUxFX0dST1VQID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUZ2Mjo6UnVsZUdyb3VwJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQUZWMl9NQU5BR0VEX1JVTEVfU0VUID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpXQUZ2Mjo6TWFuYWdlZFJ1bGVTZXQnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgWFJBWV9FTkNSWVBUSU9OX0NPTkZJR1VSQVRJT04gPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OlhSYXk6OkVuY3J5cHRpb25Db25maWcnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQl9MT0FEX0JBTEFOQ0VSID0gbmV3IFJlc291cmNlVHlwZSgnQVdTOjpFbGFzdGljTG9hZEJhbGFuY2luZzo6TG9hZEJhbGFuY2VyJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVMQlYyX0xPQURfQkFMQU5DRVIgPSBuZXcgUmVzb3VyY2VUeXBlKCdBV1M6OkVsYXN0aWNMb2FkQmFsYW5jaW5nVjI6OkxvYWRCYWxhbmNlcicpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBzdGF0aWMgb2YodHlwZTogc3RyaW5nKTogUmVzb3VyY2VUeXBlIHtcbiAgICAgICAgcmV0dXJuIG5ldyBSZXNvdXJjZVR5cGUodHlwZSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZWFkb25seSBjb21wbGlhbmNlUmVzb3VyY2VUeXBlOiBzdHJpbmc7XG4gICAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcih0eXBlOiBzdHJpbmcpIHtcbiAgICAgICAgdGhpcy5jb21wbGlhbmNlUmVzb3VyY2VUeXBlID0gdHlwZTtcbiAgICB9XG59XG5mdW5jdGlvbiByZW5kZXJTY29wZShydWxlU2NvcGU/OiBSdWxlU2NvcGUpOiBDZm5Db25maWdSdWxlLlNjb3BlUHJvcGVydHkgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiBydWxlU2NvcGUgPyB7XG4gICAgICAgIGNvbXBsaWFuY2VSZXNvdXJjZUlkOiBydWxlU2NvcGUucmVzb3VyY2VJZCxcbiAgICAgICAgY29tcGxpYW5jZVJlc291cmNlVHlwZXM6IHJ1bGVTY29wZS5yZXNvdXJjZVR5cGVzPy5tYXAocmVzb3VyY2UgPT4gcmVzb3VyY2UuY29tcGxpYW5jZVJlc291cmNlVHlwZSksXG4gICAgICAgIHRhZ0tleTogcnVsZVNjb3BlLmtleSxcbiAgICAgICAgdGFnVmFsdWU6IHJ1bGVTY29wZS52YWx1ZSxcbiAgICB9IDogdW5kZWZpbmVkO1xufVxuIl19