import * as iam from "../../aws-iam";
import * as sns from "../../aws-sns";
import { Duration } from "../../core";
import { Construct } from 'constructs';
import { ManagedRule, RuleProps } from './rule';
/**
 * (experimental) Construction properties for a AccessKeysRotated.
 *
 * @experimental
 */
export interface AccessKeysRotatedProps extends RuleProps {
    /**
     * (experimental) The maximum number of days within which the access keys must be rotated.
     *
     * @default Duration.days(90)
     * @experimental
     */
    readonly maxAge?: Duration;
}
/**
 * (experimental) Checks whether the active access keys are rotated within the number of days specified in `maxAge`.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
export declare class AccessKeysRotated extends ManagedRule {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: AccessKeysRotatedProps);
}
/**
 * (experimental) Construction properties for a CloudFormationStackDriftDetectionCheck.
 *
 * @experimental
 */
export interface CloudFormationStackDriftDetectionCheckProps extends RuleProps {
    /**
     * (experimental) Whether to check only the stack where this rule is deployed.
     *
     * @default false
     * @experimental
     */
    readonly ownStackOnly?: boolean;
    /**
     * (experimental) The IAM role to use for this rule.
     *
     * It must have permissions to detect drift
     * for AWS CloudFormation stacks. Ensure to attach `config.amazonaws.com` trusted
     * permissions and `ReadOnlyAccess` policy permissions. For specific policy permissions,
     * refer to https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html.
     *
     * @default - A role will be created
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Checks whether your CloudFormation stacks' actual configuration differs, or has drifted, from its expected configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
export declare class CloudFormationStackDriftDetectionCheck extends ManagedRule {
    private readonly role;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CloudFormationStackDriftDetectionCheckProps);
}
/**
 * (experimental) Construction properties for a CloudFormationStackNotificationCheck.
 *
 * @experimental
 */
export interface CloudFormationStackNotificationCheckProps extends RuleProps {
    /**
     * (experimental) A list of allowed topics.
     *
     * At most 5 topics.
     *
     * @default - No topics.
     * @experimental
     */
    readonly topics?: sns.ITopic[];
}
/**
 * (experimental) Checks whether your CloudFormation stacks are sending event notifications to a SNS topic.
 *
 * Optionally checks whether specified SNS topics are used.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html
 * @experimental
 * @resource AWS::Config::ConfigRule
 */
export declare class CloudFormationStackNotificationCheck extends ManagedRule {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CloudFormationStackNotificationCheckProps);
}
