import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
/**
 * (experimental) Represents a Cognito user pool resource server.
 *
 * @experimental
 */
export interface IUserPoolResourceServer extends IResource {
    /**
     * (experimental) Resource server id.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolResourceServerId: string;
}
/**
 * (experimental) Props to initialize ResourceServerScope.
 *
 * @experimental
 */
export interface ResourceServerScopeProps {
    /**
     * (experimental) The name of the scope.
     *
     * @experimental
     */
    readonly scopeName: string;
    /**
     * (experimental) A description of the scope.
     *
     * @experimental
     */
    readonly scopeDescription: string;
}
/**
 * (experimental) A scope for ResourceServer.
 *
 * @experimental
 */
export declare class ResourceServerScope {
    /**
     * (experimental) The name of the scope.
     *
     * @experimental
     */
    readonly scopeName: string;
    /**
     * (experimental) A description of the scope.
     *
     * @experimental
     */
    readonly scopeDescription: string;
    /**
     * @experimental
     */
    constructor(props: ResourceServerScopeProps);
}
/**
 * (experimental) Options to create a UserPoolResourceServer.
 *
 * @experimental
 */
export interface UserPoolResourceServerOptions {
    /**
     * (experimental) A unique resource server identifier for the resource server.
     *
     * @experimental
     */
    readonly identifier: string;
    /**
     * (experimental) A friendly name for the resource server.
     *
     * @default - same as `identifier`
     * @experimental
     */
    readonly userPoolResourceServerName?: string;
    /**
     * (experimental) Oauth scopes.
     *
     * @default - No scopes will be added
     * @experimental
     */
    readonly scopes?: ResourceServerScope[];
}
/**
 * (experimental) Properties for the UserPoolResourceServer construct.
 *
 * @experimental
 */
export interface UserPoolResourceServerProps extends UserPoolResourceServerOptions {
    /**
     * (experimental) The user pool to add this resource server to.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
}
/**
 * (experimental) Defines a User Pool OAuth2.0 Resource Server.
 *
 * @experimental
 */
export declare class UserPoolResourceServer extends Resource implements IUserPoolResourceServer {
    /**
     * (experimental) Import a user pool resource client given its id.
     *
     * @experimental
     */
    static fromUserPoolResourceServerId(scope: Construct, id: string, userPoolResourceServerId: string): IUserPoolResourceServer;
    /**
     * (experimental) Resource server id.
     *
     * @experimental
     */
    readonly userPoolResourceServerId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolResourceServerProps);
}
