"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderBase = void 0;
const core_1 = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
const attr_names_1 = require("../../private/attr-names");
/**
 * Options to integrate with the various social identity providers.
 *
 * @internal
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    /**
     * @experimental
     */
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
exports.UserPoolIdentityProviderBase = UserPoolIdentityProviderBase;
//# sourceMappingURL=data:application/json;base64,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