"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderApple = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cognito_generated_1 = require("../cognito.generated");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
/**
 * (experimental) Represents a identity provider that integrates with 'Apple'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderApple extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        const scopes = (_b = props.scopes) !== null && _b !== void 0 ? _b : ['name'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'SignInWithApple',
            providerType: 'SignInWithApple',
            providerDetails: {
                client_id: props.clientId,
                team_id: props.teamId,
                key_id: props.keyId,
                private_key: props.privateKey,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderApple = UserPoolIdentityProviderApple;
_a = JSII_RTTI_SYMBOL_1;
UserPoolIdentityProviderApple[_a] = { fqn: "monocdk.aws_cognito.UserPoolIdentityProviderApple", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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